/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.util.Pair;

public class ExtendedARGPath
extends ARGPath {
    private final UsageInfo usage;
    private final Set<ConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>>> refinedAsTrueBy = new HashSet<ConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>>>();
    private boolean isUnreachable = false;

    public ExtendedARGPath(ARGPath origin, UsageInfo target) {
        super((List<ARGState>)origin.asStatesList(), origin.getInnerEdges());
        this.usage = target;
    }

    public UsageInfo getUsageInfo() {
        return this.usage;
    }

    public void setAsTrueBy(ConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>> refiner) {
        this.refinedAsTrueBy.add(refiner);
    }

    public void setAsFalse() {
        this.isUnreachable = true;
    }

    public boolean isRefinedAsReachableBy(ConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>> refiner) {
        return this.refinedAsTrueBy.contains(refiner);
    }

    public boolean isUnreachable() {
        return this.isUnreachable;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + Objects.hash(this.isUnreachable, this.refinedAsTrueBy, this.usage);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof ExtendedARGPath) {
            ExtendedARGPath other = (ExtendedARGPath)((Object)obj);
            return this.isUnreachable == other.isUnreachable && Objects.equals(this.refinedAsTrueBy, other.refinedAsTrueBy) && Objects.equals(this.usage, other.usage);
        }
        return false;
    }
}

