/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.errorprone.annotations.ForOverride;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ExtendedARGPath;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementResult;
import org.sosy_lab.cpachecker.cpa.usage.refinement.WrappedConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public abstract class GenericFilter<P>
extends WrappedConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>, Pair<ExtendedARGPath, ExtendedARGPath>> {
    StatTimer totalTimer = new StatTimer("Time for generic filter");
    StatCounter filteredPairs = new StatCounter("Number of filtered pairs");
    private String mainFunction = "ldv_main";
    Predicate<ARGState> isFirstCall = s -> {
        CallstackState callstack;
        CFANode location = AbstractStates.extractLocation(s);
        return location instanceof CFunctionEntryNode && (callstack = AbstractStates.extractStateByType(s, CallstackState.class)).getPreviousState() != null && callstack.getPreviousState().getCurrentFunction().equals(this.mainFunction);
    };
    Function<ARGState, String> getFunctionName = s -> AbstractStates.extractLocation(s).getFunctionName();

    protected GenericFilter(ConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>> pWrapper, Configuration pConfig) {
        super(pWrapper);
        this.mainFunction = pConfig.getProperty("analysis.entryFunction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefinementResult performBlockRefinement(Pair<ExtendedARGPath, ExtendedARGPath> pInput) throws CPAException, InterruptedException {
        this.totalTimer.start();
        try {
            ExtendedARGPath firstPath = pInput.getFirst();
            ExtendedARGPath secondPath = pInput.getSecond();
            P firstPathCore = this.getPathCore(firstPath);
            P secondPathCore = this.getPathCore(secondPath);
            Boolean b = this.filter(firstPathCore, secondPathCore);
            if (b.booleanValue()) {
                RefinementResult refinementResult = this.wrappedRefiner.performBlockRefinement(pInput);
                return refinementResult;
            }
            this.filteredPairs.inc();
            RefinementResult refinementResult = RefinementResult.createFalse();
            return refinementResult;
        }
        finally {
            this.totalTimer.stop();
        }
    }

    protected abstract Boolean filter(P var1, P var2);

    protected abstract P getPathCore(ExtendedARGPath var1);

    @ForOverride
    protected void printAdditionalStatistics(StatisticsWriter pOut) {
    }

    @Override
    public final void printStatistics(StatisticsWriter pOut) {
        StatisticsWriter newWriter = pOut.spacer().put(this.totalTimer).put(this.filteredPairs);
        this.printAdditionalStatistics(newWriter);
        this.wrappedRefiner.printStatistics(newWriter);
    }
}

