/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import com.google.errorprone.annotations.ForOverride;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementResult;
import org.sosy_lab.cpachecker.cpa.usage.refinement.WrappedConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public abstract class GenericIterator<I, O>
extends WrappedConfigurableRefinementBlock<I, O> {
    private StatTimer totalTimer = new StatTimer("Time for generic iterator");
    private StatCounter numOfIterations = new StatCounter("Number of iterations");
    PredicatePrecision completePrecision;
    List<O> postponedIterations = new ArrayList<O>();

    protected GenericIterator(ConfigurableRefinementBlock<O> pWrapper) {
        super(pWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RefinementResult performBlockRefinement(I pInput) throws CPAException, InterruptedException {
        this.totalTimer.start();
        this.completePrecision = PredicatePrecision.empty();
        RefinementResult result = RefinementResult.createFalse();
        this.init(pInput);
        try {
            O iteration;
            while ((iteration = this.getNext(pInput)) != null) {
                result = this.iterate(iteration);
                if (!result.isTrue()) continue;
                RefinementResult refinementResult = result;
                return refinementResult;
            }
            for (O i : this.postponedIterations) {
                result = this.iterate(i);
                if (!result.isTrue()) continue;
                RefinementResult refinementResult = result;
                return refinementResult;
            }
            result.addPrecision(this.completePrecision);
            RefinementResult refinementResult = result;
            return refinementResult;
        }
        finally {
            this.finish(pInput, result);
            this.sendFinishSignal();
            this.postponedIterations.clear();
            this.totalTimer.stop();
        }
    }

    private RefinementResult iterate(O iteration) throws CPAException, InterruptedException {
        this.numOfIterations.inc();
        RefinementResult result = this.wrappedRefiner.performBlockRefinement(iteration);
        if (result.isTrue()) {
            result.addPrecision(this.completePrecision);
            return result;
        }
        PredicatePrecision precision = result.getPrecision();
        if (precision != null) {
            this.completePrecision = this.completePrecision.mergeWith(precision);
        }
        this.finishIteration(iteration, result);
        return result;
    }

    protected abstract O getNext(I var1);

    protected void init(I pInput) {
    }

    protected void finish(I pInput, RefinementResult pResult) {
    }

    @ForOverride
    protected void finishIteration(O output, RefinementResult r) {
    }

    @ForOverride
    protected void printDetailedStatistics(StatisticsWriter pOut) {
    }

    @Override
    public final void printStatistics(StatisticsWriter pOut) {
        StatisticsWriter writer = pOut.spacer().put(this.totalTimer).put(this.numOfIterations);
        this.printDetailedStatistics(writer);
        this.wrappedRefiner.printStatistics(writer);
    }

    protected void postpone(O i) {
        this.postponedIterations.add(i);
    }
}

