/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ForOverride;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ExtendedARGPath;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementResult;
import org.sosy_lab.cpachecker.cpa.usage.refinement.WrappedConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public abstract class GenericSinglePathRefiner
extends WrappedConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>, Pair<ExtendedARGPath, ExtendedARGPath>> {
    private StatTimer totalTimer = new StatTimer("Time for generic refiner");
    private StatCounter numberOfRefinements = new StatCounter("Number of refinements");
    private StatCounter numberOfRepeatedPath = new StatCounter("Number of repeated paths");

    protected GenericSinglePathRefiner(ConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>> pWrapper) {
        super(pWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RefinementResult performBlockRefinement(Pair<ExtendedARGPath, ExtendedARGPath> pInput) throws CPAException, InterruptedException {
        this.totalTimer.start();
        try {
            ExtendedARGPath firstPath = pInput.getFirst();
            ExtendedARGPath secondPath = pInput.getSecond();
            RefinementResult result = this.refinePath(firstPath);
            if (result.isFalse()) {
                RefinementResult refinementResult = result;
                return refinementResult;
            }
            PredicatePrecision completePrecision = result.getPrecision();
            result = this.refinePath(secondPath);
            completePrecision = completePrecision.mergeWith(result.getPrecision());
            if (!result.isFalse()) {
                result = this.wrappedRefiner.performBlockRefinement(pInput);
            }
            result.addPrecision(completePrecision);
            RefinementResult refinementResult = result;
            return refinementResult;
        }
        finally {
            this.totalTimer.stop();
        }
    }

    private RefinementResult refinePath(ExtendedARGPath path) throws CPAException, InterruptedException {
        Preconditions.checkArgument((!path.isUnreachable() ? 1 : 0) != 0, (Object)"Path could not be unreachable here");
        if (path.isRefinedAsReachableBy(this)) {
            this.numberOfRepeatedPath.inc();
            return RefinementResult.createTrue();
        }
        this.numberOfRefinements.inc();
        RefinementResult result = this.call(path);
        if (result.isTrue() || result.isUnknown()) {
            path.setAsTrueBy(this);
            return result;
        }
        path.setAsFalse();
        return result;
    }

    @Override
    public final void printStatistics(StatisticsWriter pOut) {
        StatisticsWriter writer = pOut.spacer().put(this.totalTimer).put(this.numberOfRefinements).put(this.numberOfRepeatedPath);
        this.printAdditionalStatistics(writer);
        this.wrappedRefiner.printStatistics(writer);
    }

    @ForOverride
    protected void printAdditionalStatistics(StatisticsWriter pOut) {
    }

    protected abstract RefinementResult call(ExtendedARGPath var1) throws CPAException, InterruptedException;
}

