/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AdjustablePrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelation;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.usage.UsageCPA;
import org.sosy_lab.cpachecker.cpa.usage.UsageReachedSet;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.PointIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.PredicateRefinerAdapter;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementBlockFactory;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementResult;
import org.sosy_lab.cpachecker.cpa.usage.refinement.WrappedConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageContainer;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.usage")
public class IdentifierIterator
extends WrappedConfigurableRefinementBlock<ReachedSet, SingleIdentifier>
implements Refiner {
    private final ConfigurableProgramAnalysis cpa;
    private final LogManager logger;
    @Option(name="precisionReset", description="The value of marked unsafes, after which the precision should be cleaned", secure=true)
    private int precisionReset = Integer.MAX_VALUE;
    @Option(name="totalARGCleaning", description="clean all ARG or try to reuse some parts of it (memory consuming)", secure=true)
    private boolean totalARGCleaning = true;
    @Option(name="hideFilteredUnsafes", description="filtered unsafes, which can not be removed using precision, may be hidden", secure=true)
    private boolean hideFilteredUnsafes = false;
    private final BAMTransferRelation transfer;
    int i = 0;
    int lastFalseUnsafeSize = -1;
    int lastTrueUnsafes = 0;
    private final Map<SingleIdentifier, AdjustablePrecision> precisionMap = new HashMap<SingleIdentifier, AdjustablePrecision>();

    public IdentifierIterator(ConfigurableRefinementBlock<SingleIdentifier> pWrapper, Configuration config, ConfigurableProgramAnalysis pCpa, BAMTransferRelation pTransfer) throws InvalidConfigurationException {
        super(pWrapper);
        config.inject((Object)this);
        this.cpa = pCpa;
        UsageCPA uCpa = CPAs.retrieveCPA(pCpa, UsageCPA.class);
        uCpa.getStats().setBAMCPA((BAMCPA)this.cpa);
        this.logger = uCpa.getLogger();
        this.transfer = pTransfer;
    }

    public static Refiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        if (!(pCpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException(BAMPredicateRefiner.class.getSimpleName() + " could not find the PredicateCPA");
        }
        BAMPredicateCPA predicateCpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(BAMPredicateCPA.class);
        if (predicateCpa == null) {
            throw new InvalidConfigurationException(BAMPredicateRefiner.class.getSimpleName() + " needs an BAMPredicateCPA");
        }
        return new RefinementBlockFactory(pCpa, predicateCpa.getConfiguration()).create();
    }

    @Override
    public RefinementResult performBlockRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        UsageReachedSet uReached = (UsageReachedSet)pReached;
        UsageContainer container = uReached.getUsageContainer();
        HashSet<SingleIdentifier> processedUnsafes = new HashSet<SingleIdentifier>();
        this.logger.log(Level.INFO, new Object[]{"Perform US refinement: " + this.i++});
        int originUnsafeSize = container.getTotalUnsafeSize();
        if (this.lastFalseUnsafeSize == -1) {
            this.lastFalseUnsafeSize = originUnsafeSize;
        }
        int counter = this.lastFalseUnsafeSize - originUnsafeSize;
        boolean newPrecisionFound = false;
        this.sendUpdateSignal(PredicateRefinerAdapter.class, pReached);
        this.sendUpdateSignal(PointIterator.class, container);
        Iterator<SingleIdentifier> iterator = container.getUnrefinedUnsafeIterator();
        boolean isPrecisionChanged = false;
        AbstractState firstState = pReached.getFirstState();
        AdjustablePrecision finalPrecision = (AdjustablePrecision)pReached.getPrecision(firstState);
        while (iterator.hasNext()) {
            SingleIdentifier currentId = iterator.next();
            RefinementResult result = this.wrappedRefiner.performBlockRefinement(currentId);
            newPrecisionFound |= result.isFalse();
            PredicatePrecision info = result.getPrecision();
            if (!info.isEmpty()) {
                Object updatedPrecision = this.precisionMap.containsKey(currentId) ? this.precisionMap.get(currentId).add(info) : info;
                this.precisionMap.put(currentId, (AdjustablePrecision)updatedPrecision);
                finalPrecision = finalPrecision.add((AdjustablePrecision)updatedPrecision);
                isPrecisionChanged = true;
            }
            if (result.isTrue()) {
                container.setAsRefined(currentId, result);
                processedUnsafes.add(currentId);
                continue;
            }
            if (!this.hideFilteredUnsafes || !result.isFalse() || isPrecisionChanged) continue;
            container.setAsFalseUnsafe(currentId);
            processedUnsafes.add(currentId);
        }
        int newTrueUnsafeSize = container.getProcessedUnsafeSize();
        if ((counter += newTrueUnsafeSize - this.lastTrueUnsafes) >= this.precisionReset) {
            Precision p = pReached.getPrecision(pReached.getFirstState());
            pReached.updatePrecision(pReached.getFirstState(), Precisions.replaceByType(p, PredicatePrecision.empty(), (Predicate<? super Precision>)Predicates.instanceOf(PredicatePrecision.class)));
            this.lastFalseUnsafeSize = originUnsafeSize;
            this.lastTrueUnsafes = newTrueUnsafeSize;
        }
        if (newPrecisionFound) {
            BAMPredicateCPA bamcpa = CPAs.retrieveCPA(this.cpa, BAMPredicateCPA.class);
            assert (bamcpa != null);
            bamcpa.clearAllCaches();
            if (this.totalARGCleaning) {
                this.transfer.cleanCaches();
            }
            pReached.clear();
            processedUnsafes.addAll((Collection<SingleIdentifier>)Sets.intersection(this.precisionMap.keySet(), container.getFalseUnsafes()));
            for (AdjustablePrecision prec : FluentIterable.from(processedUnsafes).transform(this.precisionMap::remove).filter(Predicates.notNull())) {
                finalPrecision = finalPrecision.subtract(prec);
            }
            CFANode firstNode = AbstractStates.extractLocation(firstState);
            pReached.add(this.cpa.getInitialState(firstNode, StateSpacePartition.getDefaultPartition()), finalPrecision);
            this.sendFinishSignal();
        }
        if (newPrecisionFound) {
            return RefinementResult.createTrue();
        }
        return RefinementResult.createFalse();
    }

    @Override
    public void printStatistics(StatisticsWriter pOut) {
        this.wrappedRefiner.printStatistics(pOut);
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(new Stats());
        super.collectStatistics(statsCollection);
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        return this.performBlockRefinement(pReached).isTrue();
    }

    private class Stats
    implements Statistics {
        private Stats() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut);
            IdentifierIterator.this.printStatistics(writer);
        }

        @Override
        public String getName() {
            return "UsageStatisticsRefiner";
        }
    }
}

