/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMMultipleCEXSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.bam.BAMSubgraphIterator;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ExtendedARGPath;
import org.sosy_lab.cpachecker.cpa.usage.refinement.GenericIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.IdentifierIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.PointIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.PredicateRefinerAdapter;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementBlockFactory;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementInterface;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementResult;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class PathPairIterator
extends GenericIterator<Pair<UsageInfo, UsageInfo>, Pair<ExtendedARGPath, ExtendedARGPath>> {
    private final Set<List<Integer>> refinedStates = new HashSet<List<Integer>>();
    private final BAMCPA bamCpa;
    private BAMMultipleCEXSubgraphComputer subgraphComputer;
    private final IdentityHashMap<UsageInfo, BAMSubgraphIterator> targetToPathIterator;
    private StatTimer computingPath = new StatTimer("Time for path computing");
    private StatTimer additionTimerCheck = new StatTimer("Time for addition checks");
    private StatCounter numberOfPathCalculated = new StatCounter("Number of path calculated");
    private StatCounter numberOfPathFinished = new StatCounter("Number of new path calculated");
    private StatCounter numberOfRepeatedConstructedPaths = new StatCounter("Number of repeated path computed");
    private IdentityHashMap<UsageInfo, List<ExtendedARGPath>> computedPathsForUsage = new IdentityHashMap();
    private IdentityHashMap<UsageInfo, Iterator<ExtendedARGPath>> currentIterators = new IdentityHashMap();
    private final Function<ARGState, Integer> idExtractor;
    private ExtendedARGPath firstPath = null;

    public PathPairIterator(ConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>> pWrapper, BAMCPA pBamCpa, RefinementBlockFactory.PathEquation type) throws InvalidConfigurationException {
        super(pWrapper);
        this.bamCpa = pBamCpa;
        switch (type) {
            case ARGStateId: {
                this.idExtractor = ARGState::getStateId;
                break;
            }
            case CFANodeId: {
                this.idExtractor = s -> AbstractStates.extractLocation(s).getNodeNumber();
                break;
            }
            default: {
                throw new InvalidConfigurationException("Unexpexted type " + type);
            }
        }
        this.targetToPathIterator = new IdentityHashMap();
    }

    @Override
    protected void init(Pair<UsageInfo, UsageInfo> pInput) {
        this.firstPath = null;
        this.subgraphComputer = this.bamCpa.createBAMMultipleSubgraphComputer(this.idExtractor);
    }

    @Override
    protected Pair<ExtendedARGPath, ExtendedARGPath> getNext(Pair<UsageInfo, UsageInfo> pInput) {
        ExtendedARGPath secondPath;
        UsageInfo firstUsage = pInput.getFirst();
        UsageInfo secondUsage = pInput.getSecond();
        if (this.firstPath == null) {
            this.firstPath = this.getNextPath(firstUsage);
            if (this.firstPath == null) {
                return null;
            }
        }
        if ((secondPath = this.getNextPath(secondUsage)) == null) {
            this.currentIterators.remove(secondUsage);
            this.firstPath = this.getNextPath(firstUsage);
            if (this.firstPath == null) {
                return null;
            }
            secondPath = this.getNextPath(secondUsage);
            if (secondPath == null) {
                return null;
            }
        }
        return Pair.of(this.firstPath, secondPath);
    }

    private boolean checkIsUsageUnreachable(UsageInfo pInput) {
        return !this.computedPathsForUsage.containsKey(pInput) || this.computedPathsForUsage.get(pInput).isEmpty();
    }

    @Override
    protected void finishIteration(Pair<ExtendedARGPath, ExtendedARGPath> pathPair, RefinementResult wrapperResult) {
        ExtendedARGPath firstExtendedPath = pathPair.getFirst();
        ExtendedARGPath secondExtendedPath = pathPair.getSecond();
        Object predicateInfo = wrapperResult.getInfo(PredicateRefinerAdapter.class);
        if (predicateInfo instanceof List) {
            List affectedStates = (List)predicateInfo;
            if (firstExtendedPath.isUnreachable()) {
                this.handleAffectedStates(affectedStates);
                this.firstPath = null;
            } else {
                Preconditions.checkArgument((boolean)secondExtendedPath.isUnreachable(), (Object)"Either the first path, or the second one must be unreachable here");
                this.handleAffectedStates(affectedStates);
            }
        } else if (this.firstPath.isUnreachable()) {
            this.firstPath = null;
        }
        this.updateTheComputedSet(firstExtendedPath);
        this.updateTheComputedSet(secondExtendedPath);
    }

    @Override
    protected void finish(Pair<UsageInfo, UsageInfo> pInput, RefinementResult pResult) {
        UsageInfo firstUsage = pInput.getFirst();
        UsageInfo secondUsage = pInput.getSecond();
        ArrayList<UsageInfo> unreacheableUsages = new ArrayList<UsageInfo>(2);
        if (this.checkIsUsageUnreachable(firstUsage)) {
            unreacheableUsages.add(firstUsage);
        }
        if (this.checkIsUsageUnreachable(secondUsage)) {
            unreacheableUsages.add(secondUsage);
        }
        pResult.addInfo(this.getClass(), unreacheableUsages);
    }

    @Override
    protected void printDetailedStatistics(StatisticsWriter pOut) {
        pOut.spacer().put(this.computingPath).put(this.additionTimerCheck).put(this.numberOfPathCalculated).put(this.numberOfPathFinished).put(this.numberOfRepeatedConstructedPaths);
    }

    @Override
    protected void handleFinishSignal(Class<? extends RefinementInterface> callerClass) {
        if (callerClass.equals(IdentifierIterator.class)) {
            this.refinedStates.clear();
            this.targetToPathIterator.clear();
            this.firstPath = null;
            this.subgraphComputer = null;
        } else if (callerClass.equals(PointIterator.class)) {
            this.currentIterators.clear();
            this.computedPathsForUsage.clear();
        }
    }

    private void updateTheComputedSet(ExtendedARGPath path) {
        List<ExtendedARGPath> alreadyComputedPaths;
        UsageInfo usage = path.getUsageInfo();
        boolean alreadyComputed = this.computedPathsForUsage.containsKey(usage);
        if (!path.isUnreachable()) {
            List<Object> alreadyComputedPaths2;
            if (!alreadyComputed) {
                alreadyComputedPaths2 = new ArrayList();
                this.computedPathsForUsage.put(usage, alreadyComputedPaths2);
            } else {
                alreadyComputedPaths2 = this.computedPathsForUsage.get(usage);
            }
            if (!alreadyComputedPaths2.contains((Object)path)) {
                alreadyComputedPaths2.add((Object)path);
            }
        } else if (path.isUnreachable() && alreadyComputed && (alreadyComputedPaths = this.computedPathsForUsage.get(usage)).contains((Object)path)) {
            alreadyComputedPaths.remove((Object)path);
        }
    }

    private ExtendedARGPath getNextPath(UsageInfo info) {
        BAMSubgraphIterator pathIterator;
        Iterator<ExtendedARGPath> iterator = this.currentIterators.get(info);
        if (iterator == null && this.computedPathsForUsage.containsKey(info)) {
            iterator = new ArrayList(this.computedPathsForUsage.get(info)).iterator();
            this.currentIterators.put(info, iterator);
        }
        if (iterator != null && iterator.hasNext()) {
            return iterator.next();
        }
        this.computingPath.start();
        if (this.targetToPathIterator.containsKey(info)) {
            pathIterator = this.targetToPathIterator.get(info);
        } else {
            ARGState target = (ARGState)info.getKeyState();
            pathIterator = this.subgraphComputer.iterator(target);
            this.targetToPathIterator.put(info, pathIterator);
        }
        ARGPath currentPath = pathIterator.nextPath(this.refinedStates);
        this.computingPath.stop();
        if (currentPath == null) {
            return null;
        }
        return new ExtendedARGPath(currentPath, info);
    }

    private void handleAffectedStates(List<ARGState> affectedStates) {
        ImmutableList changedStateNumbers = Collections3.transformedImmutableListCopy(affectedStates, this.idExtractor);
        this.refinedStates.add((List<Integer>)changedStateNumbers);
    }
}

