/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.GenericIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.IdentifierIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementInterface;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementResult;
import org.sosy_lab.cpachecker.cpa.usage.storage.AbstractUsagePointSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.UnrefinedUsagePointSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.UnsafeDetector;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageContainer;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageInfoSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsagePoint;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class PointIterator
extends GenericIterator<SingleIdentifier, Pair<UsageInfoSet, UsageInfoSet>> {
    private UsageContainer container;
    private UnsafeDetector detector;
    private UsagePoint firstPoint;
    private UsagePoint secondPoint;
    private Iterator<UsagePoint> firstPointIterator;
    private Iterator<UsagePoint> secondPointIterator;
    private UnrefinedUsagePointSet currentUsagePointSet;
    private Set<UsagePoint> toRemove = new HashSet<UsagePoint>();

    public PointIterator(ConfigurableRefinementBlock<Pair<UsageInfoSet, UsageInfoSet>> pWrapper) {
        super(pWrapper);
    }

    @Override
    protected void init(SingleIdentifier id) {
        AbstractUsagePointSet pointSet = this.container.getUsages(id);
        assert (pointSet instanceof UnrefinedUsagePointSet);
        this.currentUsagePointSet = (UnrefinedUsagePointSet)pointSet;
        this.firstPointIterator = this.currentUsagePointSet.getPointIterator();
        this.secondPointIterator = this.currentUsagePointSet.getPointIterator();
        this.firstPoint = this.firstPointIterator.next();
        this.secondPoint = this.secondPointIterator.next();
        assert (this.firstPoint != null);
        assert (this.secondPoint == this.firstPoint);
        if (this.detector.isUnsafePair(this.firstPoint, this.secondPoint)) {
            Pair<UsageInfoSet, UsageInfoSet> resultingPair = this.prepareIterationPair(this.firstPoint, this.secondPoint);
            this.postpone(resultingPair);
        }
    }

    @Override
    protected Pair<UsageInfoSet, UsageInfoSet> getNext(SingleIdentifier pInput) {
        AbstractUsagePointSet pointSet = this.container.getUsages(pInput);
        assert (this.currentUsagePointSet == pointSet);
        do {
            if (!this.secondPointIterator.hasNext()) {
                if (!this.firstPointIterator.hasNext()) {
                    return null;
                }
                this.firstPoint = this.firstPointIterator.next();
                this.secondPointIterator = this.currentUsagePointSet.getPointIteratorFrom(this.firstPoint);
                assert (this.secondPointIterator.hasNext());
            }
            this.secondPoint = this.secondPointIterator.next();
            assert (this.firstPoint != null && this.secondPoint != null);
        } while (!this.detector.isUnsafePair(this.firstPoint, this.secondPoint) || this.toRemove.contains(this.firstPoint) || this.toRemove.contains(this.secondPoint));
        Pair<UsageInfoSet, UsageInfoSet> resultingPair = this.prepareIterationPair(this.firstPoint, this.secondPoint);
        if (this.firstPoint == this.secondPoint) {
            this.postpone(resultingPair);
            return this.getNext(pInput);
        }
        return resultingPair;
    }

    private Pair<UsageInfoSet, UsageInfoSet> prepareIterationPair(UsagePoint first, UsagePoint second) {
        UsageInfoSet secondUsageInfoSet;
        UsageInfoSet firstUsageInfoSet = this.currentUsagePointSet.getUsageInfo(first);
        if (firstUsageInfoSet == (secondUsageInfoSet = this.currentUsagePointSet.getUsageInfo(second))) {
            secondUsageInfoSet = secondUsageInfoSet.copy();
        }
        assert (secondUsageInfoSet != null);
        return Pair.of(firstUsageInfoSet, secondUsageInfoSet);
    }

    @Override
    protected void finish(SingleIdentifier pId, RefinementResult r) {
        this.toRemove.forEach(this.currentUsagePointSet::remove);
        this.toRemove.clear();
    }

    @Override
    protected void finishIteration(Pair<UsageInfoSet, UsageInfoSet> pPair, RefinementResult r) {
        UsageInfoSet firstUsageInfoSet = pPair.getFirst();
        UsageInfoSet secondUsageInfoSet = pPair.getSecond();
        if (firstUsageInfoSet.isEmpty()) {
            this.toRemove.add(this.firstPoint);
        }
        if (secondUsageInfoSet.isEmpty()) {
            this.toRemove.add(this.secondPoint);
        }
    }

    @Override
    protected void handleUpdateSignal(Class<? extends RefinementInterface> pCallerClass, Object pData) {
        if (pCallerClass.equals(IdentifierIterator.class)) {
            assert (pData instanceof UsageContainer);
            this.container = (UsageContainer)pData;
            this.detector = this.container.getUnsafeDetector();
        }
    }

    @Override
    protected void handleFinishSignal(Class<? extends RefinementInterface> pCallerClass) {
        if (pCallerClass.equals(IdentifierIterator.class)) {
            this.firstPointIterator = null;
            this.secondPointIterator = null;
            this.firstPoint = null;
            this.secondPoint = null;
        }
    }

    @Override
    protected void printDetailedStatistics(StatisticsWriter pOut) {
    }
}

