/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.BAMBlockFormulaStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateAbstractionRefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.BAMPredicateRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPARefinerFactory;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ExtendedARGPath;
import org.sosy_lab.cpachecker.cpa.usage.refinement.GenericSinglePathRefiner;
import org.sosy_lab.cpachecker.cpa.usage.refinement.IdentifierIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementInterface;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementResult;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class PredicateRefinerAdapter
extends GenericSinglePathRefiner {
    ARGBasedRefiner refiner;
    LogManager logger;
    private final UsageStatisticsRefinementStrategy strategy;
    private ARGReachedSet ARGReached;
    private final Map<Set<CFAEdge>, PredicatePrecision> falseCache = new HashMap<Set<CFAEdge>, PredicatePrecision>();
    private final Map<Set<CFAEdge>, PredicatePrecision> falseCacheForCurrentIteration = new HashMap<Set<CFAEdge>, PredicatePrecision>();
    private final Set<Set<CFAEdge>> trueCache = new HashSet<Set<CFAEdge>>();
    private final Set<Set<CFAEdge>> potentialLoopTraces = new HashSet<Set<CFAEdge>>();
    private StatCounter solverFailures = new StatCounter("Solver failures");
    private StatCounter numberOfrepeatedPaths = new StatCounter("Number of repeated paths");
    private StatCounter numberOfrefinedPaths = new StatCounter("Number of refined paths");
    private StatCounter numberOfBAMupdates = new StatCounter("Number of BAM updates");

    public PredicateRefinerAdapter(ConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>> wrapper, ConfigurableProgramAnalysis pCpa, LogManager pLogger) throws InvalidConfigurationException {
        super(wrapper);
        if (!(pCpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException(BAMPredicateRefiner.class.getSimpleName() + " could not find the PredicateCPA");
        }
        BAMPredicateCPA predicateCpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(BAMPredicateCPA.class);
        if (predicateCpa == null) {
            throw new InvalidConfigurationException(BAMPredicateRefiner.class.getSimpleName() + " needs an BAMPredicateCPA");
        }
        this.logger = pLogger;
        PathFormulaManager pfmgr = predicateCpa.getPathFormulaManager();
        BAMBlockFormulaStrategy blockFormulaStrategy = new BAMBlockFormulaStrategy(pfmgr);
        this.strategy = new UsageStatisticsRefinementStrategy(predicateCpa.getConfiguration(), this.logger, predicateCpa.getSolver(), predicateCpa.getPredicateManager());
        this.refiner = new PredicateCPARefinerFactory(pCpa).setBlockFormulaStrategy(blockFormulaStrategy).create(this.strategy);
    }

    @Override
    public RefinementResult call(ExtendedARGPath pInput) throws CPAException, InterruptedException {
        RefinementResult result;
        HashSet<CFAEdge> currentPath = new HashSet<CFAEdge>(pInput.getInnerEdges());
        if (this.trueCache.contains(currentPath)) {
            result = RefinementResult.createTrue();
        } else {
            HashSet<CFAEdge> edgeSet = new HashSet<CFAEdge>(currentPath);
            if (this.falseCache.containsKey(edgeSet)) {
                Precision currentPrecision;
                PredicatePrecision currentPreds;
                PredicatePrecision previousPreds = this.falseCache.get(edgeSet);
                if (previousPreds.calculateDifferenceTo(currentPreds = Precisions.extractPrecisionByType(currentPrecision = this.getCurrentPrecision(), PredicatePrecision.class)) == 0) {
                    if (this.potentialLoopTraces.contains(edgeSet)) {
                        this.numberOfrepeatedPaths.inc();
                        this.logger.log(Level.WARNING, new Object[]{"Path is repeated, BAM is looped"});
                        pInput.getUsageInfo().setAsLooped();
                        result = RefinementResult.createTrue();
                        this.potentialLoopTraces.remove(edgeSet);
                    } else {
                        result = this.performPredicateRefinement(pInput);
                        this.logger.log(Level.WARNING, new Object[]{"Path is repeated, hope BAM can handle it itself"});
                        this.numberOfBAMupdates.inc();
                        this.potentialLoopTraces.add(edgeSet);
                    }
                } else {
                    this.logger.log(Level.WARNING, new Object[]{"Path is repeated, but predicates are missed"});
                    result = this.performPredicateRefinement(pInput);
                }
            } else {
                result = this.falseCacheForCurrentIteration.containsKey(edgeSet) ? RefinementResult.createFalse() : this.performPredicateRefinement(pInput);
            }
        }
        return result;
    }

    private RefinementResult performPredicateRefinement(ExtendedARGPath path) throws CPAException, InterruptedException {
        RefinementResult result;
        try {
            this.numberOfrefinedPaths.inc();
            CounterexampleInfo cex = this.refiner.performRefinementForPath(this.ARGReached, path);
            HashSet<CFAEdge> edgeSet = new HashSet<CFAEdge>(path.getInnerEdges());
            if (!cex.isSpurious()) {
                this.trueCache.add(edgeSet);
                result = RefinementResult.createTrue();
            } else {
                result = RefinementResult.createFalse();
                result.addInfo(PredicateRefinerAdapter.class, this.getLastAffectedStates());
                result.addPrecision(this.getLastPrecision());
                this.falseCacheForCurrentIteration.put(edgeSet, this.getLastPrecision());
            }
        }
        catch (IllegalStateException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Solver exception");
            this.solverFailures.inc();
            result = RefinementResult.createUnknown();
        }
        return result;
    }

    @Override
    protected void handleUpdateSignal(Class<? extends RefinementInterface> pCallerClass, Object pData) {
        if (pCallerClass.equals(IdentifierIterator.class) && pData instanceof ReachedSet) {
            this.updateReachedSet((ReachedSet)pData);
        }
    }

    @Override
    protected void handleFinishSignal(Class<? extends RefinementInterface> pCallerClass) {
        if (pCallerClass.equals(IdentifierIterator.class)) {
            this.falseCacheForCurrentIteration.forEach(this.falseCache::put);
            this.falseCacheForCurrentIteration.clear();
            this.ARGReached = null;
            this.strategy.lastAffectedStates.clear();
            this.strategy.lastAddedPrecision = null;
        }
    }

    @Override
    protected void printAdditionalStatistics(StatisticsWriter pOut) {
        pOut.beginLevel().put(this.numberOfrefinedPaths).put(this.numberOfrepeatedPaths).put(this.solverFailures).put(this.numberOfBAMupdates).put("Size of false cache", this.falseCache.size());
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStats) {
        if (this.refiner instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.refiner)).collectStatistics(pStats);
        }
        super.collectStatistics(pStats);
    }

    private List<ARGState> getLastAffectedStates() {
        return this.strategy.lastAffectedStates;
    }

    private PredicatePrecision getLastPrecision() {
        return this.strategy.lastAddedPrecision;
    }

    private Precision getCurrentPrecision() {
        return this.ARGReached.asReachedSet().getPrecision(this.ARGReached.asReachedSet().getFirstState());
    }

    private void updateReachedSet(ReachedSet pReached) {
        this.ARGReached = new ARGReachedSet(pReached);
    }

    protected static class UsageStatisticsRefinementStrategy
    extends BAMPredicateAbstractionRefinementStrategy {
        private List<ARGState> lastAffectedStates = new ArrayList<ARGState>();
        private PredicatePrecision lastAddedPrecision;

        public UsageStatisticsRefinementStrategy(Configuration config, LogManager logger, Solver pSolver, PredicateAbstractionManager pPredAbsMgr) throws InvalidConfigurationException {
            super(config, logger, pSolver, pPredAbsMgr);
        }

        @Override
        protected void finishRefinementOfPath(ARGState pUnreachableState, List<ARGState> pAffectedStates, ARGReachedSet pReached, List<ARGState> abstractionStatesTrace, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
            super.finishRefinementOfPath(pUnreachableState, pAffectedStates, pReached, abstractionStatesTrace, pRepeatedCounterexample);
            this.lastAffectedStates.clear();
            this.lastAffectedStates.addAll(pAffectedStates);
        }

        @Override
        protected PredicatePrecision addPredicatesToPrecision(PredicatePrecision basePrecision) {
            PredicatePrecision newPrecision = super.addPredicatesToPrecision(basePrecision);
            this.lastAddedPrecision = (PredicatePrecision)newPrecision.subtract(basePrecision);
            return newPrecision;
        }

        @Override
        protected void updateARG(PredicatePrecision pNewPrecision, ARGState pRefinementRoot, ARGReachedSet pReached) throws InterruptedException {
        }
    }
}

