/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.local.LocalTransferRelation;
import org.sosy_lab.cpachecker.cpa.usage.UsageCPA;
import org.sosy_lab.cpachecker.cpa.usage.refinement.CallstackFilter;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ExtendedARGPath;
import org.sosy_lab.cpachecker.cpa.usage.refinement.IdentifierIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.PathPairIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.PointIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.PredicateRefinerAdapter;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ProbeFilter;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementPairStub;
import org.sosy_lab.cpachecker.cpa.usage.refinement.SharedRefiner;
import org.sosy_lab.cpachecker.cpa.usage.refinement.UsagePairIterator;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageInfoSet;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Pair;

@Options(prefix="cpa.usage")
public class RefinementBlockFactory {
    Map<ARGState, ARGState> subgraphStatesToReachedState = new HashMap<ARGState, ARGState>();
    final ConfigurableProgramAnalysis cpa;
    Configuration config;
    @Option(name="refinementChain", description="The order of refinement blocks", secure=true)
    List<RefinementBlockTypes> RefinementChain;
    @Option(name="pathEquality", description="The way how to identify two paths as equal")
    PathEquation pathEquation = PathEquation.CFANodeId;

    public RefinementBlockFactory(ConfigurableProgramAnalysis pCpa, Configuration pConfig) throws InvalidConfigurationException {
        this.cpa = pCpa;
        this.config = pConfig;
        pConfig.inject((Object)this);
    }

    public Refiner create() throws InvalidConfigurationException {
        BAMCPA bamCpa = CPAs.retrieveCPA(this.cpa, BAMCPA.class);
        UsageCPA usCPA = CPAs.retrieveCPA(this.cpa, UsageCPA.class);
        LogManager logger = usCPA.getLogger();
        ConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>> currentBlock = new RefinementPairStub();
        currentInnerBlockType currentBlockType = currentInnerBlockType.ExtendedARGPath;
        block10: for (int i = this.RefinementChain.size() - 1; i >= 0; --i) {
            RefinementBlockTypes currentType = this.RefinementChain.get(i);
            if (currentBlockType == currentType.innerType) {
                switch (currentType) {
                    case IdentifierIterator: {
                        currentBlock = new IdentifierIterator(currentBlock, this.config, this.cpa, bamCpa.getTransferRelation());
                        currentBlockType = currentInnerBlockType.ReachedSet;
                        continue block10;
                    }
                    case PointIterator: {
                        currentBlock = new PointIterator((ConfigurableRefinementBlock<Pair<UsageInfoSet, UsageInfoSet>>)currentBlock);
                        currentBlockType = currentInnerBlockType.SingleIdentifier;
                        continue block10;
                    }
                    case UsageIterator: {
                        currentBlock = new UsagePairIterator(currentBlock, logger);
                        currentBlockType = currentInnerBlockType.UsageInfoSet;
                        continue block10;
                    }
                    case PathIterator: {
                        currentBlock = new PathPairIterator(currentBlock, bamCpa, this.pathEquation);
                        currentBlockType = currentInnerBlockType.UsageInfo;
                        continue block10;
                    }
                    case PredicateRefiner: {
                        currentBlock = new PredicateRefinerAdapter(currentBlock, this.cpa, logger);
                        continue block10;
                    }
                    case CallstackFilter: {
                        currentBlock = new CallstackFilter(currentBlock, this.config);
                        continue block10;
                    }
                    case ProbeFilter: {
                        currentBlock = new ProbeFilter(currentBlock, this.config);
                        continue block10;
                    }
                    case SharedRefiner: {
                        LocalTransferRelation RelationForSharedRefiner = new LocalTransferRelation(this.config);
                        currentBlock = new SharedRefiner(currentBlock, RelationForSharedRefiner);
                        continue block10;
                    }
                    default: {
                        throw new InvalidConfigurationException("The type " + (Object)((Object)this.RefinementChain.get(i)) + " is not supported");
                    }
                }
            }
            throw new InvalidConfigurationException(currentType + " can not precede the " + currentBlock.getClass().getSimpleName());
        }
        if (currentBlockType == currentInnerBlockType.ReachedSet) {
            assert (currentBlock instanceof Refiner);
            return (Refiner)((Object)currentBlock);
        }
        throw new InvalidConfigurationException("The first block is not take a reached set as parameter");
    }

    public static enum PathEquation {
        ARGStateId,
        CFANodeId;

    }

    private static enum currentInnerBlockType {
        ExtendedARGPath,
        UsageInfoSet,
        SingleIdentifier,
        UsageInfo,
        ReachedSet;

    }

    public static enum RefinementBlockTypes {
        IdentifierIterator(currentInnerBlockType.SingleIdentifier),
        PointIterator(currentInnerBlockType.UsageInfoSet),
        UsageIterator(currentInnerBlockType.UsageInfo),
        PathIterator(currentInnerBlockType.ExtendedARGPath),
        PredicateRefiner(currentInnerBlockType.ExtendedARGPath),
        CallstackFilter(currentInnerBlockType.ExtendedARGPath),
        ProbeFilter(currentInnerBlockType.ExtendedARGPath),
        SharedRefiner(currentInnerBlockType.ExtendedARGPath);

        public final currentInnerBlockType innerType;

        private RefinementBlockTypes(currentInnerBlockType type) {
            this.innerType = type;
        }
    }
}

