/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ExtendedARGPath;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementInterface;
import org.sosy_lab.cpachecker.util.Pair;

public class RefinementResult {
    private final Map<Class<? extends RefinementInterface>, Object> auxiliaryInfo = new HashMap<Class<? extends RefinementInterface>, Object>();
    private final Pair<UsageInfo, UsageInfo> trueRace;
    private PredicatePrecision precision;
    RefinementStatus status;

    private RefinementResult(RefinementStatus rStatus, UsageInfo firstUsage, UsageInfo secondUsage) {
        this.status = rStatus;
        if (firstUsage != null && secondUsage != null) {
            Preconditions.checkArgument((this.status == RefinementStatus.TRUE ? 1 : 0) != 0);
            this.trueRace = Pair.of(firstUsage, secondUsage);
        } else {
            this.trueRace = null;
        }
        this.precision = PredicatePrecision.empty();
    }

    public void addInfo(Class<? extends RefinementInterface> caller, Object info) {
        this.auxiliaryInfo.put(caller, info);
    }

    public Object getInfo(Class<? extends RefinementInterface> caller) {
        return this.auxiliaryInfo.get(caller);
    }

    public boolean isTrue() {
        return this.status == RefinementStatus.TRUE;
    }

    public boolean isFalse() {
        return this.status == RefinementStatus.FALSE;
    }

    public boolean isUnknown() {
        return this.status == RefinementStatus.UNKNOWN;
    }

    public static RefinementResult createTrue(ExtendedARGPath firstPath, ExtendedARGPath secondPath) {
        UsageInfo secondUsage;
        UsageInfo firstUsage = firstPath.getUsageInfo();
        if (firstUsage == (secondUsage = secondPath.getUsageInfo())) {
            secondUsage = secondUsage.copy();
        }
        firstUsage.setRefinedPath(firstPath.getInnerEdges());
        secondUsage.setRefinedPath(secondPath.getInnerEdges());
        return new RefinementResult(RefinementStatus.TRUE, firstUsage, secondUsage);
    }

    public static RefinementResult createTrue() {
        return new RefinementResult(RefinementStatus.TRUE, null, null);
    }

    public static RefinementResult createFalse() {
        return new RefinementResult(RefinementStatus.FALSE, null, null);
    }

    public static RefinementResult createUnknown() {
        return new RefinementResult(RefinementStatus.UNKNOWN, null, null);
    }

    public Pair<UsageInfo, UsageInfo> getTrueRace() {
        Preconditions.checkArgument((this.status == RefinementStatus.TRUE ? 1 : 0) != 0);
        return this.trueRace;
    }

    public void addPrecision(PredicatePrecision p) {
        this.precision = this.precision.mergeWith(p);
    }

    public PredicatePrecision getPrecision() {
        return this.precision;
    }

    public String toString() {
        return this.status.name();
    }

    public static enum RefinementStatus {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

