/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.cpa.local.LocalState;
import org.sosy_lab.cpachecker.cpa.local.LocalTransferRelation;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ExtendedARGPath;
import org.sosy_lab.cpachecker.cpa.usage.refinement.GenericSinglePathRefiner;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementResult;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class SharedRefiner
extends GenericSinglePathRefiner {
    private LocalTransferRelation transferRelation;
    private StatCounter counter = new StatCounter("Number of cases with empty successors");
    private StatCounter numOfFalseResults = new StatCounter("Number of false results");

    public SharedRefiner(ConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>> pWrapper, LocalTransferRelation RelationForSharedRefiner) {
        super(pWrapper);
        this.transferRelation = RelationForSharedRefiner;
    }

    @Override
    protected RefinementResult call(ExtendedARGPath pPath) throws CPAException, InterruptedException {
        RefinementResult result = RefinementResult.createUnknown();
        List<CFAEdge> edges = pPath.getFullPath();
        SingletonPrecision emptyPrecision = SingletonPrecision.getInstance();
        LocalState lastState = AbstractStates.extractStateByType(pPath.getLastState(), LocalState.class);
        LocalState initialState = LocalState.createInitialLocalState(lastState);
        Collection<LocalState> successors = Collections.singleton(initialState);
        UsageInfo sharedUsage = pPath.getUsageInfo();
        SingleIdentifier usageId = pPath.getUsageInfo().getId();
        for (CFAEdge edge : edges) {
            LocalState usageState;
            assert (successors.size() <= 1);
            Iterator sharedIterator = successors.iterator();
            if (sharedUsage.getCFANode().equals(edge.getSuccessor())) {
                usageState = (LocalState)sharedIterator.next();
                assert (usageState != null);
                if (usageState.getType(usageId) == LocalState.DataType.LOCAL) {
                    result = RefinementResult.createFalse();
                    this.numOfFalseResults.inc();
                    break;
                }
                result = RefinementResult.createTrue();
                break;
            }
            if (sharedIterator.hasNext()) {
                usageState = (LocalState)sharedIterator.next();
                successors = this.transferRelation.getAbstractSuccessorsForEdge(usageState, emptyPrecision, edge);
                continue;
            }
            this.counter.inc();
            result = RefinementResult.createUnknown();
            break;
        }
        return result;
    }

    @Override
    protected void printAdditionalStatistics(StatisticsWriter pOut) {
        pOut.beginLevel().put(this.counter).put(this.numOfFalseResults);
    }
}

