/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.GenericIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.IdentifierIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.PathPairIterator;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementInterface;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementResult;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageInfoSet;
import org.sosy_lab.cpachecker.util.Pair;

public class UsagePairIterator
extends GenericIterator<Pair<UsageInfoSet, UsageInfoSet>, Pair<UsageInfo, UsageInfo>> {
    private final LogManager logger;
    private Iterator<UsageInfo> firstUsageIterator;
    private Iterator<UsageInfo> secondUsageIterator;
    private UsageInfo firstUsage = null;
    private UsageInfoSet secondUsageInfoSet;

    public UsagePairIterator(ConfigurableRefinementBlock<Pair<UsageInfo, UsageInfo>> pWrapper, LogManager l) {
        super(pWrapper);
        this.logger = l;
    }

    @Override
    protected void init(Pair<UsageInfoSet, UsageInfoSet> pInput) {
        UsageInfoSet firstUsageInfoSet = pInput.getFirst();
        this.secondUsageInfoSet = pInput.getSecond();
        this.firstUsageIterator = firstUsageInfoSet.iterator();
        this.secondUsageIterator = this.secondUsageInfoSet.iterator();
        this.firstUsage = null;
    }

    @Override
    protected Pair<UsageInfo, UsageInfo> getNext(Pair<UsageInfoSet, UsageInfoSet> pInput) {
        UsageInfo resultSecondUsage;
        Pair<UsageInfo, UsageInfo> result;
        if (this.firstUsage == null) {
            if (this.firstUsageIterator.hasNext()) {
                this.firstUsage = this.firstUsageIterator.next();
            } else {
                return null;
            }
        }
        if ((result = this.checkSecondIterator()) == null && this.firstUsageIterator.hasNext()) {
            this.firstUsage = this.firstUsageIterator.next();
            this.secondUsageIterator = pInput.getSecond().iterator();
            result = this.checkSecondIterator();
        }
        if (result == null) {
            return null;
        }
        UsageInfo resultFirstUsage = result.getFirst();
        if (resultFirstUsage == (resultSecondUsage = result.getSecond())) {
            resultSecondUsage = resultSecondUsage.copy();
        }
        return Pair.of(resultFirstUsage, resultSecondUsage);
    }

    private Pair<UsageInfo, UsageInfo> checkSecondIterator() {
        if (this.secondUsageIterator.hasNext()) {
            return Pair.of(this.firstUsage, this.secondUsageIterator.next());
        }
        return null;
    }

    @Override
    protected void finishIteration(Pair<UsageInfo, UsageInfo> usagePair, RefinementResult r) {
        UsageInfo first = usagePair.getFirst();
        UsageInfo second = usagePair.getSecond();
        List unreachableUsages = (List)r.getInfo(PathPairIterator.class);
        if (unreachableUsages != null && unreachableUsages.contains(second)) {
            this.logger.log(Level.FINE, new Object[]{"Usage " + this.secondUsageIterator + " is not reachable, remove it from container"});
            this.secondUsageIterator.remove();
        }
        if (unreachableUsages != null && unreachableUsages.contains(first)) {
            this.logger.log(Level.FINE, new Object[]{"Usage " + this.firstUsageIterator + " is not reachable, remove it from container"});
            this.firstUsageIterator.remove();
            this.firstUsage = null;
            this.secondUsageIterator = this.secondUsageInfoSet.iterator();
        }
        if ((first.isLooped() || second.isLooped()) && first.equals(second)) {
            first.setAsLooped();
            second.setAsLooped();
        }
    }

    @Override
    protected void handleFinishSignal(Class<? extends RefinementInterface> pCallerClass) {
        if (pCallerClass.equals(IdentifierIterator.class)) {
            this.firstUsageIterator = null;
            this.secondUsageIterator = null;
            this.firstUsage = null;
            this.secondUsageInfoSet = null;
        }
    }
}

