/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import com.google.errorprone.annotations.ForOverride;
import java.util.Collection;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementInterface;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public abstract class WrappedConfigurableRefinementBlock<I, O>
implements ConfigurableRefinementBlock<I>,
StatisticsProvider {
    protected ConfigurableRefinementBlock<O> wrappedRefiner;

    @ForOverride
    protected void handleStartSignal(Class<? extends RefinementInterface> callerClass) {
    }

    @ForOverride
    protected void handleFinishSignal(Class<? extends RefinementInterface> callerClass) {
    }

    @ForOverride
    protected void handleUpdateSignal(Class<? extends RefinementInterface> callerClass, Object data) {
    }

    @ForOverride
    protected void handleSignal(Class<? extends RefinementInterface> callerClass, Object data) {
    }

    protected void sendStartSignal() {
        this.wrappedRefiner.start(this.getClass());
    }

    protected void sendFinishSignal() throws CPAException, InterruptedException {
        this.wrappedRefiner.finish(this.getClass());
    }

    protected void sendUpdateSignal(Class<? extends RefinementInterface> dstClass, Object data) {
        this.wrappedRefiner.update(this.getClass(), dstClass, data);
    }

    protected WrappedConfigurableRefinementBlock(ConfigurableRefinementBlock<O> wrapper) {
        this.wrappedRefiner = wrapper;
    }

    @Override
    public final void update(Class<? extends RefinementInterface> callerClass, Class<? extends RefinementInterface> dstClass, Object data) {
        if (this.getClass().equals(dstClass)) {
            this.handleUpdateSignal(callerClass, data);
        } else {
            this.wrappedRefiner.update(callerClass, dstClass, data);
        }
    }

    @Override
    public final void start(Class<? extends RefinementInterface> callerClass) {
        this.handleStartSignal(callerClass);
        this.wrappedRefiner.start(callerClass);
    }

    @Override
    public final void finish(Class<? extends RefinementInterface> callerClass) throws CPAException, InterruptedException {
        this.handleFinishSignal(callerClass);
        this.wrappedRefiner.finish(callerClass);
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        if (this.wrappedRefiner instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.wrappedRefiner)).collectStatistics(statsCollection);
        }
    }
}

