/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.storage;

import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;

public abstract class AbstractUsageStorage
extends TreeMap<SingleIdentifier, NavigableSet<UsageInfo>> {
    private static final long serialVersionUID = 1L;
    private final Set<SingleIdentifier> deeplyCloned = new TreeSet<SingleIdentifier>();

    protected AbstractUsageStorage(AbstractUsageStorage previous) {
        super(previous);
    }

    protected AbstractUsageStorage() {
    }

    protected NavigableSet<UsageInfo> getStorageForId(SingleIdentifier id) {
        if (this.deeplyCloned.contains(id)) {
            assert (this.containsKey(id));
            return (NavigableSet)this.get(id);
        }
        this.deeplyCloned.add(id);
        TreeSet<UsageInfo> storage = this.containsKey(id) ? new TreeSet((SortedSet)this.get(id)) : new TreeSet<UsageInfo>();
        super.put(id, storage);
        return storage;
    }

    @Override
    public void clear() {
        super.clear();
        this.deeplyCloned.clear();
    }

    public void copyUsagesFrom(AbstractUsageStorage pStorage) {
        pStorage.forEach(this::addUsages);
    }

    public void addUsages(SingleIdentifier id, NavigableSet<UsageInfo> usages) {
        if (this.containsKey(id)) {
            NavigableSet<UsageInfo> currentStorage = this.getStorageForId(id);
            currentStorage.addAll(usages);
        } else {
            super.put(id, usages);
        }
    }

    public boolean add(SingleIdentifier id, UsageInfo info) {
        NavigableSet<UsageInfo> currentStorage = this.getStorageForId(id);
        return currentStorage.add(info);
    }

    public boolean isSubsetOf(AbstractUsageStorage pOther) {
        for (Map.Entry entry : this.entrySet()) {
            SingleIdentifier id = (SingleIdentifier)entry.getKey();
            if (pOther.containsKey(id)) {
                NavigableSet currentSet = (NavigableSet)entry.getValue();
                NavigableSet otherSet = (NavigableSet)pOther.get(id);
                if (otherSet.containsAll(currentSet)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

