/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.storage;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.IdentityHashSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.lock.effects.LockEffect;
import org.sosy_lab.cpachecker.cpa.usage.storage.AbstractUsageStorage;
import org.sosy_lab.cpachecker.cpa.usage.storage.TemporaryUsageStorage;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@SuppressFBWarnings(justification="Serialization of container is useless and not supported", value={"SE_BAD_FIELD"})
public class FunctionContainer
extends AbstractUsageStorage {
    private static final long serialVersionUID = 1L;
    private final Multiset<LockEffect> effects;
    private final StorageStatistics stats;
    private final Set<FunctionContainer> joinedWith;
    private final Set<TemporaryUsageStorage> storages;

    public static FunctionContainer createInitialContainer() {
        return new FunctionContainer(new StorageStatistics(), (Multiset<LockEffect>)HashMultiset.create());
    }

    private FunctionContainer(StorageStatistics pStats, Multiset<LockEffect> pEffects) {
        this.stats = pStats;
        this.stats.numberOfFunctionContainers.inc();
        this.effects = pEffects;
        this.joinedWith = new IdentityHashSet();
        this.storages = new HashSet<TemporaryUsageStorage>();
    }

    public FunctionContainer clone(Multiset<LockEffect> pEffects) {
        return new FunctionContainer(this.stats, pEffects);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.effects);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    public void join(FunctionContainer funcContainer) {
        this.stats.totalJoins.inc();
        if (this.joinedWith.contains(funcContainer)) {
            this.stats.hitTimes.inc();
            return;
        }
        if (!funcContainer.isEmpty() || !funcContainer.joinedWith.isEmpty()) {
            this.joinedWith.add(funcContainer);
        }
    }

    public void join(TemporaryUsageStorage pRecentUsages) {
        this.stats.copyTimer.start();
        this.copyUsagesFrom(pRecentUsages);
        this.stats.copyTimer.stop();
    }

    public void clearStorages() {
        this.storages.forEach(TemporaryUsageStorage::clear);
        this.storages.clear();
    }

    public void registerTemporaryContainer(TemporaryUsageStorage storage) {
        this.storages.add(storage);
    }

    public StorageStatistics getStatistics() {
        return this.stats;
    }

    public Set<FunctionContainer> getContainers() {
        return this.joinedWith;
    }

    public Multiset<LockEffect> getLockEffects() {
        return this.effects;
    }

    public static class StorageStatistics {
        private StatCounter hitTimes = new StatCounter("Number of hits into cache");
        private StatCounter totalJoins = new StatCounter("Total number of joins");
        private StatCounter numberOfFunctionContainers = new StatCounter("Total number of function containers");
        private StatTimer copyTimer = new StatTimer("Time for coping usages");

        public void printStatistics(StatisticsWriter out) {
            out.spacer().put(this.copyTimer).put(this.totalJoins).put(this.hitTimes).put(this.numberOfFunctionContainers);
        }
    }
}

