/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.storage;

import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.storage.AbstractUsagePointSet;
import org.sosy_lab.cpachecker.util.Pair;

public class RefinedUsagePointSet
implements AbstractUsagePointSet {
    protected final UsageInfo target;

    private RefinedUsagePointSet(UsageInfo newSet) {
        this.target = newSet;
    }

    public static RefinedUsagePointSet create(UsageInfo newSet, UsageInfo newSet2) {
        if (newSet.getPath().equals(newSet2.getPath()) && newSet.equals(newSet2)) {
            return new RefinedUsagePointSet(newSet);
        }
        return new DoubleRefinedUsagePointSet(newSet, newSet2);
    }

    @Override
    public int size() {
        return 1;
    }

    public Pair<UsageInfo, UsageInfo> getUnsafePair() {
        return Pair.of(this.target, this.target);
    }

    public static class DoubleRefinedUsagePointSet
    extends RefinedUsagePointSet {
        protected final UsageInfo target2;

        private DoubleRefinedUsagePointSet(UsageInfo newSet, UsageInfo newSet2) {
            super(newSet);
            this.target2 = newSet2;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Pair<UsageInfo, UsageInfo> getUnsafePair() {
            return Pair.of(this.target, this.target2);
        }
    }
}

