/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.storage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.UsageState;
import org.sosy_lab.cpachecker.cpa.usage.storage.AbstractUsagePointSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageInfoSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsagePoint;

public class UnrefinedUsagePointSet
implements AbstractUsagePointSet {
    private final NavigableSet<UsagePoint> topUsages = new TreeSet<UsagePoint>();
    private final Map<UsagePoint, UsageInfoSet> usageInfoSets = new HashMap<UsagePoint, UsageInfoSet>();

    public void add(UsageInfo newInfo) {
        UsageInfoSet targetSet;
        UsagePoint newPoint = newInfo.createUsagePoint();
        if (this.usageInfoSets.containsKey(newPoint)) {
            targetSet = this.usageInfoSets.get(newPoint);
        } else {
            targetSet = new UsageInfoSet();
            this.usageInfoSets.put(newPoint, targetSet);
        }
        this.add(newPoint);
        targetSet.add(newInfo);
    }

    private void add(UsagePoint newPoint) {
        if (!this.topUsages.contains(newPoint)) {
            Iterator<UsagePoint> iterator = this.topUsages.iterator();
            while (iterator.hasNext()) {
                UsagePoint point = iterator.next();
                if (newPoint.covers(point)) {
                    iterator.remove();
                    newPoint.addCoveredUsage(point);
                    continue;
                }
                if (!point.covers(newPoint)) continue;
                point.addCoveredUsage(newPoint);
                return;
            }
            this.topUsages.add(newPoint);
        }
    }

    public UsageInfoSet getUsageInfo(UsagePoint point) {
        return this.usageInfoSets.get(point);
    }

    @Override
    public int size() {
        int result = 0;
        for (UsageInfoSet value : this.usageInfoSets.values()) {
            result += value.size();
        }
        return result;
    }

    public void reset() {
        this.topUsages.clear();
        this.usageInfoSets.clear();
    }

    public void remove(UsageState pUstate) {
        for (UsagePoint point : new TreeSet<UsagePoint>(this.usageInfoSets.keySet())) {
            UsageInfoSet uset = this.usageInfoSets.get(point);
            boolean b = uset.remove(pUstate);
            if (!b || !uset.isEmpty()) continue;
            this.usageInfoSets.remove(point);
        }
    }

    public Iterator<UsagePoint> getPointIterator() {
        return new TreeSet<UsagePoint>((SortedSet<UsagePoint>)this.topUsages).iterator();
    }

    public Iterator<UsagePoint> getPointIteratorFrom(UsagePoint p) {
        return new TreeSet<UsagePoint>(this.topUsages.tailSet(p)).iterator();
    }

    public int getNumberOfTopUsagePoints() {
        return this.topUsages.size();
    }

    public void remove(UsagePoint currentUsagePoint) {
        this.usageInfoSets.remove(currentUsagePoint);
        this.topUsages.remove(currentUsagePoint);
        currentUsagePoint.getCoveredUsages().forEach(this::add);
    }

    NavigableSet<UsagePoint> getTopUsages() {
        return this.topUsages;
    }
}

