/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.storage;

import com.google.common.base.Preconditions;
import java.util.NavigableSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.lock.DeadLockState;
import org.sosy_lab.cpachecker.cpa.lock.LockIdentifier;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.storage.AbstractUsagePointSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.RefinedUsagePointSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.UnrefinedUsagePointSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageConfiguration;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsagePoint;
import org.sosy_lab.cpachecker.util.Pair;

public class UnsafeDetector {
    private final UsageConfiguration config;

    public UnsafeDetector(UsageConfiguration pConfig) {
        this.config = pConfig;
    }

    public boolean isUnsafe(AbstractUsagePointSet set) {
        if (set instanceof RefinedUsagePointSet) {
            return true;
        }
        return this.isUnsafe((UnrefinedUsagePointSet)set);
    }

    public boolean isUnsafe(Set<UsageInfo> set) {
        return this.isUnsafe(this.preparePointSet(set));
    }

    private UnrefinedUsagePointSet preparePointSet(Set<UsageInfo> set) {
        UnrefinedUsagePointSet tmpSet = new UnrefinedUsagePointSet();
        set.forEach(tmpSet::add);
        return tmpSet;
    }

    private boolean isUnsafe(UnrefinedUsagePointSet set) {
        return this.isUnsafe(set.getTopUsages());
    }

    public Pair<UsageInfo, UsageInfo> getUnsafePair(AbstractUsagePointSet set) {
        assert (this.isUnsafe(set));
        if (set instanceof RefinedUsagePointSet) {
            return ((RefinedUsagePointSet)set).getUnsafePair();
        }
        UnrefinedUsagePointSet unrefinedSet = (UnrefinedUsagePointSet)set;
        Pair<UsagePoint, UsagePoint> result = this.getUnsafePair(unrefinedSet.getTopUsages());
        assert (result != null);
        return Pair.of(unrefinedSet.getUsageInfo(result.getFirst()).getOneExample(), unrefinedSet.getUsageInfo(result.getSecond()).getOneExample());
    }

    public Pair<UsagePoint, UsagePoint> getUnsafePointPair(UnrefinedUsagePointSet set) {
        return this.getUnsafePair(set.getTopUsages());
    }

    private boolean isUnsafe(NavigableSet<UsagePoint> points) {
        for (UsagePoint point1 : points) {
            for (UsagePoint point2 : points.tailSet(point1)) {
                if (!this.isUnsafePair(point1, point2)) continue;
                return true;
            }
        }
        return false;
    }

    private Pair<UsagePoint, UsagePoint> getUnsafePair(NavigableSet<UsagePoint> set) {
        for (UsagePoint point1 : set) {
            for (UsagePoint point2 : set.tailSet(point1)) {
                if (point1.equals(point2) || !this.isUnsafePair(point1, point2)) continue;
                return Pair.of(point1, point2);
            }
        }
        if (!this.config.ignoreEmptyLockset()) {
            for (UsagePoint point : set) {
                if (!this.isUnsafePair(point, point)) continue;
                return Pair.of(point, point);
            }
        }
        return null;
    }

    public boolean isUnsafePair(UsagePoint point1, UsagePoint point2) {
        if (point1.isCompatible(point2)) {
            switch (this.config.getUnsafeMode()) {
                case RACE: {
                    return this.isRace(point1, point2);
                }
                case DEADLOCKDISPATCH: {
                    return this.isDeadlockDispatch(point1, point2);
                }
                case DEADLOCKCIRCULAR: {
                    return this.isDeadlockCircular(point1, point2);
                }
            }
            throw new AssertionError((Object)("Unknown mode: " + this.config.getUnsafeMode()));
        }
        return false;
    }

    private boolean isRace(UsagePoint point1, UsagePoint point2) {
        if (point1.getAccess() == UsageInfo.Access.WRITE || point2.getAccess() == UsageInfo.Access.WRITE) {
            return !this.config.ignoreEmptyLockset() || !point1.isEmpty() || !point2.isEmpty();
        }
        return false;
    }

    private boolean isDeadlockDispatch(UsagePoint point1, UsagePoint point2) {
        LockIdentifier intLock = LockIdentifier.of((String)Preconditions.checkNotNull((Object)this.config.getIntLockName()));
        DeadLockState.DeadLockTreeNode node1 = point1.get(DeadLockState.DeadLockTreeNode.class);
        DeadLockState.DeadLockTreeNode node2 = point2.get(DeadLockState.DeadLockTreeNode.class);
        if (node2.contains(intLock) && !node1.contains(intLock)) {
            for (LockIdentifier lock1 : node1) {
                int index2;
                int index1 = node2.indexOf(lock1);
                if (index1 <= (index2 = node2.indexOf(intLock))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDeadlockCircular(UsagePoint point1, UsagePoint point2) {
        DeadLockState.DeadLockTreeNode node1 = point1.get(DeadLockState.DeadLockTreeNode.class);
        DeadLockState.DeadLockTreeNode node2 = point2.get(DeadLockState.DeadLockTreeNode.class);
        for (LockIdentifier lock1 : node1) {
            for (LockIdentifier lock2 : node2) {
                int index1 = node1.indexOf(lock1);
                int index2 = node1.indexOf(lock2);
                int otherIndex1 = node2.indexOf(lock1);
                int otherIndex2 = node2.indexOf(lock2);
                if (otherIndex1 < 0 || index2 < 0 || (index1 <= index2 || otherIndex1 >= otherIndex2) && (index1 >= index2 || otherIndex1 <= otherIndex2)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum UnsafeMode {
        RACE,
        DEADLOCKCIRCULAR,
        DEADLOCKDISPATCH;

    }
}

