/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.lock.LockState;
import org.sosy_lab.cpachecker.cpa.lock.effects.LockEffect;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.UsageState;
import org.sosy_lab.cpachecker.cpa.usage.refinement.RefinementResult;
import org.sosy_lab.cpachecker.cpa.usage.storage.AbstractUsagePointSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.AbstractUsageStorage;
import org.sosy_lab.cpachecker.cpa.usage.storage.FunctionContainer;
import org.sosy_lab.cpachecker.cpa.usage.storage.RefinedUsagePointSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.TemporaryUsageStorage;
import org.sosy_lab.cpachecker.cpa.usage.storage.UnrefinedUsagePointSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.UnsafeDetector;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageConfiguration;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class UsageContainer {
    private final NavigableMap<SingleIdentifier, UnrefinedUsagePointSet> unrefinedIds;
    private final NavigableMap<SingleIdentifier, RefinedUsagePointSet> refinedIds;
    private final NavigableMap<SingleIdentifier, RefinedUsagePointSet> failedIds;
    private final UnsafeDetector detector;
    private final Set<SingleIdentifier> falseUnsafes;
    private final Set<SingleIdentifier> processedUnsafes = new HashSet<SingleIdentifier>();
    private Set<SingleIdentifier> initialSet = null;
    private int initialUsages;
    private final LogManager logger;
    private final UsageConfiguration config;
    private final StatTimer resetTimer = new StatTimer("Time for reseting unsafes");
    private final StatTimer copyTimer = new StatTimer("Time for filling global container");
    private final StatTimer emptyEffectsTimer = new StatTimer("Time for coping usages");
    int unsafeUsages = -1;
    int totalIds = 0;

    public UsageContainer(UsageConfiguration config, LogManager l, UnsafeDetector unsafeDetector) {
        this(new TreeMap<SingleIdentifier, UnrefinedUsagePointSet>(), new TreeMap<SingleIdentifier, RefinedUsagePointSet>(), new TreeMap<SingleIdentifier, RefinedUsagePointSet>(), new TreeSet<SingleIdentifier>(), l, config, unsafeDetector);
    }

    private UsageContainer(NavigableMap<SingleIdentifier, UnrefinedUsagePointSet> pUnrefinedStat, NavigableMap<SingleIdentifier, RefinedUsagePointSet> pRefinedStat, NavigableMap<SingleIdentifier, RefinedUsagePointSet> failedStat, Set<SingleIdentifier> pFalseUnsafes, LogManager pLogger, UsageConfiguration pConfig, UnsafeDetector pDetector) {
        this.unrefinedIds = pUnrefinedStat;
        this.refinedIds = pRefinedStat;
        this.failedIds = failedStat;
        this.falseUnsafes = pFalseUnsafes;
        this.logger = pLogger;
        this.config = pConfig;
        this.detector = pDetector;
    }

    public void initContainerIfNecessary(FunctionContainer storage) {
        if (this.unsafeUsages == -1) {
            this.copyTimer.start();
            HashSet<Pair> processedContainers = new HashSet<Pair>();
            ArrayDeque<Pair<FunctionContainer, HashMultiset>> waitlist = new ArrayDeque<Pair<FunctionContainer, HashMultiset>>();
            Pair<FunctionContainer, HashMultiset> first = Pair.of(storage, HashMultiset.create());
            waitlist.add(first);
            while (!waitlist.isEmpty()) {
                Pair currentPair = (Pair)waitlist.pollFirst();
                if (processedContainers.contains(currentPair)) continue;
                FunctionContainer currentContainer = (FunctionContainer)currentPair.getFirst();
                Multiset currentEffects = (Multiset)currentPair.getSecond();
                HashMultiset newEffects = HashMultiset.create();
                newEffects.addAll((Collection)currentEffects);
                newEffects.addAll(currentContainer.getLockEffects());
                this.copyUsages(currentContainer, (Multiset<LockEffect>)newEffects);
                processedContainers.add(currentPair);
                if (newEffects.equals((Object)currentEffects)) {
                    newEffects = currentEffects;
                }
                for (FunctionContainer container : currentContainer.getContainers()) {
                    waitlist.add(Pair.of(container, newEffects));
                }
            }
            this.calculateUnsafesIfNecessary();
            this.copyTimer.stop();
        }
    }

    public void forceAddNewUsages(TemporaryUsageStorage storage) {
        assert (this.unsafeUsages == -1);
        this.copyUsages(storage);
    }

    private void copyUsages(AbstractUsageStorage storage) {
        this.emptyEffectsTimer.start();
        for (Map.Entry entry : storage.entrySet()) {
            SingleIdentifier id = (SingleIdentifier)entry.getKey();
            if (this.falseUnsafes.contains(id) || this.refinedIds.containsKey(id)) continue;
            UnrefinedUsagePointSet uset = this.getSet(id);
            for (UsageInfo uinfo : (NavigableSet)entry.getValue()) {
                if (uinfo.getKeyState() == null) continue;
                uset.add(uinfo);
            }
        }
        this.emptyEffectsTimer.stop();
    }

    private void copyUsages(FunctionContainer storage, Multiset<LockEffect> currentEffects) {
        if (currentEffects.isEmpty()) {
            this.copyUsages(storage);
        } else {
            HashMap<LockState, LockState> reduceToExpand = new HashMap<LockState, LockState>();
            for (Map.Entry entry : storage.entrySet()) {
                SingleIdentifier id = (SingleIdentifier)entry.getKey();
                if (this.falseUnsafes.contains(id) || this.refinedIds.containsKey(id)) continue;
                UnrefinedUsagePointSet uset = this.getSet(id);
                for (UsageInfo uinfo : (NavigableSet)entry.getValue()) {
                    LockState expandedLocks;
                    if (uinfo.getKeyState() == null) continue;
                    LockState locks = (LockState)uinfo.getLockState();
                    if (reduceToExpand.containsKey(locks)) {
                        expandedLocks = (LockState)reduceToExpand.get(locks);
                    } else {
                        LockState.LockStateBuilder builder = locks.builder();
                        currentEffects.forEach(e -> e.effect(builder));
                        expandedLocks = builder.build();
                        reduceToExpand.put(locks, expandedLocks);
                    }
                    uset.add(uinfo.expand(expandedLocks));
                }
            }
        }
    }

    private UnrefinedUsagePointSet getSet(SingleIdentifier id) {
        UnrefinedUsagePointSet uset;
        assert (!this.falseUnsafes.contains(id) || !this.refinedIds.containsKey(id));
        if (!this.unrefinedIds.containsKey(id)) {
            uset = new UnrefinedUsagePointSet();
            this.unrefinedIds.put(id, uset);
        } else {
            uset = (UnrefinedUsagePointSet)this.unrefinedIds.get(id);
        }
        return uset;
    }

    private void calculateUnsafesIfNecessary() {
        if (this.unsafeUsages == -1) {
            this.processedUnsafes.clear();
            this.unsafeUsages = 0;
            HashSet<SingleIdentifier> toDelete = new HashSet<SingleIdentifier>();
            for (Map.Entry entry : this.unrefinedIds.entrySet()) {
                UnrefinedUsagePointSet tmpList = (UnrefinedUsagePointSet)entry.getValue();
                if (this.detector.isUnsafe((AbstractUsagePointSet)tmpList)) {
                    this.unsafeUsages += tmpList.size();
                    continue;
                }
                SingleIdentifier id2 = (SingleIdentifier)entry.getKey();
                toDelete.add(id2);
                this.falseUnsafes.add(id2);
            }
            toDelete.forEach(this::removeIdFromCaches);
            this.refinedIds.forEach((id, list) -> this.unsafeUsages += list.size());
            if (this.initialSet == null) {
                assert (this.refinedIds.isEmpty());
                this.initialSet = new HashSet(this.unrefinedIds.keySet());
                this.initialUsages = this.unsafeUsages;
            }
        }
    }

    private void removeIdFromCaches(SingleIdentifier id) {
        this.unrefinedIds.remove(id);
        this.processedUnsafes.add(id);
    }

    public Set<SingleIdentifier> getFalseUnsafes() {
        Set<SingleIdentifier> currentUnsafes = this.getAllUnsafes();
        return Sets.difference(this.initialSet, currentUnsafes);
    }

    private Set<SingleIdentifier> getAllUnsafes() {
        this.calculateUnsafesIfNecessary();
        TreeSet<SingleIdentifier> result = new TreeSet<SingleIdentifier>(this.unrefinedIds.keySet());
        result.addAll(this.refinedIds.keySet());
        result.addAll(this.failedIds.keySet());
        return result;
    }

    public Iterator<SingleIdentifier> getUnsafeIterator() {
        if (this.config.printOnlyTrueUnsafes()) {
            return this.getTrueUnsafeIterator();
        }
        return this.getAllUnsafes().iterator();
    }

    public Iterator<SingleIdentifier> getUnrefinedUnsafeIterator() {
        return this.getKeySetIterator(this.unrefinedIds);
    }

    private Iterator<SingleIdentifier> getTrueUnsafeIterator() {
        return this.getKeySetIterator(this.refinedIds);
    }

    private Iterator<SingleIdentifier> getKeySetIterator(NavigableMap<SingleIdentifier, ? extends AbstractUsagePointSet> map) {
        TreeSet result = new TreeSet(map.keySet());
        return result.iterator();
    }

    public int getUnsafeSize() {
        this.calculateUnsafesIfNecessary();
        if (this.config.printOnlyTrueUnsafes()) {
            return this.refinedIds.size();
        }
        return this.getTotalUnsafeSize();
    }

    public int getTotalUnsafeSize() {
        return this.unrefinedIds.size() + this.refinedIds.size() + this.failedIds.size();
    }

    public int getProcessedUnsafeSize() {
        return this.refinedIds.size() + this.failedIds.size();
    }

    public UnsafeDetector getUnsafeDetector() {
        return this.detector;
    }

    public void resetUnrefinedUnsafes() {
        this.resetTimer.start();
        this.unsafeUsages = -1;
        this.unrefinedIds.values().forEach(UnrefinedUsagePointSet::reset);
        this.logger.log(Level.FINE, new Object[]{"Unsafes are reseted"});
        this.resetTimer.stop();
    }

    public void removeState(UsageState pUstate) {
        this.unrefinedIds.forEach((id, uset) -> uset.remove(pUstate));
        this.logger.log(Level.ALL, new Object[]{"All unsafes related to key state " + pUstate + " were removed from reached set"});
    }

    public AbstractUsagePointSet getUsages(SingleIdentifier id) {
        if (this.unrefinedIds.containsKey(id)) {
            return (AbstractUsagePointSet)this.unrefinedIds.get(id);
        }
        if (this.refinedIds.containsKey(id)) {
            return (AbstractUsagePointSet)this.refinedIds.get(id);
        }
        return (AbstractUsagePointSet)this.failedIds.get(id);
    }

    public void setAsFalseUnsafe(SingleIdentifier id) {
        this.falseUnsafes.add(id);
        this.removeIdFromCaches(id);
    }

    public void setAsRefined(SingleIdentifier id, RefinementResult result) {
        Preconditions.checkArgument((boolean)result.isTrue(), (Object)"Result is not true, can not set the set as refined");
        Preconditions.checkArgument((boolean)this.detector.isUnsafe(this.getUsages(id)), (String)"Refinement is successful, but the unsafe is absent for identifier %s", (Object)id);
        this.setAsRefined(id, result.getTrueRace().getFirst(), result.getTrueRace().getSecond());
    }

    public void setAsRefined(SingleIdentifier id, UsageInfo firstUsage, UsageInfo secondUsage) {
        RefinedUsagePointSet rSet = RefinedUsagePointSet.create(firstUsage, secondUsage);
        if (firstUsage.isLooped() || secondUsage.isLooped()) {
            this.failedIds.put(id, rSet);
        } else {
            this.refinedIds.put(id, rSet);
        }
        this.removeIdFromCaches(id);
    }

    public void printUsagesStatistics(StatisticsWriter out) {
        int unsafeSize = this.getTotalUnsafeSize();
        StatInt topUsagePoints = new StatInt(StatKind.SUM, "Total amount of unrefined usage points");
        StatInt unrefinedUsages = new StatInt(StatKind.SUM, "Total amount of unrefined usages");
        StatInt refinedUsages = new StatInt(StatKind.SUM, "Total amount of refined usages");
        StatCounter failedUsages = new StatCounter("Total amount of failed usages");
        int generalUnrefinedSize = this.unrefinedIds.size();
        for (UnrefinedUsagePointSet uset : this.unrefinedIds.values()) {
            unrefinedUsages.setNextValue(uset.size());
            topUsagePoints.setNextValue(uset.getNumberOfTopUsagePoints());
        }
        int generalRefinedSize = this.refinedIds.size();
        this.refinedIds.forEach((id, rset) -> refinedUsages.setNextValue(rset.size()));
        int generalFailedSize = this.failedIds.size();
        for (RefinedUsagePointSet uset : this.failedIds.values()) {
            Pair<UsageInfo, UsageInfo> pair = uset.getUnsafePair();
            if (pair.getFirst().isLooped()) {
                failedUsages.inc();
            }
            if (!pair.getSecond().isLooped() || pair.getFirst().equals(pair.getSecond())) continue;
            failedUsages.inc();
        }
        out.spacer().put("Total amount of unsafes", unsafeSize).put("Initial amount of unsafes (before refinement)", this.initialSet.size()).put("Initial amount of usages (before refinement)", this.initialUsages).put("Initial amount of refined false unsafes", this.falseUnsafes.size()).put("Total amount of unrefined unsafes", generalUnrefinedSize).put(topUsagePoints).put(unrefinedUsages).put("Total amount of refined unsafes", generalRefinedSize).put(refinedUsages).put("Total amount of failed unsafes", generalFailedSize).put(failedUsages).put(this.resetTimer).put(this.copyTimer).put(this.emptyEffectsTimer);
    }

    public Set<SingleIdentifier> getProcessedUnsafes() {
        return this.processedUnsafes;
    }
}

