/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleNode;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleState;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.util.Pair;

public final class UsagePoint
implements Comparable<UsagePoint> {
    private final UsageInfo.Access access;
    private final List<CompatibleNode> compatibleNodes;
    private final Set<UsagePoint> coveredUsages;

    public UsagePoint(List<CompatibleNode> nodes, UsageInfo.Access pAccess) {
        this.access = pAccess;
        this.coveredUsages = new TreeSet<UsagePoint>();
        this.compatibleNodes = nodes;
    }

    public boolean addCoveredUsage(UsagePoint newChild) {
        if (!this.coveredUsages.contains(newChild)) {
            Optional<UsagePoint> usage = this.coveredUsages.stream().filter(u -> u.covers(newChild)).findFirst();
            if (usage.isPresent()) {
                assert (!usage.orElseThrow().equals(newChild));
                return usage.orElseThrow().addCoveredUsage(newChild);
            }
            return this.coveredUsages.add(newChild);
        }
        return false;
    }

    public Set<UsagePoint> getCoveredUsages() {
        return this.coveredUsages;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.access, this.compatibleNodes});
    }

    public UsageInfo.Access getAccess() {
        return this.access;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UsagePoint other = (UsagePoint)obj;
        return this.access == other.access && Objects.equals(this.compatibleNodes, other.compatibleNodes);
    }

    @Override
    public int compareTo(UsagePoint o) {
        int result = this.access.compareTo(o.access);
        if (result != 0) {
            return result;
        }
        Preconditions.checkArgument((this.compatibleNodes.size() == o.compatibleNodes.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.compatibleNodes.size(); ++i) {
            CompatibleNode otherNode;
            CompatibleNode currentNode = this.compatibleNodes.get(i);
            result = currentNode.compareTo(otherNode = o.compatibleNodes.get(i));
            if (result == 0) continue;
            return result;
        }
        return result;
    }

    public boolean covers(UsagePoint o) {
        if (this.access.compareTo(o.access) > 0) {
            return false;
        }
        return FluentIterable.from(Pair.zipList(this.compatibleNodes, o.compatibleNodes)).allMatch(p -> ((CompatibleNode)p.getFirst()).cover((CompatibleNode)p.getSecond()));
    }

    public boolean isCompatible(UsagePoint other) {
        return FluentIterable.from(Pair.zipList(this.compatibleNodes, other.compatibleNodes)).allMatch(p -> ((CompatibleNode)p.getFirst()).isCompatibleWith((CompatibleState)p.getSecond()));
    }

    public boolean isEmpty() {
        return FluentIterable.from(this.compatibleNodes).allMatch(CompatibleNode::hasEmptyLockSet);
    }

    public String toString() {
        return this.access + ":" + this.compatibleNodes;
    }

    public <T extends CompatibleNode> T get(Class<T> pClass) {
        for (CompatibleNode node : this.compatibleNodes) {
            if (node.getClass() != pClass) continue;
            return (T)((CompatibleNode)pClass.cast(node));
        }
        return null;
    }
}

