/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedLongs;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayCreationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayInitializer;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayLengthExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBooleanLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassInstanceCreation;
import org.sosy_lab.cpachecker.cfa.ast.java.JEnumConstantExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JNullLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeEqualsType;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JThisExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableRunTimeType;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.ArrayValue;
import org.sosy_lab.cpachecker.cpa.value.type.BooleanValue;
import org.sosy_lab.cpachecker.cpa.value.type.EnumConstantValue;
import org.sosy_lab.cpachecker.cpa.value.type.FunctionValue;
import org.sosy_lab.cpachecker.cpa.value.type.NullValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.BuiltinFloatFunctions;
import org.sosy_lab.cpachecker.util.BuiltinFunctions;
import org.sosy_lab.cpachecker.util.BuiltinOverflowFunctions;

public abstract class AbstractExpressionValueVisitor
extends DefaultCExpressionVisitor<Value, UnrecognizedCodeException>
implements CRightHandSideVisitor<Value, UnrecognizedCodeException>,
JRightHandSideVisitor<Value, NoException>,
JExpressionVisitor<Value, NoException> {
    private static final int SIZE_OF_JAVA_LONG = 64;
    private static final int SIZE_OF_JAVA_FLOAT = 32;
    private static final int SIZE_OF_JAVA_DOUBLE = 64;
    private final String functionName;
    private final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;
    private boolean missingFieldAccessInformation = false;

    protected AbstractExpressionValueVisitor(String pFunctionName, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger) {
        this.functionName = pFunctionName;
        this.machineModel = pMachineModel;
        this.logger = pLogger;
    }

    public boolean hasMissingFieldAccessInformation() {
        return this.missingFieldAccessInformation;
    }

    @Override
    protected Value visitDefault(CExpression pExp) {
        return Value.UnknownValue.getInstance();
    }

    public void reset() {
        this.missingFieldAccessInformation = false;
    }

    @Override
    public Value visit(CBinaryExpression pE) throws UnrecognizedCodeException {
        Value lVal = pE.getOperand1().accept(this);
        if (lVal.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        Value rVal = pE.getOperand2().accept(this);
        if (rVal.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        return AbstractExpressionValueVisitor.calculateBinaryOperation(lVal, rVal, pE, this.machineModel, this.logger);
    }

    public static Value calculateBinaryOperation(Value lVal, Value rVal, CBinaryExpression binaryExpr, MachineModel machineModel, LogManagerWithoutDuplicates logger) {
        Value result;
        CBinaryExpression.BinaryOperator binaryOperator = binaryExpr.getOperator();
        CType calculationType = binaryExpr.getCalculationType();
        lVal = AbstractExpressionValueVisitor.castCValue(lVal, calculationType, machineModel, logger, binaryExpr.getFileLocation());
        if (binaryOperator != CBinaryExpression.BinaryOperator.SHIFT_LEFT && binaryOperator != CBinaryExpression.BinaryOperator.SHIFT_RIGHT) {
            rVal = AbstractExpressionValueVisitor.castCValue(rVal, calculationType, machineModel, logger, binaryExpr.getFileLocation());
        }
        if (lVal instanceof FunctionValue || rVal instanceof FunctionValue) {
            return AbstractExpressionValueVisitor.calculateExpressionWithFunctionValue(binaryOperator, rVal, lVal);
        }
        if (lVal instanceof SymbolicValue || rVal instanceof SymbolicValue) {
            return AbstractExpressionValueVisitor.calculateSymbolicBinaryExpression(lVal, rVal, binaryExpr);
        }
        if (!lVal.isNumericValue() || !rVal.isNumericValue()) {
            logger.logf(Level.FINE, "Parameters to binary operation '%s %s %s' are no numeric values.", new Object[]{lVal, binaryOperator, rVal});
            return Value.UnknownValue.getInstance();
        }
        switch (binaryOperator) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MODULO: 
            case MULTIPLY: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                result = AbstractExpressionValueVisitor.arithmeticOperation((NumericValue)lVal, (NumericValue)rVal, binaryOperator, calculationType, machineModel, (LogManager)logger);
                result = AbstractExpressionValueVisitor.castCValue(result, binaryExpr.getExpressionType(), machineModel, logger, binaryExpr.getFileLocation());
                break;
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: {
                result = AbstractExpressionValueVisitor.booleanOperation((NumericValue)lVal, (NumericValue)rVal, binaryOperator, calculationType, machineModel, (LogManager)logger);
                break;
            }
            default: {
                throw new AssertionError((Object)"unhandled binary operator");
            }
        }
        return result;
    }

    public static Value calculateSymbolicBinaryExpression(Value pLValue, Value pRValue, CBinaryExpression pExpression) {
        CBinaryExpression.BinaryOperator operator = pExpression.getOperator();
        CType leftOperandType = pExpression.getOperand1().getExpressionType();
        CType rightOperandType = pExpression.getOperand2().getExpressionType();
        CType expressionType = pExpression.getExpressionType();
        CType calculationType = pExpression.getCalculationType();
        return AbstractExpressionValueVisitor.createSymbolicExpression(pLValue, leftOperandType, pRValue, rightOperandType, operator, expressionType, calculationType);
    }

    public static Value calculateExpressionWithFunctionValue(CBinaryExpression.BinaryOperator binaryOperator, Value val1, Value val2) {
        if (val1 instanceof FunctionValue) {
            return AbstractExpressionValueVisitor.calculateOperationWithFunctionValue(binaryOperator, (FunctionValue)val1, val2);
        }
        if (val2 instanceof FunctionValue) {
            return AbstractExpressionValueVisitor.calculateOperationWithFunctionValue(binaryOperator, (FunctionValue)val2, val1);
        }
        return new Value.UnknownValue();
    }

    private static NumericValue calculateOperationWithFunctionValue(CBinaryExpression.BinaryOperator binaryOperator, FunctionValue val1, Value val2) {
        switch (binaryOperator) {
            case EQUALS: {
                return new NumericValue(val1.equals(val2) ? 1 : 0);
            }
            case NOT_EQUALS: {
                return new NumericValue(val1.equals(val2) ? 0 : 1);
            }
        }
        throw new AssertionError((Object)("Operation " + binaryOperator + " is not supported for function values"));
    }

    private static SymbolicValue createSymbolicExpression(Value pLeftValue, CType pLeftType, Value pRightValue, CType pRightType, CBinaryExpression.BinaryOperator pOperator, CType pExpressionType, CType pCalculationType) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        SymbolicExpression leftOperand = factory.asConstant(pLeftValue, pLeftType);
        SymbolicExpression rightOperand = factory.asConstant(pRightValue, pRightType);
        switch (pOperator) {
            case PLUS: {
                return factory.add(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case MINUS: {
                return factory.minus(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case MULTIPLY: {
                return factory.multiply(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case DIVIDE: {
                return factory.divide(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case MODULO: {
                return factory.modulo(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case SHIFT_LEFT: {
                return factory.shiftLeft(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case SHIFT_RIGHT: {
                return factory.shiftRightSigned(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case BINARY_AND: {
                return factory.binaryAnd(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case BINARY_OR: {
                return factory.binaryOr(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case BINARY_XOR: {
                return factory.binaryXor(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case EQUALS: {
                return factory.equal(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case NOT_EQUALS: {
                return factory.notEqual(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case LESS_THAN: {
                return factory.lessThan(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case LESS_EQUAL: {
                return factory.lessThanOrEqual(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case GREATER_THAN: {
                return factory.greaterThan(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case GREATER_EQUAL: {
                return factory.greaterThanOrEqual(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
        }
        throw new AssertionError((Object)("Unhandled binary operation " + pOperator));
    }

    private static long arithmeticOperation(long l, long r, CBinaryExpression.BinaryOperator op, CType calculationType, MachineModel machineModel, LogManager logger) {
        CSimpleType st = AbstractExpressionValueVisitor.getArithmeticType(calculationType);
        if (st != null && machineModel.getSizeofInBits(st) >= 64 && st.isUnsigned()) {
            switch (op) {
                case DIVIDE: {
                    if (r == 0L) {
                        logger.logf(Level.SEVERE, "Division by Zero (%d / %d)", new Object[]{l, r});
                        return 0L;
                    }
                    return UnsignedLongs.divide((long)l, (long)r);
                }
                case MODULO: {
                    return UnsignedLongs.remainder((long)l, (long)r);
                }
                case SHIFT_RIGHT: {
                    return l >>> (int)r;
                }
            }
        }
        switch (op) {
            case PLUS: {
                return l + r;
            }
            case MINUS: {
                return l - r;
            }
            case DIVIDE: {
                if (r == 0L) {
                    logger.logf(Level.SEVERE, "Division by Zero (%d / %d)", new Object[]{l, r});
                    return 0L;
                }
                return l / r;
            }
            case MODULO: {
                return l % r;
            }
            case MULTIPLY: {
                return l * r;
            }
            case SHIFT_LEFT: {
                return r >= 64L ? 0L : l << (int)r;
            }
            case SHIFT_RIGHT: {
                return l >> (int)r;
            }
            case BINARY_AND: {
                return l & r;
            }
            case BINARY_OR: {
                return l | r;
            }
            case BINARY_XOR: {
                return l ^ r;
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    private static double arithmeticOperation(double l, double r, CBinaryExpression.BinaryOperator op, CType calculationType) {
        Preconditions.checkArgument((calculationType.getCanonicalType() instanceof CSimpleType && !((CSimpleType)calculationType.getCanonicalType()).isLong() ? 1 : 0) != 0, (Object)"Value analysis can't compute long double values in a precise manner");
        switch (op) {
            case PLUS: {
                return l + r;
            }
            case MINUS: {
                return l - r;
            }
            case DIVIDE: {
                return l / r;
            }
            case MODULO: {
                return l % r;
            }
            case MULTIPLY: {
                return l * r;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                throw new AssertionError((Object)("trying to perform " + op + " on floating point operands"));
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    private static BigInteger arithmeticOperation(BigInteger l, BigInteger r, CBinaryExpression.BinaryOperator op, LogManager logger) {
        switch (op) {
            case PLUS: {
                return l.add(r);
            }
            case MINUS: {
                return l.subtract(r);
            }
            case DIVIDE: {
                if (r.equals(BigInteger.ZERO)) {
                    logger.logf(Level.SEVERE, "Division by Zero (%s / %s)", new Object[]{l.toString(), r.toString()});
                    return BigInteger.ZERO;
                }
                return l.divide(r);
            }
            case MODULO: {
                return l.mod(r);
            }
            case MULTIPLY: {
                return l.multiply(r);
            }
            case SHIFT_LEFT: {
                if (r.compareTo(BigInteger.valueOf(128L)) <= 0 && r.signum() != -1) {
                    return l.shiftLeft(r.intValue());
                }
                logger.logf(Level.SEVERE, "Right-hand side (%s) of the bitshift is larger than 128 or negative.", new Object[]{r.toString()});
                return BigInteger.ZERO;
            }
            case SHIFT_RIGHT: {
                if (r.compareTo(BigInteger.valueOf(128L)) <= 0 && r.signum() != -1) {
                    return l.shiftRight(r.intValue());
                }
                return BigInteger.ZERO;
            }
            case BINARY_AND: {
                return l.and(r);
            }
            case BINARY_OR: {
                return l.or(r);
            }
            case BINARY_XOR: {
                return l.xor(r);
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    private static float arithmeticOperation(float l, float r, CBinaryExpression.BinaryOperator op) {
        switch (op) {
            case PLUS: {
                return l + r;
            }
            case MINUS: {
                return l - r;
            }
            case DIVIDE: {
                return l / r;
            }
            case MODULO: {
                return l % r;
            }
            case MULTIPLY: {
                return l * r;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                throw new AssertionError((Object)("trying to perform " + op + " on floating point operands"));
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    private static Value arithmeticOperation(NumericValue lNum, NumericValue rNum, CBinaryExpression.BinaryOperator op, CType calculationType, MachineModel machineModel, LogManager logger) {
        CSimpleType type = AbstractExpressionValueVisitor.getArithmeticType(calculationType);
        if (type == null) {
            logger.logf(Level.FINE, "unsupported type %s for result of binary operation %s", new Object[]{calculationType, op});
            return Value.UnknownValue.getInstance();
        }
        try {
            switch (type.getType()) {
                case INT: {
                    long lVal = lNum.getNumber().longValue();
                    long rVal = rNum.getNumber().longValue();
                    long result = AbstractExpressionValueVisitor.arithmeticOperation(lVal, rVal, op, calculationType, machineModel, logger);
                    return new NumericValue(result);
                }
                case INT128: {
                    BigInteger lVal = lNum.bigInteger();
                    BigInteger rVal = rNum.bigInteger();
                    BigInteger result = AbstractExpressionValueVisitor.arithmeticOperation(lVal, rVal, op, logger);
                    return new NumericValue(result);
                }
                case DOUBLE: {
                    if (type.isLong()) {
                        return AbstractExpressionValueVisitor.arithmeticOperationForLongDouble(lNum, rNum, op, calculationType, machineModel, logger);
                    }
                    double lVal = lNum.doubleValue();
                    double rVal = rNum.doubleValue();
                    double result = AbstractExpressionValueVisitor.arithmeticOperation(lVal, rVal, op, calculationType);
                    return new NumericValue(result);
                }
                case FLOAT: {
                    float lVal = lNum.floatValue();
                    float rVal = rNum.floatValue();
                    float result = AbstractExpressionValueVisitor.arithmeticOperation(lVal, rVal, op);
                    return new NumericValue(Float.valueOf(result));
                }
            }
            logger.logf(Level.FINE, "unsupported type for result of binary operation %s", new Object[]{type.toString()});
            return Value.UnknownValue.getInstance();
        }
        catch (ArithmeticException ae) {
            logger.logf(Level.WARNING, "expression causes arithmetic exception (%s): %s %s %s", new Object[]{ae.getMessage(), lNum.bigDecimalValue(), op.getOperator(), rNum.bigDecimalValue()});
            return Value.UnknownValue.getInstance();
        }
    }

    private static Value arithmeticOperationForLongDouble(NumericValue pLNum, NumericValue pRNum, CBinaryExpression.BinaryOperator pOp, CType pCalculationType, MachineModel pMachineModel, LogManager pLogger) {
        return Value.UnknownValue.getInstance();
    }

    private static Value booleanOperation(NumericValue l, NumericValue r, CBinaryExpression.BinaryOperator op, CType calculationType, MachineModel machineModel, LogManager logger) {
        int cmp;
        CSimpleType type = AbstractExpressionValueVisitor.getArithmeticType(calculationType);
        if (type == null) {
            logger.logf(Level.FINE, "unsupported type %s for result of binary operation %s", new Object[]{calculationType, op});
            return Value.UnknownValue.getInstance();
        }
        switch (type.getType()) {
            case INT: 
            case INT128: 
            case CHAR: {
                CSimpleType canonicalType = type.getCanonicalType();
                int sizeInBits = machineModel.getSizeof(canonicalType) * machineModel.getSizeofCharInBits();
                if (!machineModel.isSigned(canonicalType) && sizeInBits == 64 || sizeInBits > 64) {
                    BigInteger leftBigInt = l.getNumber() instanceof BigInteger ? (BigInteger)l.getNumber() : BigInteger.valueOf(l.longValue());
                    BigInteger rightBigInt = r.getNumber() instanceof BigInteger ? (BigInteger)r.getNumber() : BigInteger.valueOf(r.longValue());
                    cmp = leftBigInt.compareTo(rightBigInt);
                    break;
                }
                cmp = Long.compare(l.longValue(), r.longValue());
                break;
            }
            case FLOAT: {
                float lVal = l.floatValue();
                float rVal = r.floatValue();
                if (Float.isNaN(lVal) || Float.isNaN(rVal)) {
                    return new NumericValue(op == CBinaryExpression.BinaryOperator.NOT_EQUALS ? 1L : 0L);
                }
                if (lVal == 0.0f && rVal == 0.0f) {
                    cmp = 0;
                    break;
                }
                cmp = Float.compare(lVal, rVal);
                break;
            }
            case DOUBLE: {
                double lVal = l.doubleValue();
                double rVal = r.doubleValue();
                if (Double.isNaN(lVal) || Double.isNaN(rVal)) {
                    return new NumericValue(op == CBinaryExpression.BinaryOperator.NOT_EQUALS ? 1L : 0L);
                }
                if (lVal == 0.0 && rVal == 0.0) {
                    cmp = 0;
                    break;
                }
                cmp = Double.compare(lVal, rVal);
                break;
            }
            default: {
                logger.logf(Level.FINE, "unsupported type %s for result of binary operation %s", new Object[]{type.toString(), op});
                return Value.UnknownValue.getInstance();
            }
        }
        return new NumericValue(AbstractExpressionValueVisitor.matchBooleanOperation(op, cmp) ? 1L : 0L);
    }

    private static boolean matchBooleanOperation(CBinaryExpression.BinaryOperator op, int cmp) {
        switch (op) {
            case GREATER_THAN: {
                return cmp > 0;
            }
            case GREATER_EQUAL: {
                return cmp >= 0;
            }
            case LESS_THAN: {
                return cmp < 0;
            }
            case LESS_EQUAL: {
                return cmp <= 0;
            }
            case EQUALS: {
                return cmp == 0;
            }
            case NOT_EQUALS: {
                return cmp != 0;
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    @Override
    public Value visit(CCastExpression pE) throws UnrecognizedCodeException {
        return AbstractExpressionValueVisitor.castCValue(pE.getOperand().accept(this), pE.getExpressionType(), this.machineModel, this.logger, pE.getFileLocation());
    }

    @Override
    public Value visit(CComplexCastExpression pE) throws UnrecognizedCodeException {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(CFunctionCallExpression pIastFunctionCallExpression) throws UnrecognizedCodeException {
        String calledFunctionName;
        CExpression functionNameExp = pIastFunctionCallExpression.getFunctionNameExpression();
        if (functionNameExp instanceof CIdExpression && BuiltinFunctions.isBuiltinFunction(calledFunctionName = ((CIdExpression)functionNameExp).getName())) {
            CType functionType = BuiltinFunctions.getFunctionType(calledFunctionName);
            if (this.isUnspecifiedType(functionType)) {
                return Value.UnknownValue.getInstance();
            }
            List<CExpression> parameterExpressions = pIastFunctionCallExpression.getParameterExpressions();
            ArrayList<Value> parameterValues = new ArrayList<Value>(parameterExpressions.size());
            for (CExpression currParamExp : parameterExpressions) {
                Value newValue = currParamExp.accept(this);
                parameterValues.add(newValue);
            }
            if (BuiltinOverflowFunctions.isBuiltinOverflowFunction(calledFunctionName)) {
                return BuiltinOverflowFunctions.evaluateFunctionCall(pIastFunctionCallExpression, this, this.machineModel, this.logger);
            }
            if (BuiltinFloatFunctions.matchesAbsolute(calledFunctionName)) {
                assert (parameterValues.size() == 1);
                CType parameterType = parameterExpressions.get(0).getExpressionType();
                Value parameter = (Value)parameterValues.get(0);
                if (parameterType instanceof CSimpleType && !((CSimpleType)parameterType).isSigned()) {
                    return parameter;
                }
                if (parameter.isExplicitlyKnown()) {
                    assert (parameter.isNumericValue());
                    double absoluteValue = Math.abs(((NumericValue)parameter).doubleValue());
                    return new NumericValue(absoluteValue);
                }
            } else {
                Value op2;
                Value op1;
                NumericValue numerValue;
                Value denom;
                Value numer;
                Number op12;
                Value operand2;
                Value operand1;
                Number number;
                Value parameter;
                CSimpleType paramType;
                NumericValue numericValue;
                Value value;
                if (BuiltinFloatFunctions.matchesHugeVal(calledFunctionName) || BuiltinFloatFunctions.matchesInfinity(calledFunctionName)) {
                    assert (parameterValues.isEmpty());
                    if (BuiltinFloatFunctions.matchesHugeValFloat(calledFunctionName) || BuiltinFloatFunctions.matchesInfinityFloat(calledFunctionName)) {
                        return new NumericValue(Float.valueOf(Float.POSITIVE_INFINITY));
                    }
                    assert (BuiltinFloatFunctions.matchesInfinityDouble(calledFunctionName) || BuiltinFloatFunctions.matchesInfinityLongDouble(calledFunctionName) || BuiltinFloatFunctions.matchesHugeValDouble(calledFunctionName) || BuiltinFloatFunctions.matchesHugeValLongDouble(calledFunctionName)) : " Unhandled builtin function for infinity: " + calledFunctionName;
                    return new NumericValue(Double.POSITIVE_INFINITY);
                }
                if (BuiltinFloatFunctions.matchesNaN(calledFunctionName)) {
                    assert (parameterValues.isEmpty() || parameterValues.size() == 1);
                    if (BuiltinFloatFunctions.matchesNaNFloat(calledFunctionName)) {
                        return new NumericValue(Float.valueOf(Float.NaN));
                    }
                    assert (BuiltinFloatFunctions.matchesNaNDouble(calledFunctionName) || BuiltinFloatFunctions.matchesNaNLongDouble(calledFunctionName)) : "Unhandled builtin function for NaN: " + calledFunctionName;
                    return new NumericValue(Double.NaN);
                }
                if (BuiltinFloatFunctions.matchesIsNaN(calledFunctionName)) {
                    if (parameterValues.size() == 1 && (value = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                        numericValue = value.asNumericValue();
                        paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName);
                        switch (paramType.getType()) {
                            case FLOAT: {
                                return Float.isNaN(numericValue.floatValue()) ? new NumericValue(1) : new NumericValue(0);
                            }
                            case DOUBLE: {
                                return Double.isNaN(numericValue.doubleValue()) ? new NumericValue(1) : new NumericValue(0);
                            }
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesIsInfinity(calledFunctionName)) {
                    if (parameterValues.size() == 1 && (value = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                        numericValue = value.asNumericValue();
                        paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName);
                        switch (paramType.getType()) {
                            case FLOAT: {
                                return Float.isInfinite(numericValue.floatValue()) ? new NumericValue(1) : new NumericValue(0);
                            }
                            case DOUBLE: {
                                return Double.isInfinite(numericValue.doubleValue()) ? new NumericValue(1) : new NumericValue(0);
                            }
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesFinite(calledFunctionName)) {
                    if (parameterValues.size() == 1 && (value = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                        numericValue = value.asNumericValue();
                        paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName);
                        switch (paramType.getType()) {
                            case FLOAT: {
                                return Float.isInfinite(numericValue.floatValue()) ? new NumericValue(0) : new NumericValue(1);
                            }
                            case DOUBLE: {
                                return Double.isInfinite(numericValue.doubleValue()) ? new NumericValue(0) : new NumericValue(1);
                            }
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesFloor(calledFunctionName)) {
                    if (parameterValues.size() == 1 && (parameter = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                        assert (parameter.isNumericValue());
                        number = parameter.asNumericValue().getNumber();
                        if (number instanceof BigDecimal) {
                            return new NumericValue(((BigDecimal)number).setScale(0, RoundingMode.FLOOR));
                        }
                        if (number instanceof Float) {
                            return new NumericValue(Math.floor(number.floatValue()));
                        }
                        if (number instanceof Double) {
                            return new NumericValue(Math.floor(number.doubleValue()));
                        }
                        if (number instanceof NumericValue.NegativeNaN) {
                            return parameter;
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesCeil(calledFunctionName)) {
                    if (parameterValues.size() == 1 && (parameter = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                        assert (parameter.isNumericValue());
                        number = parameter.asNumericValue().getNumber();
                        if (number instanceof BigDecimal) {
                            return new NumericValue(((BigDecimal)number).setScale(0, RoundingMode.CEILING));
                        }
                        if (number instanceof Float) {
                            return new NumericValue(Math.ceil(number.floatValue()));
                        }
                        if (number instanceof Double) {
                            return new NumericValue(Math.ceil(number.doubleValue()));
                        }
                        if (number instanceof NumericValue.NegativeNaN) {
                            return parameter;
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesRound(calledFunctionName) || BuiltinFloatFunctions.matchesLround(calledFunctionName) || BuiltinFloatFunctions.matchesLlround(calledFunctionName)) {
                    if (parameterValues.size() == 1 && (parameter = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                        assert (parameter.isNumericValue());
                        number = parameter.asNumericValue().getNumber();
                        if (number instanceof BigDecimal) {
                            return new NumericValue(((BigDecimal)number).setScale(0, RoundingMode.HALF_UP));
                        }
                        if (number instanceof Float) {
                            float f = number.floatValue();
                            if (0.0f == f || Float.isInfinite(f)) {
                                return parameter;
                            }
                            return new NumericValue(Math.round(f));
                        }
                        if (number instanceof Double) {
                            double d = number.doubleValue();
                            if (0.0 == d || Double.isInfinite(d)) {
                                return parameter;
                            }
                            return new NumericValue(Math.round(d));
                        }
                        if (number instanceof NumericValue.NegativeNaN) {
                            return parameter;
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesTrunc(calledFunctionName)) {
                    if (parameterValues.size() == 1 && (parameter = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                        assert (parameter.isNumericValue());
                        number = parameter.asNumericValue().getNumber();
                        if (number instanceof BigDecimal) {
                            return new NumericValue(((BigDecimal)number).setScale(0, RoundingMode.DOWN));
                        }
                        if (number instanceof Float) {
                            float f = number.floatValue();
                            if (0.0f == f || Float.isInfinite(f) || Float.isNaN(f)) {
                                return parameter;
                            }
                            return new NumericValue(Float.valueOf(BigDecimal.valueOf(number.floatValue()).setScale(0, RoundingMode.DOWN).floatValue()));
                        }
                        if (number instanceof Double) {
                            double d = number.doubleValue();
                            if (0.0 == d || Double.isInfinite(d) || Double.isNaN(d)) {
                                return parameter;
                            }
                            return new NumericValue(BigDecimal.valueOf(number.doubleValue()).setScale(0, RoundingMode.DOWN).doubleValue());
                        }
                        if (number instanceof NumericValue.NegativeNaN) {
                            return parameter;
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesFdim(calledFunctionName)) {
                    if (parameterValues.size() == 2) {
                        operand1 = (Value)parameterValues.get(0);
                        operand2 = (Value)parameterValues.get(1);
                        if (operand1.isExplicitlyKnown() && operand2.isExplicitlyKnown()) {
                            assert (operand1.isNumericValue());
                            assert (operand2.isNumericValue());
                            op12 = operand1.asNumericValue().getNumber();
                            Number op22 = operand2.asNumericValue().getNumber();
                            Value result = this.fdim(op12, op22, calledFunctionName);
                            if (!Value.UnknownValue.getInstance().equals(result)) {
                                return result;
                            }
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesFmax(calledFunctionName)) {
                    if (parameterValues.size() == 2) {
                        operand1 = (Value)parameterValues.get(0);
                        operand2 = (Value)parameterValues.get(1);
                        if (operand1.isExplicitlyKnown() && operand2.isExplicitlyKnown()) {
                            assert (operand1.isNumericValue());
                            assert (operand2.isNumericValue());
                            op12 = operand1.asNumericValue().getNumber();
                            Number op23 = operand2.asNumericValue().getNumber();
                            return this.fmax(op12, op23);
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesFmin(calledFunctionName)) {
                    if (parameterValues.size() == 2) {
                        operand1 = (Value)parameterValues.get(0);
                        operand2 = (Value)parameterValues.get(1);
                        if (operand1.isExplicitlyKnown() && operand2.isExplicitlyKnown()) {
                            assert (operand1.isNumericValue());
                            assert (operand2.isNumericValue());
                            op12 = operand1.asNumericValue().getNumber();
                            Number op24 = operand2.asNumericValue().getNumber();
                            return this.fmin(op12, op24);
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesSignbit(calledFunctionName)) {
                    if (parameterValues.size() == 1 && (parameter = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                        assert (parameter.isNumericValue());
                        number = parameter.asNumericValue().getNumber();
                        Optional<Boolean> isNegative = this.isNegative(number);
                        if (isNegative.isPresent()) {
                            return new NumericValue(isNegative.orElseThrow() != false ? 1 : 0);
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesCopysign(calledFunctionName)) {
                    if (parameterValues.size() == 2) {
                        Value target = (Value)parameterValues.get(0);
                        Value source = (Value)parameterValues.get(1);
                        if (target.isExplicitlyKnown() && source.isExplicitlyKnown()) {
                            assert (target.isNumericValue());
                            assert (source.isNumericValue());
                            Number targetNumber = target.asNumericValue().getNumber();
                            Number sourceNumber = source.asNumericValue().getNumber();
                            Optional<Boolean> sourceNegative = this.isNegative(sourceNumber);
                            Optional<Boolean> targetNegative = this.isNegative(targetNumber);
                            if (sourceNegative.isPresent() && targetNegative.isPresent()) {
                                if (sourceNegative.orElseThrow().equals(targetNegative.orElseThrow())) {
                                    return new NumericValue(targetNumber);
                                }
                                return target.asNumericValue().negate();
                            }
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesFloatClassify(calledFunctionName)) {
                    if (parameterValues.size() == 1 && (value = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                        numericValue = value.asNumericValue();
                        paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName);
                        switch (paramType.getType()) {
                            case FLOAT: {
                                float v = numericValue.floatValue();
                                if (Float.isNaN(v)) {
                                    return new NumericValue(0);
                                }
                                if (Float.isInfinite(v)) {
                                    return new NumericValue(1);
                                }
                                if ((double)v == 0.0) {
                                    return new NumericValue(2);
                                }
                                if (Float.toHexString(v).startsWith("0x0.")) {
                                    return new NumericValue(3);
                                }
                                return new NumericValue(4);
                            }
                            case DOUBLE: {
                                double v = numericValue.doubleValue();
                                if (Double.isNaN(v)) {
                                    return new NumericValue(0);
                                }
                                if (Double.isInfinite(v)) {
                                    return new NumericValue(1);
                                }
                                if (v == 0.0) {
                                    return new NumericValue(2);
                                }
                                if (Double.toHexString(v).startsWith("0x0.")) {
                                    return new NumericValue(3);
                                }
                                return new NumericValue(4);
                            }
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesModf(calledFunctionName)) {
                    if (parameterValues.size() == 2 && (value = (Value)parameterValues.get(0)).isExplicitlyKnown()) {
                        numericValue = value.asNumericValue();
                        paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName);
                        switch (paramType.getType()) {
                            case FLOAT: {
                                long integralPart = (long)numericValue.floatValue();
                                float fractionalPart = numericValue.floatValue() - (float)integralPart;
                                return new NumericValue(Float.valueOf(fractionalPart));
                            }
                            case DOUBLE: {
                                long integralPart = (long)numericValue.doubleValue();
                                double fractionalPart = numericValue.doubleValue() - (double)integralPart;
                                return new NumericValue(fractionalPart);
                            }
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesFremainder(calledFunctionName)) {
                    if (parameterValues.size() == 2) {
                        numer = (Value)parameterValues.get(0);
                        denom = (Value)parameterValues.get(1);
                        if (numer.isExplicitlyKnown() && denom.isExplicitlyKnown()) {
                            numerValue = numer.asNumericValue();
                            NumericValue denomValue = denom.asNumericValue();
                            switch (BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName).getType()) {
                                case FLOAT: {
                                    float num = numerValue.floatValue();
                                    float den = denomValue.floatValue();
                                    if (Float.isNaN(num) || Float.isNaN(den) || Float.isInfinite(num) || den == 0.0f) {
                                        return new NumericValue(Float.valueOf(Float.NaN));
                                    }
                                    return new NumericValue(Float.valueOf((float)Math.IEEEremainder(num, den)));
                                }
                                case DOUBLE: {
                                    double num = numerValue.doubleValue();
                                    double den = denomValue.doubleValue();
                                    if (Double.isNaN(num) || Double.isNaN(den) || Double.isInfinite(num) || den == 0.0) {
                                        return new NumericValue(Double.NaN);
                                    }
                                    return new NumericValue(Math.IEEEremainder(num, den));
                                }
                            }
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesFmod(calledFunctionName)) {
                    if (parameterValues.size() == 2) {
                        numer = (Value)parameterValues.get(0);
                        denom = (Value)parameterValues.get(1);
                        if (numer.isExplicitlyKnown() && denom.isExplicitlyKnown()) {
                            numerValue = numer.asNumericValue();
                            NumericValue denomValue = denom.asNumericValue();
                            switch (BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(calledFunctionName).getType()) {
                                case FLOAT: {
                                    float num = numerValue.floatValue();
                                    float den = denomValue.floatValue();
                                    if (Float.isNaN(num) || Float.isNaN(den) || Float.isInfinite(num) || den == 0.0f) {
                                        return new NumericValue(Float.valueOf(Float.NaN));
                                    }
                                    if (num == 0.0f && den != 0.0f) {
                                        return numer;
                                    }
                                    return new NumericValue(Float.valueOf(num % den));
                                }
                                case DOUBLE: {
                                    double num = numerValue.doubleValue();
                                    double den = denomValue.doubleValue();
                                    if (Double.isNaN(num) || Double.isNaN(den) || Double.isInfinite(num) || den == 0.0) {
                                        return new NumericValue(Double.NaN);
                                    }
                                    if (num == 0.0 && den != 0.0) {
                                        return numer;
                                    }
                                    return new NumericValue(num % den);
                                }
                            }
                        }
                    }
                } else if (BuiltinFloatFunctions.matchesIsgreater(calledFunctionName)) {
                    op1 = (Value)parameterValues.get(0);
                    op2 = (Value)parameterValues.get(1);
                    if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                        double num2;
                        double num1 = op1.asNumericValue().doubleValue();
                        return new NumericValue(num1 > (num2 = op2.asNumericValue().doubleValue()) ? 1 : 0);
                    }
                } else if (BuiltinFloatFunctions.matchesIsgreaterequal(calledFunctionName)) {
                    op1 = (Value)parameterValues.get(0);
                    op2 = (Value)parameterValues.get(1);
                    if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                        double num2;
                        double num1 = op1.asNumericValue().doubleValue();
                        return new NumericValue(num1 >= (num2 = op2.asNumericValue().doubleValue()) ? 1 : 0);
                    }
                } else if (BuiltinFloatFunctions.matchesIsless(calledFunctionName)) {
                    op1 = (Value)parameterValues.get(0);
                    op2 = (Value)parameterValues.get(1);
                    if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                        double num2;
                        double num1 = op1.asNumericValue().doubleValue();
                        return new NumericValue(num1 < (num2 = op2.asNumericValue().doubleValue()) ? 1 : 0);
                    }
                } else if (BuiltinFloatFunctions.matchesIslessequal(calledFunctionName)) {
                    op1 = (Value)parameterValues.get(0);
                    op2 = (Value)parameterValues.get(1);
                    if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                        double num2;
                        double num1 = op1.asNumericValue().doubleValue();
                        return new NumericValue(num1 <= (num2 = op2.asNumericValue().doubleValue()) ? 1 : 0);
                    }
                } else if (BuiltinFloatFunctions.matchesIslessgreater(calledFunctionName)) {
                    op1 = (Value)parameterValues.get(0);
                    op2 = (Value)parameterValues.get(1);
                    if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                        double num2;
                        double num1 = op1.asNumericValue().doubleValue();
                        return new NumericValue(num1 > (num2 = op2.asNumericValue().doubleValue()) || num1 < num2 ? 1 : 0);
                    }
                } else if (BuiltinFloatFunctions.matchesIsunordered(calledFunctionName)) {
                    op1 = (Value)parameterValues.get(0);
                    op2 = (Value)parameterValues.get(1);
                    if (op1.isExplicitlyKnown() && op2.isExplicitlyKnown()) {
                        double num1 = op1.asNumericValue().doubleValue();
                        double num2 = op2.asNumericValue().doubleValue();
                        return new NumericValue(Double.isNaN(num1) || Double.isNaN(num2) ? 1 : 0);
                    }
                }
            }
        }
        return Value.UnknownValue.getInstance();
    }

    private Value fmax(Number pOp1, Number pOp2) {
        BigDecimal op2bd;
        if (Double.isNaN(pOp1.doubleValue()) || Double.isInfinite(pOp1.doubleValue()) && pOp1.doubleValue() < 0.0 || Double.isInfinite(pOp2.doubleValue()) && pOp2.doubleValue() > 0.0) {
            return new NumericValue(pOp2);
        }
        if (Double.isNaN(pOp2.doubleValue()) || Double.isInfinite(pOp2.doubleValue()) && pOp2.doubleValue() < 0.0 || Double.isInfinite(pOp1.doubleValue()) && pOp1.doubleValue() > 0.0) {
            return new NumericValue(pOp1);
        }
        BigDecimal op1bd = pOp1 instanceof BigDecimal ? (BigDecimal)pOp1 : BigDecimal.valueOf(pOp1.doubleValue());
        if (op1bd.compareTo(op2bd = pOp2 instanceof BigDecimal ? (BigDecimal)pOp2 : BigDecimal.valueOf(pOp2.doubleValue())) > 0) {
            return new NumericValue(op1bd);
        }
        return new NumericValue(op2bd);
    }

    private Value fmin(Number pOp1, Number pOp2) {
        BigDecimal op2bd;
        if (Double.isNaN(pOp1.doubleValue()) || Double.isInfinite(pOp1.doubleValue()) && pOp1.doubleValue() > 0.0 || Double.isInfinite(pOp2.doubleValue()) && pOp2.doubleValue() < 0.0) {
            return new NumericValue(pOp2);
        }
        if (Double.isNaN(pOp2.doubleValue()) || Double.isInfinite(pOp2.doubleValue()) && pOp2.doubleValue() > 0.0 || Double.isInfinite(pOp1.doubleValue()) && pOp1.doubleValue() < 0.0) {
            return new NumericValue(pOp1);
        }
        BigDecimal op1bd = pOp1 instanceof BigDecimal ? (BigDecimal)pOp1 : BigDecimal.valueOf(pOp1.doubleValue());
        if (op1bd.compareTo(op2bd = pOp2 instanceof BigDecimal ? (BigDecimal)pOp2 : BigDecimal.valueOf(pOp2.doubleValue())) < 0) {
            return new NumericValue(op1bd);
        }
        return new NumericValue(op2bd);
    }

    private Value fdim(Number pOp1, Number pOp2, String pFunctionName) {
        BigDecimal op2bd;
        if (Double.isNaN(pOp1.doubleValue()) || Double.isNaN(pOp2.doubleValue())) {
            return new NumericValue(Double.NaN);
        }
        if (Double.isInfinite(pOp1.doubleValue())) {
            if (Double.isInfinite(pOp2.doubleValue())) {
                if (pOp1.doubleValue() > pOp2.doubleValue()) {
                    return new NumericValue(pOp1.doubleValue() - pOp2.doubleValue());
                }
                return new NumericValue(0.0);
            }
            if (pOp1.doubleValue() < 0.0) {
                return new NumericValue(0.0);
            }
            return new NumericValue(pOp1);
        }
        if (Double.isInfinite(pOp2.doubleValue())) {
            if (pOp2.doubleValue() < 0.0) {
                return new NumericValue(Double.NaN);
            }
            return new NumericValue(0.0);
        }
        BigDecimal op1bd = pOp1 instanceof BigDecimal ? (BigDecimal)pOp1 : BigDecimal.valueOf(pOp1.doubleValue());
        if (op1bd.compareTo(op2bd = pOp2 instanceof BigDecimal ? (BigDecimal)pOp2 : BigDecimal.valueOf(pOp2.doubleValue())) > 0) {
            BigDecimal maxValue;
            BigDecimal difference = op1bd.subtract(op2bd);
            CSimpleType type = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(pFunctionName);
            switch (type.getType()) {
                case FLOAT: {
                    maxValue = BigDecimal.valueOf(3.4028234663852886E38);
                    break;
                }
                case DOUBLE: {
                    maxValue = BigDecimal.valueOf(Double.MAX_VALUE);
                    break;
                }
                default: {
                    return Value.UnknownValue.getInstance();
                }
            }
            if (difference.compareTo(maxValue) > 0) {
                return new NumericValue(Double.POSITIVE_INFINITY);
            }
            return new NumericValue(difference);
        }
        return new NumericValue(0.0);
    }

    private Optional<Boolean> isNegative(Number pNumber) {
        if (pNumber instanceof BigDecimal) {
            return Optional.of(((BigDecimal)pNumber).signum() < 0);
        }
        if (pNumber instanceof Float) {
            float number = pNumber.floatValue();
            if (Float.isNaN(number)) {
                return Optional.of(false);
            }
            return Optional.of(number < 0.0f || 1.0f / number < 0.0f);
        }
        if (pNumber instanceof Double) {
            double number = pNumber.doubleValue();
            if (Double.isNaN(number)) {
                return Optional.of(false);
            }
            return Optional.of(number < 0.0 || 1.0 / number < 0.0);
        }
        if (pNumber instanceof NumericValue.NegativeNaN) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    private boolean isUnspecifiedType(CType pType) {
        return pType instanceof CSimpleType && ((CSimpleType)pType).getType() == CBasicType.UNSPECIFIED;
    }

    @Override
    public Value visit(CCharLiteralExpression pE) throws UnrecognizedCodeException {
        return new NumericValue((long)pE.getCharacter());
    }

    @Override
    public Value visit(CFloatLiteralExpression pE) throws UnrecognizedCodeException {
        return new NumericValue(pE.getValue());
    }

    @Override
    public Value visit(CIntegerLiteralExpression pE) throws UnrecognizedCodeException {
        return new NumericValue(pE.getValue());
    }

    @Override
    public Value visit(CImaginaryLiteralExpression pE) throws UnrecognizedCodeException {
        return pE.getValue().accept(this);
    }

    @Override
    public Value visit(CStringLiteralExpression pE) throws UnrecognizedCodeException {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(CTypeIdExpression pE) {
        CTypeIdExpression.TypeIdOperator idOperator = pE.getOperator();
        CType innerType = pE.getType();
        switch (idOperator) {
            case SIZEOF: {
                BigInteger size = this.machineModel.getSizeof(innerType);
                return new NumericValue(size);
            }
        }
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(CIdExpression idExp) throws UnrecognizedCodeException {
        if (idExp.getDeclaration() instanceof CEnumType.CEnumerator) {
            CEnumType.CEnumerator enumerator = (CEnumType.CEnumerator)idExp.getDeclaration();
            if (enumerator.hasValue()) {
                return new NumericValue(enumerator.getValue());
            }
            return Value.UnknownValue.getInstance();
        }
        return this.evaluateCIdExpression(idExp);
    }

    @Override
    public Value visit(CUnaryExpression unaryExpression) throws UnrecognizedCodeException {
        CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
        CExpression unaryOperand = unaryExpression.getOperand();
        if (unaryOperator == CUnaryExpression.UnaryOperator.SIZEOF) {
            return new NumericValue(this.machineModel.getSizeof(unaryOperand.getExpressionType()));
        }
        if (unaryOperator == CUnaryExpression.UnaryOperator.ALIGNOF) {
            return new NumericValue(this.machineModel.getAlignof(unaryOperand.getExpressionType()));
        }
        if (unaryOperator == CUnaryExpression.UnaryOperator.AMPER) {
            return Value.UnknownValue.getInstance();
        }
        Value value = unaryOperand.accept(this);
        if (value.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        if (value instanceof SymbolicValue) {
            CType expressionType = unaryExpression.getExpressionType();
            CType operandType = unaryOperand.getExpressionType();
            return this.createSymbolicExpression(value, operandType, unaryOperator, expressionType);
        }
        if (!value.isNumericValue()) {
            this.logger.logf(Level.FINE, "Invalid argument %s for unary operator %s.", new Object[]{value, unaryOperator});
            return Value.UnknownValue.getInstance();
        }
        NumericValue numericValue = (NumericValue)value;
        switch (unaryOperator) {
            case MINUS: {
                return numericValue.negate();
            }
            case TILDE: {
                return new NumericValue(numericValue.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        throw new AssertionError((Object)("unknown operator: " + unaryOperator));
    }

    private Value createSymbolicExpression(Value pValue, CType pOperandType, CUnaryExpression.UnaryOperator pUnaryOperator, CType pExpressionType) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        SymbolicExpression operand = factory.asConstant(pValue, pOperandType);
        switch (pUnaryOperator) {
            case MINUS: {
                return factory.negate(operand, pExpressionType);
            }
            case TILDE: {
                return factory.binaryNot(operand, pExpressionType);
            }
        }
        throw new AssertionError((Object)("Unhandled unary operator " + pUnaryOperator));
    }

    @Override
    public Value visit(CPointerExpression pointerExpression) throws UnrecognizedCodeException {
        return this.evaluateCPointerExpression(pointerExpression);
    }

    @Override
    public Value visit(CFieldReference fieldReferenceExpression) throws UnrecognizedCodeException {
        return this.evaluateCFieldReference(fieldReferenceExpression);
    }

    @Override
    public Value visit(CArraySubscriptExpression pE) throws UnrecognizedCodeException {
        return this.evaluateCArraySubscriptExpression(pE);
    }

    @Override
    public Value visit(JCharLiteralExpression pE) {
        return new NumericValue((long)pE.getCharacter());
    }

    @Override
    public Value visit(JBinaryExpression pE) {
        JBinaryExpression.BinaryOperator binaryOperator = pE.getOperator();
        JExpression lVarInBinaryExp = pE.getOperand1();
        JExpression rVarInBinaryExp = pE.getOperand2();
        JType lValType = lVarInBinaryExp.getExpressionType();
        JType rValType = rVarInBinaryExp.getExpressionType();
        JType expressionType = pE.getExpressionType();
        Value lValue = lVarInBinaryExp.accept(this);
        if (lValue.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        Value rValue = rVarInBinaryExp.accept(this);
        if (rValue.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        try {
            return this.calculateBinaryOperation(binaryOperator, lValue, lValType, rValue, rValType, expressionType, pE);
        }
        catch (IllegalOperationException e) {
            this.logger.logUserException(Level.SEVERE, (Throwable)e, pE.getFileLocation().toString());
            return Value.UnknownValue.getInstance();
        }
    }

    private Value calculateBinaryOperation(JBinaryExpression.BinaryOperator pOperator, Value pLValue, JType pLType, Value pRValue, JType pRType, JType pExpType, JBinaryExpression pExpression) throws IllegalOperationException {
        assert (!pLValue.isUnknown() && !pRValue.isUnknown());
        if (pLValue instanceof SymbolicValue || pRValue instanceof SymbolicValue) {
            JType expressionType = pExpression.getExpressionType();
            return this.createSymbolicExpression(pLValue, pLType, pRValue, pRType, pOperator, expressionType, expressionType);
        }
        if (pLValue instanceof NumericValue) {
            assert (pRValue instanceof NumericValue);
            assert (pLType instanceof JSimpleType && pRType instanceof JSimpleType);
            assert (pExpType instanceof JSimpleType);
            if (AbstractExpressionValueVisitor.isFloatType(pLType) || AbstractExpressionValueVisitor.isFloatType(pRType)) {
                return this.calculateFloatOperation((NumericValue)pLValue, (NumericValue)pRValue, pOperator, ((JSimpleType)pLType).getType(), ((JSimpleType)pRType).getType());
            }
            return this.calculateIntegerOperation((NumericValue)pLValue, (NumericValue)pRValue, pOperator, ((JSimpleType)pLType).getType(), ((JSimpleType)pRType).getType());
        }
        if (pLValue instanceof BooleanValue) {
            assert (pRValue instanceof BooleanValue);
            boolean lVal = ((BooleanValue)pLValue).isTrue();
            boolean rVal = ((BooleanValue)pRValue).isTrue();
            return this.calculateBooleanOperation(lVal, rVal, pOperator);
        }
        if (pOperator == JBinaryExpression.BinaryOperator.EQUALS || pOperator == JBinaryExpression.BinaryOperator.NOT_EQUALS) {
            return this.calculateComparison(pLValue, pRValue, pOperator);
        }
        return Value.UnknownValue.getInstance();
    }

    private Value createSymbolicExpression(Value pLeftValue, JType pLeftType, Value pRightValue, JType pRightType, JBinaryExpression.BinaryOperator pOperator, JType pExpressionType, JType pCalculationType) {
        assert (pLeftValue instanceof SymbolicValue || pRightValue instanceof SymbolicValue);
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        SymbolicExpression leftOperand = factory.asConstant(pLeftValue, pLeftType);
        SymbolicExpression rightOperand = factory.asConstant(pRightValue, pRightType);
        switch (pOperator) {
            case PLUS: {
                return factory.add(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case MINUS: {
                return factory.minus(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case MULTIPLY: {
                return factory.multiply(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case DIVIDE: {
                return factory.divide(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case MODULO: {
                return factory.modulo(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case SHIFT_LEFT: {
                return factory.shiftLeft(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case SHIFT_RIGHT_SIGNED: {
                return factory.shiftRightSigned(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case SHIFT_RIGHT_UNSIGNED: {
                return factory.shiftRightUnsigned(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case BINARY_AND: {
                return factory.binaryAnd(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case LOGICAL_AND: {
                return factory.logicalAnd(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case BINARY_OR: {
                return factory.binaryOr(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case LOGICAL_OR: {
                return factory.logicalOr(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case BINARY_XOR: 
            case LOGICAL_XOR: {
                return factory.binaryXor(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case EQUALS: {
                return factory.equal(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case NOT_EQUALS: {
                return factory.notEqual(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case LESS_THAN: {
                return factory.lessThan(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case LESS_EQUAL: {
                return factory.lessThanOrEqual(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case GREATER_THAN: {
                return factory.greaterThan(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
            case GREATER_EQUAL: {
                return factory.greaterThanOrEqual(leftOperand, rightOperand, pExpressionType, pCalculationType);
            }
        }
        throw new AssertionError((Object)("Unhandled binary operation " + pOperator));
    }

    private Value calculateIntegerOperation(NumericValue pLeftValue, NumericValue pRightValue, JBinaryExpression.BinaryOperator pBinaryOperator, JBasicType pLeftType, JBasicType pRightType) throws IllegalOperationException {
        Preconditions.checkNotNull((Object)((Object)pLeftType));
        Preconditions.checkNotNull((Object)((Object)pRightType));
        long lVal = pLeftValue.longValue();
        long rVal = pRightValue.longValue();
        switch (pBinaryOperator) {
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT_SIGNED: 
            case SHIFT_RIGHT_UNSIGNED: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                long numResult;
                switch (pBinaryOperator) {
                    case PLUS: {
                        numResult = lVal + rVal;
                        break;
                    }
                    case MINUS: {
                        numResult = lVal - rVal;
                        break;
                    }
                    case DIVIDE: {
                        if (rVal == 0L) {
                            throw new IllegalOperationException("Division by zero: " + lVal + " / " + rVal);
                        }
                        numResult = lVal / rVal;
                        break;
                    }
                    case MULTIPLY: {
                        numResult = lVal * rVal;
                        break;
                    }
                    case BINARY_AND: {
                        numResult = lVal & rVal;
                        break;
                    }
                    case BINARY_OR: {
                        numResult = lVal | rVal;
                        break;
                    }
                    case BINARY_XOR: {
                        numResult = lVal ^ rVal;
                        break;
                    }
                    case MODULO: {
                        numResult = lVal % rVal;
                        break;
                    }
                    case SHIFT_LEFT: {
                        int intResult;
                        if (pLeftType != JBasicType.LONG && pRightType != JBasicType.LONG) {
                            intResult = (int)lVal << (int)rVal;
                            numResult = intResult;
                            break;
                        }
                        numResult = lVal << (int)rVal;
                        break;
                    }
                    case SHIFT_RIGHT_SIGNED: {
                        int intResult;
                        if (pLeftType != JBasicType.LONG && pRightType != JBasicType.LONG) {
                            intResult = (int)lVal >> (int)rVal;
                            numResult = intResult;
                            break;
                        }
                        numResult = lVal >> (int)rVal;
                        break;
                    }
                    case SHIFT_RIGHT_UNSIGNED: {
                        int intResult;
                        if (pLeftType != JBasicType.LONG && pRightType != JBasicType.LONG) {
                            intResult = (int)lVal >>> (int)rVal;
                            numResult = intResult;
                            break;
                        }
                        numResult = lVal >>> (int)rVal;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled operator " + pBinaryOperator));
                    }
                }
                if (pLeftType != JBasicType.LONG && pRightType != JBasicType.LONG) {
                    int intNumResult = (int)numResult;
                    numResult = intNumResult;
                }
                return new NumericValue(numResult);
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                boolean result;
                switch (pBinaryOperator) {
                    case EQUALS: {
                        result = lVal == rVal;
                        break;
                    }
                    case NOT_EQUALS: {
                        result = lVal != rVal;
                        break;
                    }
                    case GREATER_THAN: {
                        result = lVal > rVal;
                        break;
                    }
                    case GREATER_EQUAL: {
                        result = lVal >= rVal;
                        break;
                    }
                    case LESS_THAN: {
                        result = lVal < rVal;
                        break;
                    }
                    case LESS_EQUAL: {
                        result = lVal <= rVal;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled operation " + pBinaryOperator));
                    }
                }
                return BooleanValue.valueOf(result);
            }
        }
        return Value.UnknownValue.getInstance();
    }

    private Value calculateFloatOperation(NumericValue pLeftValue, NumericValue pRightValue, JBinaryExpression.BinaryOperator pBinaryOperator, JBasicType pLeftOperand, JBasicType pRightOperand) throws IllegalOperationException {
        double rVal;
        double lVal;
        if (pLeftOperand != JBasicType.DOUBLE && pRightOperand != JBasicType.DOUBLE) {
            lVal = pLeftValue.floatValue();
            rVal = pRightValue.floatValue();
        } else {
            lVal = pLeftValue.doubleValue();
            rVal = pRightValue.doubleValue();
        }
        switch (pBinaryOperator) {
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: {
                switch (pBinaryOperator) {
                    case PLUS: {
                        return new NumericValue(lVal + rVal);
                    }
                    case MINUS: {
                        return new NumericValue(lVal - rVal);
                    }
                    case DIVIDE: {
                        if (rVal == 0.0) {
                            throw new IllegalOperationException("Division by zero: " + lVal + " / " + rVal);
                        }
                        return new NumericValue(lVal / rVal);
                    }
                    case MULTIPLY: {
                        return new NumericValue(lVal * rVal);
                    }
                    case MODULO: {
                        return new NumericValue(lVal % rVal);
                    }
                }
                throw new AssertionError((Object)("Unsupported binary operation " + pBinaryOperator + " on double values"));
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                boolean result;
                switch (pBinaryOperator) {
                    case EQUALS: {
                        result = lVal == rVal;
                        break;
                    }
                    case NOT_EQUALS: {
                        result = lVal != rVal;
                        break;
                    }
                    case GREATER_THAN: {
                        result = lVal > rVal;
                        break;
                    }
                    case GREATER_EQUAL: {
                        result = lVal >= rVal;
                        break;
                    }
                    case LESS_THAN: {
                        result = lVal < rVal;
                        break;
                    }
                    case LESS_EQUAL: {
                        result = lVal <= rVal;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unsupported binary operation " + pBinaryOperator + " on floating point values"));
                    }
                }
                return BooleanValue.valueOf(result);
            }
        }
        return Value.UnknownValue.getInstance();
    }

    private Value calculateBooleanOperation(boolean lVal, boolean rVal, JBinaryExpression.BinaryOperator operator) {
        switch (operator) {
            case LOGICAL_AND: 
            case CONDITIONAL_AND: {
                return BooleanValue.valueOf(lVal && rVal);
            }
            case LOGICAL_OR: 
            case CONDITIONAL_OR: {
                return BooleanValue.valueOf(lVal || rVal);
            }
            case LOGICAL_XOR: {
                return BooleanValue.valueOf(lVal ^ rVal);
            }
            case EQUALS: {
                return BooleanValue.valueOf(lVal == rVal);
            }
            case NOT_EQUALS: {
                return BooleanValue.valueOf(lVal != rVal);
            }
        }
        throw new AssertionError((Object)("Unhandled operator " + operator + " for boolean expression"));
    }

    private Value calculateComparison(Value pLeftValue, Value pRightValue, JBinaryExpression.BinaryOperator pOperator) {
        assert (pOperator == JBinaryExpression.BinaryOperator.NOT_EQUALS || pOperator == JBinaryExpression.BinaryOperator.EQUALS);
        return BooleanValue.valueOf(pOperator != JBinaryExpression.BinaryOperator.EQUALS ^ pLeftValue.equals(pRightValue));
    }

    @Override
    public Value visit(JIdExpression idExp) {
        JSimpleDeclaration decl = idExp.getDeclaration();
        if (decl == null) {
            return Value.UnknownValue.getInstance();
        }
        if (decl instanceof JFieldDeclaration && !((JFieldDeclaration)decl).isStatic()) {
            this.missingFieldAccessInformation = true;
            return Value.UnknownValue.getInstance();
        }
        return this.evaluateJIdExpression(idExp);
    }

    @Override
    public Value visit(JUnaryExpression unaryExpression) {
        JUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
        JExpression unaryOperand = unaryExpression.getOperand();
        Value valueObject = unaryOperand.accept(this);
        String errorMsg = "Invalid argument [" + valueObject + "] for unary operator [" + unaryOperator + "].";
        if (valueObject.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        if (valueObject.isNumericValue()) {
            NumericValue value = (NumericValue)valueObject;
            switch (unaryOperator) {
                case MINUS: {
                    return value.negate();
                }
                case COMPLEMENT: {
                    return this.evaluateComplement(unaryOperand, value);
                }
                case PLUS: {
                    return value;
                }
            }
            this.logger.log(Level.FINE, new Object[]{errorMsg});
            return Value.UnknownValue.getInstance();
        }
        if (valueObject instanceof BooleanValue && unaryOperator == JUnaryExpression.UnaryOperator.NOT) {
            return ((BooleanValue)valueObject).negate();
        }
        if (valueObject instanceof SymbolicValue) {
            JType expressionType = unaryExpression.getExpressionType();
            JType operandType = unaryOperand.getExpressionType();
            return this.createSymbolicExpression(valueObject, operandType, unaryOperator, expressionType);
        }
        this.logger.log(Level.FINE, new Object[]{errorMsg});
        return Value.UnknownValue.getInstance();
    }

    private Value createSymbolicExpression(Value pValue, JType pOperandType, JUnaryExpression.UnaryOperator pUnaryOperator, JType pExpressionType) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        SymbolicExpression operand = factory.asConstant(pValue, pOperandType);
        switch (pUnaryOperator) {
            case COMPLEMENT: {
                return factory.binaryNot(operand, pExpressionType);
            }
            case NOT: {
                return factory.logicalNot(operand, pExpressionType);
            }
            case MINUS: {
                return factory.negate(operand, pExpressionType);
            }
            case PLUS: {
                return pValue;
            }
        }
        throw new AssertionError((Object)("Unhandled unary operator " + pUnaryOperator));
    }

    private Value evaluateComplement(JExpression pExpression, NumericValue value) {
        JType type = pExpression.getExpressionType();
        if (AbstractExpressionValueVisitor.isIntegerType(type)) {
            return new NumericValue(value.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.logger.logf(Level.FINE, "Invalid argument %s for unary operator ~.", new Object[]{value});
        return Value.UnknownValue.getInstance();
    }

    private static boolean isIntegerType(JType type) {
        return type instanceof JSimpleType && ((JSimpleType)type).getType().isIntegerType();
    }

    private static boolean isFloatType(JType type) {
        return type instanceof JSimpleType && ((JSimpleType)type).getType().isFloatingPointType();
    }

    @Override
    public Value visit(JIntegerLiteralExpression pE) {
        return new NumericValue(pE.asLong());
    }

    @Override
    public Value visit(JBooleanLiteralExpression pE) {
        return BooleanValue.valueOf(pE.getBoolean());
    }

    @Override
    public Value visit(JArraySubscriptExpression pJArraySubscriptExpression) {
        Value subscriptValue = pJArraySubscriptExpression.getSubscriptExpression().accept(this);
        JExpression arrayExpression = pJArraySubscriptExpression.getArrayExpression();
        Value idValue = arrayExpression.accept(this);
        if (!idValue.isUnknown() && subscriptValue.isNumericValue()) {
            ArrayValue innerMostArray = (ArrayValue)arrayExpression.accept(this);
            assert (((NumericValue)subscriptValue).longValue() >= 0L && ((NumericValue)subscriptValue).longValue() <= Integer.MAX_VALUE);
            return innerMostArray.getValueAt((int)((NumericValue)subscriptValue).longValue());
        }
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JArrayLengthExpression pJArrayLengthExpression) {
        JExpression arrayId = pJArrayLengthExpression.getQualifier();
        Value array = arrayId.accept(this);
        if (!array.isExplicitlyKnown()) {
            return Value.UnknownValue.getInstance();
        }
        assert (array instanceof ArrayValue);
        return new NumericValue(((ArrayValue)array).getArraySize());
    }

    @Override
    public Value visit(JEnumConstantExpression pJEnumConstantExpression) {
        String fullName = pJEnumConstantExpression.getConstantName();
        return new EnumConstantValue(fullName);
    }

    @Override
    public Value visit(JCastExpression pJCastExpression) {
        JExpression operand = pJCastExpression.getOperand();
        JType castType = pJCastExpression.getCastType();
        return AbstractExpressionValueVisitor.castJValue(operand.accept(this), operand.getExpressionType(), castType, this.logger, pJCastExpression.getFileLocation());
    }

    @Override
    public Value visit(JMethodInvocationExpression pAFunctionCallExpression) {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JClassInstanceCreation pJClassInstanceCreation) {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JStringLiteralExpression pPaStringLiteralExpression) {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JFloatLiteralExpression pJBooleanLiteralExpression) {
        return new NumericValue(pJBooleanLiteralExpression.getValue());
    }

    @Override
    public Value visit(JArrayCreationExpression pJArrayCreationExpression) {
        Value currentArrayValue = null;
        int currentDimension = 0;
        JType elementType = pJArrayCreationExpression.getExpressionType().getElementType();
        for (JExpression sizeExpression : Lists.reverse(pJArrayCreationExpression.getLength())) {
            ++currentDimension;
            Value.UnknownValue lastArrayValue = currentArrayValue;
            Value sizeValue = sizeExpression.accept(this);
            if (sizeValue.isUnknown()) {
                currentArrayValue = Value.UnknownValue.getInstance();
                continue;
            }
            long concreteArraySize = ((NumericValue)sizeValue).longValue();
            currentArrayValue = this.createArrayValue(new JArrayType(elementType, currentDimension), concreteArraySize);
            if (lastArrayValue == null) continue;
            Value newValue = lastArrayValue;
            int index = 0;
            while ((long)index < concreteArraySize) {
                ((ArrayValue)currentArrayValue).setValue(newValue, index);
                if (lastArrayValue instanceof ArrayValue) {
                    newValue = ArrayValue.copyOf((ArrayValue)((Object)lastArrayValue));
                }
                ++index;
            }
        }
        return currentArrayValue;
    }

    private ArrayValue createArrayValue(JArrayType pType, long pArraySize) {
        if (pArraySize < 0L || pArraySize > Integer.MAX_VALUE) {
            throw new AssertionError((Object)("Trying to create array of size " + pArraySize + ". Java arrays can't be smaller than 0 or bigger than the max int value."));
        }
        return new ArrayValue(pType, (int)pArraySize);
    }

    @Override
    public Value visit(JArrayInitializer pJArrayInitializer) {
        JArrayType arrayType = pJArrayInitializer.getExpressionType();
        List<JExpression> initializerExpressions = pJArrayInitializer.getInitializerExpressions();
        ArrayList<Value> slotValues = new ArrayList<Value>();
        for (JExpression currentExpression : initializerExpressions) {
            slotValues.add(currentExpression.accept(this));
        }
        return new ArrayValue(arrayType, slotValues);
    }

    @Override
    public Value visit(JVariableRunTimeType pJThisRunTimeType) {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JRunTimeTypeEqualsType pJRunTimeTypeEqualsType) {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JNullLiteralExpression pJNullLiteralExpression) {
        return NullValue.getInstance();
    }

    @Override
    public Value visit(JThisExpression pThisExpression) {
        return Value.UnknownValue.getInstance();
    }

    protected abstract Value evaluateCPointerExpression(CPointerExpression var1) throws UnrecognizedCodeException;

    protected abstract Value evaluateCIdExpression(CIdExpression var1) throws UnrecognizedCodeException;

    protected abstract Value evaluateJIdExpression(JIdExpression var1);

    protected abstract Value evaluateCFieldReference(CFieldReference var1) throws UnrecognizedCodeException;

    protected abstract Value evaluateCArraySubscriptExpression(CArraySubscriptExpression var1) throws UnrecognizedCodeException;

    public String getFunctionName() {
        return this.functionName;
    }

    protected MachineModel getMachineModel() {
        return this.machineModel;
    }

    protected LogManagerWithoutDuplicates getLogger() {
        return this.logger;
    }

    public Value evaluate(CRightHandSide pExp, CType pTargetType) throws UnrecognizedCodeException {
        return AbstractExpressionValueVisitor.castCValue(pExp.accept(this), pTargetType, this.machineModel, this.logger, pExp.getFileLocation());
    }

    public Value evaluate(JRightHandSide pExp, JType pTargetType) {
        return AbstractExpressionValueVisitor.castJValue(pExp.accept(this), (JType)pExp.getExpressionType(), pTargetType, this.logger, pExp.getFileLocation());
    }

    public static Value castCValue(@NonNull Value value, CType targetType, MachineModel machineModel, LogManagerWithoutDuplicates logger, FileLocation fileLocation) {
        int size;
        if (!value.isExplicitlyKnown()) {
            return AbstractExpressionValueVisitor.castIfSymbolic(value, targetType, Optional.of(machineModel));
        }
        if (!value.isNumericValue()) {
            logger.logf(Level.FINE, "Can not cast C value %s to %s", new Object[]{value.toString(), targetType.toString()});
            return value;
        }
        NumericValue numericValue = (NumericValue)value;
        CType type = targetType.getCanonicalType();
        if (type instanceof CSimpleType) {
            CSimpleType st = (CSimpleType)type;
            size = machineModel.getSizeofInBits(st);
        } else if (type instanceof CBitFieldType) {
            size = ((CBitFieldType)type).getBitFieldSize();
            type = ((CBitFieldType)type).getType();
        } else {
            return value;
        }
        return AbstractExpressionValueVisitor.castNumeric(numericValue, type, machineModel, size);
    }

    private static Value castNumeric(@NonNull NumericValue numericValue, CType type, MachineModel machineModel, int size) {
        if (!(type instanceof CSimpleType)) {
            return numericValue;
        }
        CSimpleType st = (CSimpleType)type;
        switch (st.getType()) {
            case BOOL: {
                return AbstractExpressionValueVisitor.convertToBool(numericValue);
            }
            case INT: 
            case INT128: 
            case CHAR: {
                BigInteger signedLowerBound;
                BigInteger signedUpperBound;
                if (AbstractExpressionValueVisitor.isNan(numericValue)) {
                    return Value.UnknownValue.getInstance();
                }
                if ((numericValue.getNumber() instanceof Float || numericValue.getNumber() instanceof Double) && Math.abs(numericValue.doubleValue() - (double)numericValue.longValue()) >= 1.0) {
                    return Value.UnknownValue.getInstance();
                }
                BigInteger valueToCastAsInt = numericValue.getNumber() instanceof BigInteger ? numericValue.bigInteger() : (numericValue.getNumber() instanceof BigDecimal ? numericValue.bigDecimalValue().toBigInteger() : BigInteger.valueOf(numericValue.longValue()));
                boolean targetIsSigned = machineModel.isSigned(st);
                BigInteger maxValue = BigInteger.ONE.shiftLeft(size);
                BigInteger result = valueToCastAsInt.remainder(maxValue);
                if (targetIsSigned) {
                    signedUpperBound = maxValue.divide(BigInteger.valueOf(2L)).subtract(BigInteger.ONE);
                    signedLowerBound = maxValue.divide(BigInteger.valueOf(2L)).negate();
                } else {
                    signedUpperBound = maxValue.subtract(BigInteger.ONE);
                    signedLowerBound = BigInteger.ZERO;
                }
                if (AbstractExpressionValueVisitor.isGreaterThan(result, signedUpperBound)) {
                    result = result.subtract(maxValue);
                } else if (AbstractExpressionValueVisitor.isLessThan(result, signedLowerBound)) {
                    result = result.add(maxValue);
                }
                if (size < 64 || size == 64 && targetIsSigned) {
                    return new NumericValue(result.longValueExact());
                }
                return new NumericValue(result);
            }
            case DOUBLE: 
            case FLOAT: 
            case FLOAT128: {
                Value result;
                int bitPerByte = machineModel.getSizeofCharInBits();
                if (AbstractExpressionValueVisitor.isNan(numericValue) || AbstractExpressionValueVisitor.isInfinity(numericValue)) {
                    result = numericValue;
                } else if (size == 32) {
                    result = new NumericValue(Float.valueOf(numericValue.floatValue()));
                } else if (size == 64) {
                    result = new NumericValue(numericValue.doubleValue());
                } else if (size == machineModel.getSizeofFloat128() * 8) {
                    result = new NumericValue(numericValue.bigDecimalValue());
                } else if (size == machineModel.getSizeofLongDouble() * bitPerByte) {
                    result = numericValue.bigDecimalValue().doubleValue() == numericValue.doubleValue() ? new NumericValue(numericValue.doubleValue()) : (numericValue.bigDecimalValue().floatValue() == numericValue.floatValue() ? new NumericValue(Float.valueOf(numericValue.floatValue())) : Value.UnknownValue.getInstance());
                } else {
                    throw new AssertionError((Object)("Unhandled floating point type: " + type));
                }
                return result;
            }
        }
        throw new AssertionError((Object)("Unhandled type: " + type));
    }

    private static Value convertToBool(NumericValue pValue) {
        Number n = pValue.getNumber();
        if (AbstractExpressionValueVisitor.isBooleanFalseRepresentation(n)) {
            return new NumericValue(0);
        }
        return new NumericValue(1);
    }

    private static boolean isBooleanFalseRepresentation(Number n) {
        return (n instanceof Float || n instanceof Double) && 0.0 == n.doubleValue() || n instanceof BigInteger && BigInteger.ZERO.equals(n) || n instanceof BigDecimal && ((BigDecimal)n).compareTo(BigDecimal.ZERO) == 0 || 0L == n.longValue();
    }

    private static boolean isNan(NumericValue pValue) {
        Number n = pValue.getNumber();
        return n.equals(Float.valueOf(Float.NaN)) || n.equals(Double.NaN) || NumericValue.NegativeNaN.VALUE.equals(n);
    }

    private static boolean isInfinity(NumericValue pValue) {
        Number n = pValue.getNumber();
        return n.equals(Double.POSITIVE_INFINITY) || n.equals(Double.NEGATIVE_INFINITY) || n.equals(Float.valueOf(Float.POSITIVE_INFINITY)) || n.equals(Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    private static boolean isGreaterThan(BigInteger i1, BigInteger i2) {
        return i1.compareTo(i2) > 0;
    }

    private static boolean isLessThan(BigInteger i1, BigInteger i2) {
        return i1.compareTo(i2) < 0;
    }

    private static Value castIfSymbolic(Value pValue, Type pTargetType, Optional<MachineModel> pMachineModel) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        if (pValue instanceof SymbolicValue && (pTargetType instanceof JSimpleType || pTargetType instanceof CSimpleType)) {
            return factory.cast((SymbolicValue)pValue, pTargetType, pMachineModel);
        }
        return pValue;
    }

    public static Value castJValue(@NonNull Value value, JType sourceType, JType targetType, LogManagerWithoutDuplicates logger, FileLocation fileLocation) {
        if (!value.isExplicitlyKnown()) {
            return AbstractExpressionValueVisitor.castIfSymbolic(value, targetType, Optional.empty());
        }
        if (!value.isNumericValue()) {
            logger.logf(Level.FINE, "Can not cast Java value %s to %s", new Object[]{value.toString(), targetType.toString()});
            return value;
        }
        NumericValue numericValue = (NumericValue)value;
        if (targetType instanceof JSimpleType) {
            JSimpleType st = (JSimpleType)targetType;
            if (AbstractExpressionValueVisitor.isIntegerType(sourceType)) {
                long longValue = numericValue.longValue();
                return AbstractExpressionValueVisitor.createValue(longValue, st.getType());
            }
            if (AbstractExpressionValueVisitor.isFloatType(sourceType)) {
                double doubleValue = numericValue.doubleValue();
                return AbstractExpressionValueVisitor.createValue(doubleValue, st.getType());
            }
            throw new AssertionError((Object)("Cast from " + sourceType + " to " + targetType + " not possible."));
        }
        return value;
    }

    private static Value createValue(long value, JBasicType targetType) {
        switch (targetType) {
            case BYTE: {
                return new NumericValue((byte)value);
            }
            case CHAR: {
                char castedValue = (char)value;
                return new NumericValue((int)castedValue);
            }
            case SHORT: {
                return new NumericValue((short)value);
            }
            case INT: {
                return new NumericValue((int)value);
            }
            case LONG: {
                return new NumericValue(value);
            }
            case FLOAT: {
                return new NumericValue(Float.valueOf(value));
            }
            case DOUBLE: {
                return new NumericValue(value);
            }
        }
        throw new AssertionError((Object)("Trying to cast to unsupported type " + targetType));
    }

    private static Value createValue(double value, JBasicType targetType) {
        switch (targetType) {
            case BYTE: {
                return new NumericValue((byte)value);
            }
            case CHAR: 
            case SHORT: {
                return new NumericValue((short)value);
            }
            case INT: {
                return new NumericValue((int)value);
            }
            case LONG: {
                return new NumericValue(value);
            }
            case FLOAT: {
                return new NumericValue(Float.valueOf((float)value));
            }
            case DOUBLE: {
                return new NumericValue(value);
            }
        }
        throw new AssertionError((Object)("Trying to cast to unsupported type " + targetType));
    }

    public static CSimpleType getArithmeticType(CType type) {
        if ((type = type.getCanonicalType()) instanceof CPointerType) {
            return CNumericTypes.INT;
        }
        if (type instanceof CSimpleType) {
            return (CSimpleType)type;
        }
        return null;
    }

    protected static class IllegalOperationException
    extends CPAException {
        private static final long serialVersionUID = 5420891133452817345L;

        public IllegalOperationException(String msg) {
            super(msg);
        }

        public IllegalOperationException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

