/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Collection;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.FunctionPointerExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.type.BooleanValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

class AssigningValueVisitor
extends ExpressionValueVisitor {
    private ExpressionValueVisitor nonAssigningValueVisitor;
    private ValueAnalysisState assignableState;
    private Collection<String> booleans;
    protected boolean truthValue = false;
    private final ValueAnalysisTransferRelation.ValueTransferOptions options;

    public AssigningValueVisitor(ValueAnalysisState assignableState, boolean truthValue, Collection<String> booleanVariables, String functionName, ValueAnalysisState state, MachineModel machineModel, LogManagerWithoutDuplicates logger, ValueAnalysisTransferRelation.ValueTransferOptions options) {
        super(state, functionName, machineModel, logger);
        this.nonAssigningValueVisitor = new ExpressionValueVisitor(state, functionName, machineModel, logger);
        this.assignableState = assignableState;
        this.booleans = booleanVariables;
        this.truthValue = truthValue;
        this.options = options;
    }

    private static AExpression unwrap(AExpression expression) {
        while (expression instanceof CCastExpression) {
            expression = ((CCastExpression)expression).getOperand();
        }
        return expression;
    }

    @Override
    public Value visit(CBinaryExpression pE) throws UnrecognizedCodeException {
        CBinaryExpression.BinaryOperator binaryOperator = pE.getOperator();
        CExpression lVarInBinaryExp = (CExpression)AssigningValueVisitor.unwrap(pE.getOperand1());
        CExpression rVarInBinaryExp = pE.getOperand2();
        Value leftValue = lVarInBinaryExp.accept(this.nonAssigningValueVisitor);
        Value rightValue = rVarInBinaryExp.accept(this.nonAssigningValueVisitor);
        if (this.isEqualityAssumption(binaryOperator)) {
            Number rNum;
            if (leftValue.isExplicitlyKnown()) {
                Number lNum = leftValue.asNumericValue().getNumber();
                if (BigInteger.ONE.equals(lNum)) {
                    rVarInBinaryExp.accept(this);
                }
            } else if (rightValue.isExplicitlyKnown() && BigInteger.ONE.equals(rNum = rightValue.asNumericValue().getNumber())) {
                lVarInBinaryExp.accept(this);
            }
            if (this.isEligibleForAssignment(leftValue) && rightValue.isExplicitlyKnown() && this.isAssignable(lVarInBinaryExp)) {
                this.assignConcreteValue(lVarInBinaryExp, leftValue, rightValue, pE.getOperand2().getExpressionType());
            } else if (this.isEligibleForAssignment(rightValue) && leftValue.isExplicitlyKnown() && this.isAssignable(rVarInBinaryExp)) {
                this.assignConcreteValue(rVarInBinaryExp, rightValue, leftValue, pE.getOperand1().getExpressionType());
            }
        }
        if (this.isNonEqualityAssumption(binaryOperator)) {
            MemoryLocation rightMemLoc;
            if (AssigningValueVisitor.assumingUnknownToBeZero(leftValue, rightValue) && this.isAssignable(lVarInBinaryExp)) {
                MemoryLocation leftMemLoc = this.getMemoryLocation(lVarInBinaryExp);
                if (this.options.isOptimizeBooleanVariables() && (this.booleans.contains(leftMemLoc.getExtendedQualifiedName()) || this.options.isInitAssumptionVars())) {
                    this.assignableState.assignConstant(leftMemLoc, (Value)new NumericValue(1L), pE.getOperand1().getExpressionType());
                }
            } else if (this.options.isOptimizeBooleanVariables() && AssigningValueVisitor.assumingUnknownToBeZero(rightValue, leftValue) && this.isAssignable(rVarInBinaryExp) && (this.booleans.contains((rightMemLoc = this.getMemoryLocation(rVarInBinaryExp)).getExtendedQualifiedName()) || this.options.isInitAssumptionVars())) {
                this.assignableState.assignConstant(rightMemLoc, (Value)new NumericValue(1L), pE.getOperand2().getExpressionType());
            }
        }
        return this.nonAssigningValueVisitor.visit(pE);
    }

    private boolean isEligibleForAssignment(Value pValue) {
        return pValue.isUnknown() && this.options.isAssignEqualityAssumptions();
    }

    private void assignConcreteValue(CExpression pVarInBinaryExp, Value pOldValue, Value pNewValue, CType pValueType) throws UnrecognizedCodeException {
        Preconditions.checkState((!(pOldValue instanceof SymbolicValue) ? 1 : 0) != 0, (Object)"Symbolic values should never be replaced by a concrete value");
        this.assignableState.assignConstant(this.getMemoryLocation(pVarInBinaryExp), pNewValue, pValueType);
    }

    private static boolean assumingUnknownToBeZero(Value value1, Value value2) {
        return value1.isUnknown() && value2.equals(new NumericValue(BigInteger.ZERO));
    }

    private boolean isEqualityAssumption(CBinaryExpression.BinaryOperator binaryOperator) {
        return binaryOperator == CBinaryExpression.BinaryOperator.EQUALS && this.truthValue || binaryOperator == CBinaryExpression.BinaryOperator.NOT_EQUALS && !this.truthValue;
    }

    private boolean isNonEqualityAssumption(CBinaryExpression.BinaryOperator binaryOperator) {
        return binaryOperator == CBinaryExpression.BinaryOperator.EQUALS && !this.truthValue || binaryOperator == CBinaryExpression.BinaryOperator.NOT_EQUALS && this.truthValue;
    }

    @Override
    public Value visit(JBinaryExpression pE) {
        JBinaryExpression.BinaryOperator binaryOperator = pE.getOperator();
        JExpression lVarInBinaryExp = pE.getOperand1();
        lVarInBinaryExp = (JExpression)AssigningValueVisitor.unwrap(lVarInBinaryExp);
        JExpression rVarInBinaryExp = pE.getOperand2();
        Value leftValueV = lVarInBinaryExp.accept(this.nonAssigningValueVisitor);
        Value rightValueV = rVarInBinaryExp.accept(this.nonAssigningValueVisitor);
        if (binaryOperator == JBinaryExpression.BinaryOperator.EQUALS && this.truthValue || binaryOperator == JBinaryExpression.BinaryOperator.NOT_EQUALS && !this.truthValue) {
            if (leftValueV.isUnknown() && rightValueV.isExplicitlyKnown() && AssigningValueVisitor.isAssignableVariable(lVarInBinaryExp)) {
                this.assignValueToState((AIdExpression)((Object)lVarInBinaryExp), rightValueV);
            } else if (rightValueV.isUnknown() && leftValueV.isExplicitlyKnown() && AssigningValueVisitor.isAssignableVariable(rVarInBinaryExp)) {
                this.assignValueToState((AIdExpression)((Object)rVarInBinaryExp), leftValueV);
            }
        }
        if (this.options.isInitAssumptionVars() && (binaryOperator == JBinaryExpression.BinaryOperator.NOT_EQUALS && this.truthValue || binaryOperator == JBinaryExpression.BinaryOperator.EQUALS && !this.truthValue)) {
            if (leftValueV.isUnknown() && rightValueV.isExplicitlyKnown() && AssigningValueVisitor.isAssignableVariable(lVarInBinaryExp)) {
                assert (rightValueV instanceof BooleanValue);
                BooleanValue booleanValueRight = BooleanValue.valueOf(rightValueV).orElseThrow();
                if (!booleanValueRight.isTrue()) {
                    this.assignValueToState((AIdExpression)((Object)lVarInBinaryExp), BooleanValue.valueOf(true));
                }
            } else if (rightValueV.isUnknown() && leftValueV.isExplicitlyKnown() && AssigningValueVisitor.isAssignableVariable(rVarInBinaryExp)) {
                assert (leftValueV instanceof BooleanValue);
                BooleanValue booleanValueLeft = BooleanValue.valueOf(leftValueV).orElseThrow();
                if (!booleanValueLeft.isTrue()) {
                    this.assignValueToState((AIdExpression)((Object)rVarInBinaryExp), BooleanValue.valueOf(true));
                }
            }
        }
        return super.visit(pE);
    }

    private void assignValueToState(AIdExpression pIdExpression, Value pValue) {
        ASimpleDeclaration declaration = pIdExpression.getDeclaration();
        if (declaration != null) {
            this.assignableState.assignConstant(declaration.getQualifiedName(), pValue);
        } else {
            MemoryLocation memLoc = MemoryLocation.forLocalVariable(this.getFunctionName(), pIdExpression.getName());
            this.assignableState.assignConstant(memLoc, pValue, pIdExpression.getExpressionType());
        }
    }

    private MemoryLocation getMemoryLocation(CExpression pLValue) throws UnrecognizedCodeException {
        ExpressionValueVisitor v = this.getVisitor();
        assert (pLValue instanceof CLeftHandSide);
        return (MemoryLocation)Preconditions.checkNotNull((Object)v.evaluateMemoryLocation(pLValue));
    }

    private static boolean isAssignableVariable(JExpression expression) {
        if (expression instanceof JIdExpression) {
            JSimpleDeclaration decl = ((JIdExpression)expression).getDeclaration();
            if (decl == null) {
                return false;
            }
            if (decl instanceof JFieldDeclaration) {
                return ((JFieldDeclaration)decl).isStatic();
            }
            return true;
        }
        return false;
    }

    private boolean isAssignable(CExpression expression) throws UnrecognizedCodeException {
        if (expression instanceof CIdExpression) {
            return true;
        }
        if (expression instanceof CFieldReference || expression instanceof CArraySubscriptExpression) {
            ExpressionValueVisitor evv = this.getVisitor();
            return evv.canBeEvaluated(expression);
        }
        return false;
    }

    ExpressionValueVisitor getVisitor() {
        if (this.options.isIgnoreFunctionValue()) {
            return new ExpressionValueVisitor(this.getState(), this.getFunctionName(), this.getMachineModel(), this.getLogger());
        }
        return new FunctionPointerExpressionValueVisitor(this.getState(), this.getFunctionName(), this.getMachineModel(), this.getLogger());
    }
}

