/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import java.math.BigInteger;
import java.util.Objects;
import java.util.OptionalLong;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ExpressionValueVisitor
extends AbstractExpressionValueVisitor {
    private boolean missingPointer = false;
    protected final ValueAnalysisState readableState;

    public ExpressionValueVisitor(ValueAnalysisState pState, String pFunctionName, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger) {
        super(pFunctionName, pMachineModel, pLogger);
        this.readableState = pState;
    }

    @Override
    public void reset() {
        super.reset();
        this.missingPointer = false;
    }

    public boolean hasMissingPointer() {
        return this.missingPointer;
    }

    @Override
    protected Value evaluateCIdExpression(CIdExpression varName) {
        return this.evaluateAIdExpression(varName);
    }

    @Override
    protected Value evaluateJIdExpression(JIdExpression varName) {
        return this.evaluateAIdExpression(varName);
    }

    private Value evaluateAIdExpression(AIdExpression varName) {
        MemoryLocation memLoc = varName.getDeclaration() != null ? MemoryLocation.forDeclaration(varName.getDeclaration()) : (!ForwardingTransferRelation.isGlobal(varName) ? MemoryLocation.forLocalVariable(this.getFunctionName(), varName.getName()) : MemoryLocation.forIdentifier(varName.getName()));
        if (this.readableState.contains(memLoc)) {
            return this.readableState.getValueFor(memLoc);
        }
        return Value.UnknownValue.getInstance();
    }

    private Value evaluateLValue(CLeftHandSide pLValue) throws UnrecognizedCodeException {
        MemoryLocation varLoc = this.evaluateMemoryLocation(pLValue);
        if (varLoc == null) {
            return Value.UnknownValue.getInstance();
        }
        if (this.readableState.contains(varLoc)) {
            ValueAnalysisState.ValueAndType valueAndType = this.readableState.getValueAndTypeFor(varLoc);
            CType actualType = (CType)valueAndType.getType();
            CType readType = pLValue.getExpressionType();
            MachineModel machineModel = this.getMachineModel();
            if (Objects.equals(machineModel.getSizeof(readType), machineModel.getSizeof(actualType))) {
                if (this.doesRequireUnionFloatConversion(actualType, readType)) {
                    if (valueAndType.getValue().isNumericValue()) {
                        if (this.isFloatingPointType(actualType.getCanonicalType())) {
                            return this.extractFloatingPointValueAsIntegralValue(actualType.getCanonicalType(), valueAndType);
                        }
                        if (this.isFloatingPointType(readType.getCanonicalType())) {
                            return this.extractIntegralValueAsFloatingPointValue(readType.getCanonicalType(), valueAndType);
                        }
                    }
                    return Value.UnknownValue.getInstance();
                }
                return valueAndType.getValue();
            }
        }
        return Value.UnknownValue.getInstance();
    }

    private Value extractFloatingPointValueAsIntegralValue(CType pActualType, ValueAnalysisState.ValueAndType pValueAndType) {
        if (pActualType instanceof CSimpleType) {
            CBasicType basicType = ((CSimpleType)pActualType.getCanonicalType()).getType();
            NumericValue numericValue = pValueAndType.getValue().asNumericValue();
            if (basicType.equals((Object)CBasicType.FLOAT)) {
                float floatValue = numericValue.floatValue();
                int intBits = Float.floatToIntBits(floatValue);
                return new NumericValue(intBits);
            }
            if (basicType.equals((Object)CBasicType.DOUBLE)) {
                double doubleValue = numericValue.doubleValue();
                long longBits = Double.doubleToLongBits(doubleValue);
                return new NumericValue(longBits);
            }
        }
        return Value.UnknownValue.getInstance();
    }

    private Value extractIntegralValueAsFloatingPointValue(CType pReadType, ValueAnalysisState.ValueAndType pValueAndType) {
        if (pReadType instanceof CSimpleType) {
            CBasicType basicReadType = ((CSimpleType)pReadType.getCanonicalType()).getType();
            NumericValue numericValue = pValueAndType.getValue().asNumericValue();
            if (basicReadType.equals((Object)CBasicType.FLOAT)) {
                int bits = numericValue.bigInteger().intValue();
                float floatValue = Float.intBitsToFloat(bits);
                return new NumericValue(Float.valueOf(floatValue));
            }
            if (basicReadType.equals((Object)CBasicType.DOUBLE)) {
                long bits = numericValue.bigInteger().longValue();
                double doubleValue = Double.longBitsToDouble(bits);
                return new NumericValue(doubleValue);
            }
        }
        return Value.UnknownValue.getInstance();
    }

    private boolean doesRequireUnionFloatConversion(CType pSourceType, CType pTargetType) {
        CType sourceType = pSourceType.getCanonicalType();
        CType targetType = pTargetType.getCanonicalType();
        if (sourceType instanceof CSimpleType && targetType instanceof CSimpleType) {
            return this.isFloatingPointType(sourceType) != this.isFloatingPointType(targetType);
        }
        return false;
    }

    private boolean isFloatingPointType(CType pType) {
        if (pType instanceof CSimpleType) {
            return ((CSimpleType)pType).getType().isFloatingPointType();
        }
        return false;
    }

    @Override
    protected Value evaluateCFieldReference(CFieldReference pLValue) throws UnrecognizedCodeException {
        return this.evaluateLValue(pLValue);
    }

    @Override
    protected Value evaluateCArraySubscriptExpression(CArraySubscriptExpression pLValue) throws UnrecognizedCodeException {
        return this.evaluateLValue(pLValue);
    }

    @Override
    protected Value evaluateCPointerExpression(CPointerExpression pVarName) {
        this.missingPointer = true;
        return Value.UnknownValue.getInstance();
    }

    public boolean canBeEvaluated(CExpression lValue) throws UnrecognizedCodeException {
        return this.evaluateMemoryLocation(lValue) != null;
    }

    public MemoryLocation evaluateMemoryLocation(CExpression lValue) throws UnrecognizedCodeException {
        return lValue.accept(new MemoryLocationEvaluator(this));
    }

    public @Nullable MemoryLocation evaluateRelativeMemLocForStructMember(MemoryLocation pStartLocation, String pMemberName, CCompositeType pStructType) throws UnrecognizedCodeException {
        MemoryLocationEvaluator locationEvaluator = new MemoryLocationEvaluator(this);
        return locationEvaluator.getStructureFieldLocationFromRelativePoint(pStartLocation, pMemberName, pStructType);
    }

    public MemoryLocation evaluateMemLocForArraySlot(MemoryLocation pArrayStartLocation, int pSlotNumber, CArrayType pArrayType) {
        MemoryLocationEvaluator locationEvaluator = new MemoryLocationEvaluator(this);
        return locationEvaluator.getArraySlotLocationFromArrayStart(pArrayStartLocation, pSlotNumber, pArrayType);
    }

    @Override
    public Value visit(JClassLiteralExpression pJClassLiteralExpression) throws NoException {
        return Value.UnknownValue.getInstance();
    }

    public ValueAnalysisState getState() {
        return this.readableState;
    }

    protected static class MemoryLocationEvaluator
    extends DefaultCExpressionVisitor<MemoryLocation, UnrecognizedCodeException> {
        private final ExpressionValueVisitor evv;

        public MemoryLocationEvaluator(ExpressionValueVisitor pEvv) {
            this.evv = pEvv;
        }

        @Override
        protected MemoryLocation visitDefault(CExpression pExp) {
            return null;
        }

        @Override
        public MemoryLocation visit(CArraySubscriptExpression pIastArraySubscriptExpression) throws UnrecognizedCodeException {
            CExpression arrayExpression = pIastArraySubscriptExpression.getArrayExpression();
            CType arrayExpressionType = arrayExpression.getExpressionType().getCanonicalType();
            if (arrayExpressionType instanceof CPointerType) {
                this.evv.missingPointer = true;
                return null;
            }
            CExpression subscript = pIastArraySubscriptExpression.getSubscriptExpression();
            CType elementType = pIastArraySubscriptExpression.getExpressionType();
            MemoryLocation arrayLoc = arrayExpression.accept(this);
            if (arrayLoc == null) {
                return null;
            }
            Value subscriptValue = subscript.accept(this.evv);
            if (!subscriptValue.isExplicitlyKnown() || !subscriptValue.isNumericValue()) {
                return null;
            }
            long typeSize = this.evv.getMachineModel().getSizeof(elementType).longValueExact();
            long subscriptOffset = subscriptValue.asNumericValue().longValue() * typeSize;
            return arrayLoc.withAddedOffset(subscriptOffset);
        }

        @Override
        public MemoryLocation visit(CFieldReference pIastFieldReference) throws UnrecognizedCodeException {
            if (pIastFieldReference.isPointerDereference()) {
                this.evv.missingPointer = true;
                return null;
            }
            CLeftHandSide fieldOwner = (CLeftHandSide)pIastFieldReference.getFieldOwner();
            MemoryLocation memLocOfFieldOwner = fieldOwner.accept(this);
            if (memLocOfFieldOwner == null) {
                return null;
            }
            return this.getStructureFieldLocationFromRelativePoint(memLocOfFieldOwner, pIastFieldReference.getFieldName(), fieldOwner.getExpressionType());
        }

        protected @Nullable MemoryLocation getStructureFieldLocationFromRelativePoint(MemoryLocation pStartLocation, String pFieldName, CType pOwnerType) throws UnrecognizedCodeException {
            CType canonicalOwnerType = pOwnerType.getCanonicalType();
            OptionalLong offset = this.getFieldOffsetInBits(canonicalOwnerType, pFieldName);
            if (!offset.isPresent()) {
                return null;
            }
            return pStartLocation.withAddedOffset(offset.orElseThrow());
        }

        private OptionalLong getFieldOffsetInBits(CType ownerType, String fieldName) throws UnrecognizedCodeException {
            if (ownerType instanceof CElaboratedType) {
                return this.getFieldOffsetInBits(((CElaboratedType)ownerType).getRealType(), fieldName);
            }
            if (ownerType instanceof CCompositeType) {
                return this.bitsToByte(this.evv.getMachineModel().getFieldOffsetInBits((CCompositeType)ownerType, fieldName));
            }
            if (ownerType instanceof CPointerType) {
                this.evv.missingPointer = true;
                return OptionalLong.empty();
            }
            if (ownerType instanceof CProblemType) {
                return OptionalLong.empty();
            }
            throw new AssertionError();
        }

        private OptionalLong bitsToByte(BigInteger bits) {
            BigInteger charSizeInBits = BigInteger.valueOf(this.evv.getMachineModel().getSizeofCharInBits());
            BigInteger[] divAndRemainder = bits.divideAndRemainder(charSizeInBits);
            if (divAndRemainder[1].equals(BigInteger.ZERO)) {
                return OptionalLong.of(divAndRemainder[0].longValueExact());
            }
            return OptionalLong.empty();
        }

        protected MemoryLocation getArraySlotLocationFromArrayStart(MemoryLocation pArrayStartLocation, int pSlotNumber, CArrayType pArrayType) {
            long typeSize = this.evv.getMachineModel().getSizeof(pArrayType.getType()).longValueExact();
            long offset = typeSize * (long)pSlotNumber;
            return pArrayStartLocation.withAddedOffset(offset);
        }

        @Override
        public MemoryLocation visit(CIdExpression idExp) throws UnrecognizedCodeException {
            if (idExp.getDeclaration() != null) {
                return MemoryLocation.forDeclaration(idExp.getDeclaration());
            }
            boolean isGlobal = ForwardingTransferRelation.isGlobal((AExpression)idExp);
            if (isGlobal) {
                return MemoryLocation.forIdentifier(idExp.getName());
            }
            return MemoryLocation.forLocalVariable(this.evv.getFunctionName(), idExp.getName());
        }

        @Override
        public MemoryLocation visit(CPointerExpression pPointerExpression) throws UnrecognizedCodeException {
            this.evv.missingPointer = true;
            return null;
        }

        @Override
        public MemoryLocation visit(CCastExpression pE) throws UnrecognizedCodeException {
            return pE.getOperand().accept(this);
        }
    }
}

