/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

@RunWith(value=Parameterized.class)
public class ExpressionValueVisitorTest {
    @Parameterized.Parameter(value=0)
    public MachineModel machineModel;
    @Parameterized.Parameter(value=1)
    public boolean symbolicValues;
    private static final int MAX_CHAR = 256;
    private static final int MAX_SHORT = 65536;
    private static final long MAX_INT = 0x100000000L;
    private static final CSimpleType S_CHAR = CNumericTypes.SIGNED_CHAR;
    private static final CSimpleType U_CHAR = CNumericTypes.UNSIGNED_CHAR;
    private static final CSimpleType S_SHORT_INT = CNumericTypes.SHORT_INT;
    private static final CSimpleType U_SHORT_INT = CNumericTypes.UNSIGNED_SHORT_INT;
    private static final CSimpleType S_INT = CNumericTypes.INT;
    private static final CSimpleType U_INT = CNumericTypes.UNSIGNED_INT;
    private static final CSimpleType S_LONG_INT = CNumericTypes.LONG_INT;
    private static final CSimpleType U_LONG_INT = CNumericTypes.UNSIGNED_LONG_INT;
    private static final CSimpleType S_LONG_LONG_INT = CNumericTypes.LONG_LONG_INT;
    private static final CSimpleType U_LONG_LONG_INT = CNumericTypes.UNSIGNED_LONG_LONG_INT;
    private static final CSimpleType FLOAT = CNumericTypes.FLOAT;
    private static final CSimpleType DOUBLE = CNumericTypes.DOUBLE;
    private static final CSimpleType LONG_DOUBLE = CNumericTypes.LONG_DOUBLE;
    private LogManagerWithoutDuplicates logger;
    private ExpressionValueVisitor evv;

    @Parameterized.Parameters(name="{0}, symbolicValues={1}")
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (MachineModel model : MachineModel.values()) {
            result.add(new Object[]{model, false});
            result.add(new Object[]{model, true});
        }
        return result;
    }

    @Before
    public void init() {
        this.logger = new LogManagerWithoutDuplicates(LogManager.createTestLogManager());
        this.evv = new ExpressionValueVisitor(new ValueAnalysisState(this.machineModel), "dummy_function", this.machineModel, this.logger);
    }

    @Test
    public void checkSimpleCasts() throws Exception {
        int i;
        for (i = -128; i < 256; i += 50) {
            this.checkCast(i, i < 128 ? (long)i : (long)(-256 + i), (CType)S_CHAR);
            this.checkCast(i, i < 0 ? (long)(256 + i) : (long)i, (CType)U_CHAR);
        }
        for (i = 32768; i < 65536; i += 5000) {
            this.checkCast(i, i < 32768 ? (long)i : (long)(-65536 + i), (CType)S_SHORT_INT);
            this.checkCast(i, i < 0 ? (long)(65536 + i) : (long)i, (CType)U_SHORT_INT);
        }
        for (long i2 = 0x80000000L; i2 < 0x100000000L; i2 += 10000000L) {
            this.checkCast(i2, i2 < 0x80000000L ? i2 : -4294967296L + i2, (CType)S_INT);
            this.checkCast(i2, i2 < 0L ? 0x100000000L + i2 : i2, (CType)U_INT);
        }
    }

    @Test
    public void checkCastsDirect() throws Exception {
        this.checkCast(4L, 4L, (CType)S_CHAR);
        this.checkCast(-4L, -4L, (CType)S_CHAR);
        this.checkCast(256L, 0L, (CType)S_CHAR);
        this.checkCast(260L, 4L, (CType)S_CHAR);
        this.checkCast(127L, 127L, (CType)S_CHAR);
        this.checkCast(128L, -128L, (CType)S_CHAR);
        this.checkCast(-127L, -127L, (CType)S_CHAR);
        this.checkCast(-128L, -128L, (CType)S_CHAR);
        this.checkCast(1050L, 26L, (CType)S_CHAR);
        this.checkCast(-1050L, -26L, (CType)S_CHAR);
        this.checkCast(4L, 4L, (CType)U_CHAR);
        this.checkCast(-4L, 252L, (CType)U_CHAR);
        this.checkCast(256L, 0L, (CType)U_CHAR);
        this.checkCast(260L, 4L, (CType)U_CHAR);
        this.checkCast(127L, 127L, (CType)U_CHAR);
        this.checkCast(-128L, 128L, (CType)U_CHAR);
        this.checkCast(-127L, 129L, (CType)U_CHAR);
        this.checkCast(-1L, 255L, (CType)U_CHAR);
        this.checkCast(1050L, 26L, (CType)U_CHAR);
        this.checkCast(-1050L, 230L, (CType)U_CHAR);
        this.checkCast(4L, 4L, (CType)S_INT);
        this.checkCast(-4L, -4L, (CType)S_INT);
        this.checkCast(0x100000000L, 0L, (CType)S_INT);
        this.checkCast(0x100000004L, 4L, (CType)S_INT);
        this.checkCast(Integer.MAX_VALUE, (long)Integer.MAX_VALUE, (CType)S_INT);
        this.checkCast(Integer.MIN_VALUE, (long)Integer.MIN_VALUE, (CType)S_INT);
        this.checkCast(0x80000000L, (long)Integer.MIN_VALUE, (CType)S_INT);
        this.checkCast(-2147483649L, (long)Integer.MAX_VALUE, (CType)S_INT);
        this.checkCast(0x80000001L, -2147483647L, (CType)S_INT);
        this.checkCast(4L, 4L, (CType)U_INT);
        this.checkCast(-4L, 0xFFFFFFFCL, (CType)U_INT);
        this.checkCast(0x100000000L, 0L, (CType)U_INT);
        this.checkCast(0x100000004L, 4L, (CType)U_INT);
        this.checkCast(Integer.MAX_VALUE, (long)Integer.MAX_VALUE, (CType)U_INT);
        this.checkCast(0x80000001L, 0x80000001L, (CType)U_INT);
        this.checkCast(Integer.MIN_VALUE, 0x80000000L, (CType)U_INT);
        this.checkCast(-2147483649L, (long)Integer.MAX_VALUE, (CType)U_INT);
        this.checkCast(-1L, 0xFFFFFFFFL, (CType)U_INT);
    }

    @Test
    public void checkIntegerCasts32() throws Exception {
        TruthJUnit.assume().that((Comparable)((Object)this.machineModel)).isSameInstanceAs((Object)MachineModel.LINUX32);
        for (long i = Integer.MIN_VALUE; i < 0x100000000L; i += 10000000L) {
            this.checkCast(i, i < 0x80000000L ? i : -4294967296L + i, (CType)S_INT);
            this.checkCast(i, i < 0L ? 0x100000000L + i : i, (CType)U_INT);
            this.checkCast(i, i < 0x80000000L ? i : -4294967296L + i, (CType)S_LONG_INT);
            this.checkCast(i, i < 0L ? 0x100000000L + i : i, (CType)U_LONG_INT);
            this.checkCast(i, i, (CType)S_LONG_LONG_INT);
            this.checkCast(i, i, (CType)U_LONG_LONG_INT);
        }
        for (CType t : ImmutableList.of((Object)S_INT, (Object)S_LONG_INT)) {
            this.checkCast(4L, 4L, t);
            this.checkCast(-4L, -4L, t);
            this.checkCast(0x100000000L, 0L, t);
            this.checkCast(0x100000004L, 4L, t);
            this.checkCast(Integer.MAX_VALUE, (long)Integer.MAX_VALUE, t);
            this.checkCast(Integer.MIN_VALUE, (long)Integer.MIN_VALUE, t);
            this.checkCast(0x80000000L, (long)Integer.MIN_VALUE, t);
            this.checkCast(-2147483649L, (long)Integer.MAX_VALUE, t);
            this.checkCast(0x80000001L, -2147483647L, t);
        }
        for (CType t : ImmutableList.of((Object)U_INT, (Object)U_LONG_INT)) {
            this.checkCast(4L, 4L, t);
            this.checkCast(-4L, 0xFFFFFFFCL, t);
            this.checkCast(0x100000000L, 0L, t);
            this.checkCast(0x100000004L, 4L, t);
            this.checkCast(Integer.MAX_VALUE, (long)Integer.MAX_VALUE, t);
            this.checkCast(0x80000001L, 0x80000001L, t);
            this.checkCast(Integer.MIN_VALUE, 0x80000000L, t);
            this.checkCast(-2147483649L, (long)Integer.MAX_VALUE, t);
            this.checkCast(-1L, 0xFFFFFFFFL, t);
        }
    }

    @Test
    public void checkIntegerCasts64() throws Exception {
        TruthJUnit.assume().that((Comparable)((Object)this.machineModel)).isSameInstanceAs((Object)MachineModel.LINUX64);
        for (long i = Integer.MIN_VALUE; i < 0x100000000L; i += 10000000L) {
            this.checkCast(i, i < 0x80000000L ? i : -4294967296L + i, (CType)S_INT);
            this.checkCast(i, i < 0L ? 0x100000000L + i : i, (CType)U_INT);
            this.checkCast(i, i, (CType)S_LONG_INT);
            this.checkCast(i, i, (CType)U_LONG_INT);
            this.checkCast(i, i, (CType)S_LONG_LONG_INT);
            this.checkCast(i, i, (CType)U_LONG_LONG_INT);
        }
        this.checkCast(4L, 4L, (CType)S_INT);
        this.checkCast(-4L, -4L, (CType)S_INT);
        this.checkCast(0x100000000L, 0L, (CType)S_INT);
        this.checkCast(0x100000004L, 4L, (CType)S_INT);
        this.checkCast(Integer.MAX_VALUE, (long)Integer.MAX_VALUE, (CType)S_INT);
        this.checkCast(Integer.MIN_VALUE, (long)Integer.MIN_VALUE, (CType)S_INT);
        this.checkCast(0x80000000L, (long)Integer.MIN_VALUE, (CType)S_INT);
        this.checkCast(-2147483649L, (long)Integer.MAX_VALUE, (CType)S_INT);
        this.checkCast(0x80000001L, -2147483647L, (CType)S_INT);
        this.checkCast(4L, 4L, (CType)U_INT);
        this.checkCast(-4L, 0xFFFFFFFCL, (CType)U_INT);
        this.checkCast(0x100000000L, 0L, (CType)U_INT);
        this.checkCast(0x100000004L, 4L, (CType)U_INT);
        this.checkCast(Integer.MAX_VALUE, (long)Integer.MAX_VALUE, (CType)U_INT);
        this.checkCast(0x80000001L, 0x80000001L, (CType)U_INT);
        this.checkCast(Integer.MIN_VALUE, 0x80000000L, (CType)U_INT);
        this.checkCast(-2147483649L, (long)Integer.MAX_VALUE, (CType)U_INT);
        this.checkCast(-1L, 0xFFFFFFFFL, (CType)U_INT);
        this.checkCast(4L, 4L, (CType)S_LONG_INT);
        this.checkCast(-4L, -4L, (CType)S_LONG_INT);
        this.checkCast(0x80000001L, 0x80000001L, (CType)S_LONG_INT);
        this.checkCast(-2147483649L, -2147483649L, (CType)S_LONG_INT);
        this.checkCast(0x100000000L, 0x100000000L, (CType)S_LONG_INT);
        this.checkCast(0x100000004L, 0x100000004L, (CType)S_LONG_INT);
        this.checkCast(Long.MAX_VALUE, Long.MAX_VALUE, (CType)S_LONG_INT);
        this.checkCast(Long.MIN_VALUE, Long.MIN_VALUE, (CType)S_LONG_INT);
        this.checkCast(4L, 4L, (CType)U_LONG_INT);
        this.checkCast(0x80000001L, 0x80000001L, (CType)U_LONG_INT);
        this.checkCast(0x100000004L, 0x100000004L, (CType)U_LONG_INT);
        this.checkCast(-2147483626L, -2147483626L, (CType)U_LONG_INT);
    }

    @Test
    public void checkFloatCasts32() {
        TruthJUnit.assume().that((Comparable)((Object)this.machineModel)).isSameInstanceAs((Object)MachineModel.LINUX32);
        this.performMachineModelAgnosticChecksForFloats();
    }

    @Test
    public void checkFloatCasts64() {
        TruthJUnit.assume().that((Comparable)((Object)this.machineModel)).isSameInstanceAs((Object)MachineModel.LINUX64);
        this.performMachineModelAgnosticChecksForFloats();
    }

    @Test
    public void checkFloatToIntCasts32() {
        TruthJUnit.assume().that((Comparable)((Object)this.machineModel)).isSameInstanceAs((Object)MachineModel.LINUX32);
        for (long i = -4294967296L; i < 0x100000000L; i += 10000000L) {
            double d = i < 0L ? (double)i - 0.5 : (double)i + 0.5;
            this.checkCast(d, i, (CType)S_LONG_LONG_INT);
        }
    }

    @Test
    public void checkFloatToIntCasts64() {
        TruthJUnit.assume().that((Comparable)((Object)this.machineModel)).isSameInstanceAs((Object)MachineModel.LINUX64);
        for (long i = -4294967296L; i < 0x100000000L; i += 10000000L) {
            double d = i < 0L ? (double)i - 0.5 : (double)i + 0.5;
            this.checkCast(d, i, (CType)S_LONG_INT);
            this.checkCast(d, i, (CType)S_LONG_LONG_INT);
        }
    }

    private void performMachineModelAgnosticChecksForFloats() {
        for (CType type : ImmutableList.of((Object)FLOAT, (Object)DOUBLE)) {
            for (Number n : ImmutableList.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(Float.POSITIVE_INFINITY))) {
                this.checkCast(((Float)n).floatValue(), ((Float)n).floatValue(), type);
            }
            for (Number n : ImmutableList.of((Object)0.0, (Object)Double.NaN, (Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY)) {
                this.checkCast(((Double)n).doubleValue(), ((Double)n).doubleValue(), type);
            }
        }
        this.checkCast(Double.NaN, Double.NaN, (CType)FLOAT);
        this.checkCast(Float.NaN, Double.NaN, (CType)DOUBLE);
        this.checkCast(0.0, 0.0, (CType)FLOAT);
        this.checkCast(Float.MAX_VALUE, Float.MAX_VALUE, (CType)DOUBLE);
        this.checkCast(Float.MIN_VALUE, Float.MIN_VALUE, (CType)DOUBLE);
        this.checkCast(Float.MAX_VALUE, Float.MAX_VALUE, (CType)LONG_DOUBLE);
        this.checkCast(Float.MIN_VALUE, Float.MIN_VALUE, (CType)LONG_DOUBLE);
        this.checkCast((double)Double.MAX_VALUE, (double)Double.MAX_VALUE, (CType)LONG_DOUBLE);
        this.checkCast((double)Double.MIN_VALUE, (double)Double.MIN_VALUE, (CType)LONG_DOUBLE);
    }

    private void checkCast(long in, long expectedOut, CType outType) throws UnrecognizedCodeException {
        Value value = this.evv.evaluate(new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, BigInteger.valueOf(in)), outType);
        Truth.assertThat((Long)value.asLong(CNumericTypes.INT)).isEqualTo((Object)expectedOut);
    }

    private void checkCast(double in, double expectedOut, CType outType) {
        NumericValue inValue = new NumericValue(in);
        Value value = AbstractExpressionValueVisitor.castCValue(inValue, outType, this.machineModel, this.logger, FileLocation.DUMMY);
        Truth.assertThat((Object)value).isInstanceOf(NumericValue.class);
        Truth.assertThat((Double)((NumericValue)value).doubleValue()).isEqualTo((Object)expectedOut);
    }

    private void checkCast(float in, double expectedOut, CType outType) {
        NumericValue inValue = new NumericValue(Float.valueOf(in));
        Value value = AbstractExpressionValueVisitor.castCValue(inValue, outType, this.machineModel, this.logger, FileLocation.DUMMY);
        Truth.assertThat((Object)value).isInstanceOf(NumericValue.class);
        Truth.assertThat((Double)((NumericValue)value).doubleValue()).isEqualTo((Object)expectedOut);
    }

    private void checkCast(float in, float expectedOut, CType outType) {
        NumericValue inValue = new NumericValue(Float.valueOf(in));
        Value value = AbstractExpressionValueVisitor.castCValue(inValue, outType, this.machineModel, this.logger, FileLocation.DUMMY);
        Truth.assertThat((Object)value).isInstanceOf(NumericValue.class);
        Truth.assertThat((Float)Float.valueOf(((NumericValue)value).floatValue())).isEqualTo((Object)Float.valueOf(expectedOut));
    }

    private void checkCast(double in, long expectedOut, CType outType) {
        NumericValue inValue = new NumericValue(in);
        Value value = AbstractExpressionValueVisitor.castCValue(inValue, outType, this.machineModel, this.logger, FileLocation.DUMMY);
        Truth.assertThat((Object)value).isInstanceOf(NumericValue.class);
        Truth.assertThat((Long)((NumericValue)value).longValue()).isEqualTo((Object)expectedOut);
    }
}

