/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class ExpressionValueVisitorWithPredefinedValues
extends ExpressionValueVisitor {
    public static final String PATERN_FOR_RANDOM = "__VERIFIER_nondet_";
    private AtomicInteger numReturnedValues;
    private LogManagerWithoutDuplicates logger;
    private Map<Integer, String> valuesFromFile = new HashMap<Integer, String>();
    private boolean lastRequestSuccessful = true;

    public ExpressionValueVisitorWithPredefinedValues(ValueAnalysisState pState, String pFunctionName, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger) {
        super(pState, pFunctionName, pMachineModel, pLogger);
        this.logger = pLogger;
    }

    public ExpressionValueVisitorWithPredefinedValues(ValueAnalysisState pState, String pFunctionName, AtomicInteger pAtomicInteger, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger, Map<Integer, String> pValuesFromFile) {
        super(pState, pFunctionName, pMachineModel, pLogger);
        this.logger = pLogger;
        this.numReturnedValues = pAtomicInteger;
        this.valuesFromFile = pValuesFromFile;
    }

    @Override
    public Value evaluate(CRightHandSide pExp, CType pTargetType) throws UnrecognizedCodeException {
        CFunctionCallExpression call;
        if (this.lastRequestSuccessful && pExp instanceof CFunctionCallExpression && (call = (CFunctionCallExpression)pExp).getFunctionNameExpression() instanceof CIdExpression && ((CIdExpression)call.getFunctionNameExpression()).getName().startsWith(PATERN_FOR_RANDOM)) {
            int counter = this.numReturnedValues.getAndIncrement();
            if (this.valuesFromFile.containsKey(counter)) {
                Value value = this.computeNumericalValue(call, this.valuesFromFile.get(counter));
                this.logger.log(Level.FINER, new Object[]{"Returning value at position %d, for statement " + pExp.toASTString() + " that is: ", value});
                return value;
            }
            this.lastRequestSuccessful = false;
        }
        return super.evaluate(pExp, pTargetType);
    }

    private Value computeNumericalValue(CFunctionCallExpression call, String pStringValueForNumber) {
        if (call.getExpressionType() instanceof CSimpleType) {
            return new NumericValue(Integer.parseInt(pStringValueForNumber));
        }
        this.logger.log(Level.WARNING, new Object[]{"Cannot parse complex types, hence returning unknown"});
        return new Value.UnknownValue();
    }
}

