/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.ARightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

class MissingInformation {
    private final CExpression missingCLeftMemoryLocation;
    private final MemoryLocation cLeftMemoryLocation;
    private final CExpression missingCExpressionInformation;
    private final Value cExpressionValue;
    private final Boolean truthAssumption;
    private CFunctionCallExpression missingFreeInvocation = null;

    public MissingInformation(CExpression pMissingCLeftMemoryLocation, CExpression pMissingCExpressionInformation) {
        this.missingCExpressionInformation = pMissingCExpressionInformation;
        this.missingCLeftMemoryLocation = pMissingCLeftMemoryLocation;
        this.cExpressionValue = null;
        this.cLeftMemoryLocation = null;
        this.truthAssumption = null;
    }

    public boolean hasUnknownValue() {
        return this.missingCExpressionInformation != null;
    }

    public boolean hasKnownValue() {
        return this.cExpressionValue != null;
    }

    public boolean hasUnknownMemoryLocation() {
        return this.missingCLeftMemoryLocation != null;
    }

    public boolean hasKnownMemoryLocation() {
        return this.cLeftMemoryLocation != null;
    }

    public boolean isMissingAssignment() {
        return (this.missingCExpressionInformation != null || this.missingCLeftMemoryLocation != null) && this.truthAssumption == null;
    }

    public boolean isMissingAssumption() {
        return this.truthAssumption != null && this.missingCExpressionInformation != null;
    }

    public MissingInformation(CExpression pMissingCLeftMemoryLocation, Value pCExpressionValue) {
        this.missingCExpressionInformation = null;
        this.missingCLeftMemoryLocation = pMissingCLeftMemoryLocation;
        this.cExpressionValue = pCExpressionValue;
        this.cLeftMemoryLocation = null;
        this.truthAssumption = null;
    }

    public MissingInformation(MemoryLocation pCLeftMemoryLocation, CExpression pMissingCExpressionInformation) {
        this.missingCExpressionInformation = pMissingCExpressionInformation;
        this.missingCLeftMemoryLocation = null;
        this.cExpressionValue = null;
        this.cLeftMemoryLocation = pCLeftMemoryLocation;
        this.truthAssumption = null;
    }

    public MissingInformation(AExpression pMissingCLeftMemoryLocation, ARightHandSide pMissingCExpressionInformation) {
        this.missingCExpressionInformation = (CExpression)pMissingCExpressionInformation;
        this.missingCLeftMemoryLocation = (CExpression)pMissingCLeftMemoryLocation;
        this.cExpressionValue = null;
        this.cLeftMemoryLocation = null;
        this.truthAssumption = null;
    }

    public MissingInformation(Boolean pTruthAssumption, ARightHandSide pMissingCExpressionInformation) {
        this.missingCExpressionInformation = (CExpression)pMissingCExpressionInformation;
        this.missingCLeftMemoryLocation = null;
        this.cExpressionValue = null;
        this.cLeftMemoryLocation = null;
        this.truthAssumption = pTruthAssumption;
    }

    public MissingInformation(CFunctionCallExpression pFunctionCallExpression) {
        this.missingFreeInvocation = pFunctionCallExpression;
        this.missingCExpressionInformation = null;
        this.missingCLeftMemoryLocation = null;
        this.cExpressionValue = null;
        this.cLeftMemoryLocation = null;
        this.truthAssumption = null;
    }

    public boolean isFreeInvocation() {
        return this.missingFreeInvocation != null;
    }

    public Value getcExpressionValue() {
        Preconditions.checkNotNull((Object)this.cExpressionValue);
        return this.cExpressionValue;
    }

    public MemoryLocation getcLeftMemoryLocation() {
        Preconditions.checkNotNull((Object)this.cLeftMemoryLocation);
        return this.cLeftMemoryLocation;
    }

    public CExpression getMissingCExpressionInformation() {
        Preconditions.checkNotNull((Object)this.missingCExpressionInformation);
        return this.missingCExpressionInformation;
    }

    public CExpression getMissingCLeftMemoryLocation() {
        Preconditions.checkNotNull((Object)this.missingCLeftMemoryLocation);
        return this.missingCLeftMemoryLocation;
    }

    public Boolean getTruthAssumption() {
        Preconditions.checkNotNull((Object)this.truthAssumption);
        return this.truthAssumption;
    }

    public CFunctionCallExpression getMissingFreeInvocation() {
        return this.missingFreeInvocation;
    }
}

