/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.DummyCFAEdge;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecisionBootstrapper;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateMapParser;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.dependencegraph.CSystemDependenceGraph;
import org.sosy_lab.cpachecker.util.dependencegraph.CSystemDependenceGraphBuilder;
import org.sosy_lab.cpachecker.util.dependencegraph.SystemDependenceGraph;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.regions.SymbolicRegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.resources.ResourceLimit;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;
import org.sosy_lab.cpachecker.util.resources.WalltimeLimit;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.java_smt.api.Formula;

@Options(prefix="cpa.value.reuse.precision.predicate")
public class PredicateToValuePrecisionConverter
implements Statistics {
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfa;
    private static final CFANode dummyNode = CFANode.newDummyCFANode();
    private final CFAEdge dummyEdge;
    @Option(secure=true, name="strategy", description="which strategy to use to convert predicate to value precision")
    private PredicateConverterStrategy converterStrategy = PredicateConverterStrategy.CONVERT_ONLY;
    @Option(secure=true, name="useControl", description="also consider control dependencies during adaption of predicate precision")
    private boolean considerControlDependence = false;
    @Option(secure=true, name="includeControlNonEquiv", description="also consider other binary operators then ==, !== when considering control dependencies while adapting predicate precision")
    private boolean nonEquivalenceInControl = false;
    @Option(secure=true, name="relevantProperties", description="comma-separated list of files with property specifications that should be considered when determining the relevant edges for predicate precision adaption")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<Path> relevantProperties = ImmutableList.of();
    @Option(secure=true, description="Overall timelimit for computing initial value precision from given predicate precision(use seconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.NANOSECONDS, defaultUserUnit=TimeUnit.SECONDS, min=0L)
    private TimeSpan adaptionLimit = TimeSpan.ofNanos((long)0L);
    private final Timer conversionTime = new Timer();
    private int numVarsAddedToPrecision = 0;

    public PredicateToValuePrecisionConverter(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        this.dummyEdge = new DummyCFAEdge(dummyNode, dummyNode);
        this.config.inject((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multimap<CFANode, MemoryLocation> convertPredPrecToVariableTrackingPrec(Path pPredPrecFile) throws InvalidConfigurationException {
        Multimap<CFANode, MemoryLocation> result;
        ResourceLimitChecker limitChecker;
        block26: {
            ShutdownNotifier conversionShutdownNotifier;
            limitChecker = null;
            if (!this.adaptionLimit.isEmpty()) {
                ShutdownManager conversionShutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
                conversionShutdownNotifier = conversionShutdownManager.getNotifier();
                WalltimeLimit limit = WalltimeLimit.fromNowOn(this.adaptionLimit);
                limitChecker = new ResourceLimitChecker(conversionShutdownManager, (List<ResourceLimit>)ImmutableList.of((Object)limit));
                limitChecker.start();
            } else {
                conversionShutdownNotifier = this.shutdownNotifier;
            }
            result = null;
            this.conversionTime.start();
            try (Solver solver = Solver.create(this.config, this.logger, conversionShutdownNotifier);){
                FormulaManagerView formulaManager = solver.getFormulaManager();
                SymbolicRegionManager regionManager = new SymbolicRegionManager(solver);
                AbstractionManager abstractionManager = new AbstractionManager(regionManager, this.config, this.logger, solver);
                PredicatePrecision predPrec = this.parsePredPrecFile(formulaManager, abstractionManager, pPredPrecFile);
                conversionShutdownNotifier.shutdownIfNecessary();
                if (!predPrec.isEmpty()) {
                    this.logger.log(Level.INFO, new Object[]{"Derive value precision from given predicate precision"});
                    result = this.convertPredPrecToVariableTrackingPrec(predPrec, formulaManager, dummyNode);
                    conversionShutdownNotifier.shutdownIfNecessary();
                    if (this.converterStrategy == PredicateConverterStrategy.CONVERT_ONLY) break block26;
                    try {
                        this.logger.log(Level.FINE, new Object[]{"Enhance value precision converted from predicate precision with additional relevant variables"});
                        Configuration depGraphConfig = Configuration.builder().copyFrom(this.config).setOption("dependencegraph.flowdeps.use", "true").setOption("dependencegraph.controldeps.use", this.considerControlDependence ? "true" : "false").build();
                        CSystemDependenceGraph depGraph = new CSystemDependenceGraphBuilder(this.cfa, depGraphConfig, this.logger, conversionShutdownNotifier).build();
                        conversionShutdownNotifier.shutdownIfNecessary();
                        Collection<CFAEdge> relevantEdges = this.determineEdgesRelevantForProperty(conversionShutdownNotifier);
                        conversionShutdownNotifier.shutdownIfNecessary();
                        ArrayDeque<MemoryLocation> toProcess = new ArrayDeque<MemoryLocation>(result.values());
                        HashSet<MemoryLocation> inspectedVars = new HashSet<MemoryLocation>(toProcess);
                        SystemDependenceGraph.BackwardsVisitOnceVisitor<CSystemDependenceGraph.Node> cdVisit = depGraph.createVisitOnceVisitor(new ControlDependenceVisitor(inspectedVars, toProcess, result));
                        while (!toProcess.isEmpty()) {
                            conversionShutdownNotifier.shutdownIfNecessary();
                            MemoryLocation var = (MemoryLocation)toProcess.pop();
                            Collection<CSystemDependenceGraph.Node> relevantGraphNodes = this.getRelevantGraphDefining(var, depGraph, relevantEdges);
                            for (CSystemDependenceGraph.Node relVarDef : relevantGraphNodes) {
                                conversionShutdownNotifier.shutdownIfNecessary();
                                for (MemoryLocation varDep : depGraph.getUses(relVarDef)) {
                                    PredicateToValuePrecisionConverter.registerRelevantVar(varDep, inspectedVars, toProcess, result);
                                }
                            }
                            conversionShutdownNotifier.shutdownIfNecessary();
                            if (this.considerControlDependence) {
                                cdVisit.reset();
                                depGraph.traverse(relevantGraphNodes, cdVisit);
                            }
                            conversionShutdownNotifier.shutdownIfNecessary();
                            if (this.converterStrategy != PredicateConverterStrategy.CONVERT_AND_ADD_FLOW_BIDIRECTED) continue;
                            relevantGraphNodes = this.getRelevantGraphUsing(var, depGraph, relevantEdges);
                            for (CSystemDependenceGraph.Node relVarUse : relevantGraphNodes) {
                                ImmutableSet defs = depGraph.getDefs(relVarUse);
                                if (defs.isEmpty()) continue;
                                boolean allUsesTracked = true;
                                boolean oneUseTracked = false;
                                for (MemoryLocation varDep : depGraph.getUses(relVarUse)) {
                                    if (inspectedVars.contains(varDep)) {
                                        oneUseTracked = true;
                                        continue;
                                    }
                                    if (defs.contains((Object)varDep)) continue;
                                    allUsesTracked = false;
                                    break;
                                }
                                conversionShutdownNotifier.shutdownIfNecessary();
                                if (!oneUseTracked || !allUsesTracked) continue;
                                for (MemoryLocation varDef : defs) {
                                    PredicateToValuePrecisionConverter.registerRelevantVar(varDef, inspectedVars, toProcess, result);
                                }
                            }
                        }
                        break block26;
                    }
                    catch (CPAException e) {
                        this.logger.logException(Level.WARNING, (Throwable)e, "Failed to add additional relevant variables");
                        break block26;
                    }
                }
                this.logger.log(Level.WARNING, new Object[]{"Provided predicate precision is empty and does not contain predicates."});
            }
            catch (InterruptedException e) {
                this.logger.logException(Level.INFO, (Throwable)e, "Precision adaption was interrupted.");
            }
            finally {
                this.conversionTime.stopIfRunning();
            }
        }
        if (limitChecker != null) {
            limitChecker.cancel();
        }
        if (result == null) {
            return ImmutableListMultimap.of();
        }
        this.numVarsAddedToPrecision += result.size();
        return ImmutableListMultimap.copyOf(result);
    }

    private PredicatePrecision parsePredPrecFile(FormulaManagerView pFMgr, AbstractionManager abstractionManager, Path pPredPrecFile) {
        PredicateMapParser mapParser = new PredicateMapParser(this.cfa, this.logger, pFMgr, abstractionManager, new PredicatePrecisionBootstrapper.InitialPredicatesOptions());
        try {
            return mapParser.parsePredicates(pPredPrecFile);
        }
        catch (IOException | PredicatePersistenceUtils.PredicateParsingFailedException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not read precision from file named " + pPredPrecFile);
            return PredicatePrecision.empty();
        }
    }

    private Multimap<CFANode, MemoryLocation> convertPredPrecToVariableTrackingPrec(PredicatePrecision pPredPrec, FormulaManagerView pFMgr, CFANode pDummyNode) {
        HashSet<AbstractionPredicate> predicates = new HashSet<AbstractionPredicate>();
        predicates.addAll((Collection<AbstractionPredicate>)pPredPrec.getLocalPredicates().values());
        predicates.addAll((Collection<AbstractionPredicate>)pPredPrec.getGlobalPredicates());
        predicates.addAll((Collection<AbstractionPredicate>)pPredPrec.getFunctionPredicates().values());
        HashMultimap trackedVariables = HashMultimap.create();
        for (AbstractionPredicate pred : predicates) {
            for (String var : pFMgr.extractVariables((Formula)pred.getSymbolicAtom()).keySet()) {
                trackedVariables.put((Object)pDummyNode, (Object)MemoryLocation.parseExtendedQualifiedName(var));
            }
        }
        return trackedVariables;
    }

    private Collection<CFAEdge> determineEdgesRelevantForProperty(ShutdownNotifier pConversionShutdownNotifier) {
        if (!this.relevantProperties.isEmpty()) {
            try {
                Configuration reachPropConfig = Configuration.builder().setOption("cpa", "cpa.arg.ARGCPA").setOption("ARGCPA.cpa", "cpa.composite.CompositeCPA").setOption("CompositeCPA.cpas", "cpa.location.LocationCPA,cpa.callstack.CallstackCPA").setOption("cpa.composite.aggregateBasicBlocks", "false").setOption("cpa.callstack.skipRecursion", "true").setOption("cpa.automaton.breakOnTargetState", "-1").setOption("output.disable", "true").build();
                ReachedSetFactory rsFactory = new ReachedSetFactory(reachPropConfig, this.logger);
                ConfigurableProgramAnalysis cpa = new CPABuilder(reachPropConfig, this.logger, pConversionShutdownNotifier, rsFactory).buildCPAs(this.cfa, Specification.fromFiles(this.relevantProperties, this.cfa, reachPropConfig, this.logger, pConversionShutdownNotifier), AggregatedReachedSets.empty());
                ReachedSet reached = rsFactory.createAndInitialize(cpa, this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition());
                CPAAlgorithm.create(cpa, this.logger, reachPropConfig, pConversionShutdownNotifier).run(reached);
                Preconditions.checkState((!reached.hasWaitingState() ? 1 : 0) != 0);
                ArrayDeque<ARGState> toExplore = new ArrayDeque<ARGState>((Collection<ARGState>)FluentIterable.from((Iterable)reached.asCollection()).filter(state -> ((ARGState)state).isTarget()).transform(state -> (ARGState)state).toList());
                HashSet<ARGState> visited = new HashSet<ARGState>(toExplore);
                ImmutableSet.Builder relevantEdges = ImmutableSet.builder();
                while (!toExplore.isEmpty()) {
                    ARGState exploring = (ARGState)toExplore.pop();
                    for (ARGState covered : exploring.getCoveredByThis()) {
                        if (!visited.add(covered)) continue;
                        toExplore.add(covered);
                    }
                    for (ARGState parent : exploring.getParents()) {
                        CFAEdge edge = parent.getEdgeToChild(exploring);
                        Preconditions.checkNotNull((Object)edge);
                        relevantEdges.add((Object)edge);
                        if (!visited.add(parent)) continue;
                        toExplore.add(parent);
                    }
                }
                return relevantEdges.build();
            }
            catch (InterruptedException | InvalidConfigurationException | CPAException e) {
                this.logger.logException(Level.SEVERE, e, "Failed to determine relevant edges");
            }
        }
        return FluentIterable.from(this.cfa.getAllNodes()).transformAndConcat(node -> CFAUtils.leavingEdges(node)).toSet();
    }

    private Collection<CSystemDependenceGraph.Node> getRelevantGraphUsing(MemoryLocation pVar, CSystemDependenceGraph pDepGraph, Collection<CFAEdge> pRelevantEdges) {
        return this.getRelevantGraphNodes(pVar, pDepGraph, pRelevantEdges, false);
    }

    private Collection<CSystemDependenceGraph.Node> getRelevantGraphDefining(MemoryLocation pVar, CSystemDependenceGraph pDepGraph, Collection<CFAEdge> pRelevantEdges) {
        return this.getRelevantGraphNodes(pVar, pDepGraph, pRelevantEdges, true);
    }

    private Collection<CSystemDependenceGraph.Node> getRelevantGraphNodes(MemoryLocation pVar, CSystemDependenceGraph pDepGraph, Collection<CFAEdge> pRelevantEdges, boolean extractDefinitions) {
        return FluentIterable.from(pDepGraph.getNodes()).filter(node -> (extractDefinitions ? pDepGraph.getDefs(node).contains((Object)pVar) : pDepGraph.getUses(node).contains((Object)pVar)) && (this.relevantProperties.isEmpty() || pRelevantEdges.contains(node.getStatement().orElse(this.dummyEdge)))).toList();
    }

    public boolean collectedStats() {
        return this.conversionTime.getNumberOfIntervals() > 0;
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        this.put(pOut, 0, "Time for adapting predicate precision", this.conversionTime);
        this.put(pOut, 0, "Number of tracked variables added", this.numVarsAddedToPrecision);
    }

    @Override
    public String getName() {
        return "Predicate Precision Adapter";
    }

    private static void registerRelevantVar(MemoryLocation pVar, Collection<MemoryLocation> pInspectedVars, Deque<MemoryLocation> pToProcess, Multimap<CFANode, MemoryLocation> pResult) {
        if (pInspectedVars.add(pVar)) {
            pToProcess.push(pVar);
            pResult.put((Object)dummyNode, (Object)pVar);
        }
    }

    private class AssumptionVisitor
    extends DefaultCExpressionVisitor<Void, NoException> {
        private final Collection<MemoryLocation> inspectedVars;
        private final Deque<MemoryLocation> toProcess;
        private final Multimap<CFANode, MemoryLocation> result;

        public AssumptionVisitor(Collection<MemoryLocation> pInspectedVars, Deque<MemoryLocation> pToProcess, Multimap<CFANode, MemoryLocation> pResult) {
            this.inspectedVars = pInspectedVars;
            this.toProcess = pToProcess;
            this.result = pResult;
        }

        @Override
        protected Void visitDefault(CExpression pExp) {
            return null;
        }

        @Override
        public Void visit(CBinaryExpression e) {
            if (e.getOperator().equals(CBinaryExpression.BinaryOperator.EQUALS) || e.getOperator().equals(CBinaryExpression.BinaryOperator.NOT_EQUALS) || PredicateToValuePrecisionConverter.this.nonEquivalenceInControl && (e.getOperator().equals(CBinaryExpression.BinaryOperator.GREATER_EQUAL) || e.getOperator().equals(CBinaryExpression.BinaryOperator.GREATER_THAN) || e.getOperator().equals(CBinaryExpression.BinaryOperator.LESS_EQUAL) || e.getOperator().equals(CBinaryExpression.BinaryOperator.LESS_THAN))) {
                if (e.getOperand1() instanceof CLiteralExpression) {
                    this.insertVariable(e.getOperand2());
                } else if (e.getOperand2() instanceof CLiteralExpression) {
                    this.insertVariable(e.getOperand1());
                } else {
                    Optional<MemoryLocation> var1 = this.getVariable(e.getOperand1());
                    Optional<MemoryLocation> var2 = this.getVariable(e.getOperand2());
                    if (var1.isPresent() && var2.isPresent()) {
                        if (this.inspectedVars.contains(var1.orElseThrow())) {
                            PredicateToValuePrecisionConverter.registerRelevantVar(var2.orElseThrow(), this.inspectedVars, this.toProcess, this.result);
                        } else if (this.inspectedVars.contains(var2.orElseThrow())) {
                            PredicateToValuePrecisionConverter.registerRelevantVar(var1.orElseThrow(), this.inspectedVars, this.toProcess, this.result);
                        }
                    }
                }
            }
            return null;
        }

        private void insertVariable(CExpression exp) {
            Optional<MemoryLocation> var = this.getVariable(exp);
            if (var.isPresent()) {
                PredicateToValuePrecisionConverter.registerRelevantVar(var.orElseThrow(), this.inspectedVars, this.toProcess, this.result);
            }
        }

        private Optional<MemoryLocation> getVariable(CExpression exp) {
            if (exp instanceof CIdExpression) {
                return Optional.of(MemoryLocation.parseExtendedQualifiedName(((CIdExpression)exp).getDeclaration().getQualifiedName()));
            }
            return Optional.empty();
        }
    }

    private class ControlDependenceVisitor
    implements CSystemDependenceGraph.BackwardsVisitor {
        private final AssumptionVisitor assumeVisitor;

        public ControlDependenceVisitor(Collection<MemoryLocation> pInspectedVars, Deque<MemoryLocation> pToProcess, Multimap<CFANode, MemoryLocation> pResult) {
            this.assumeVisitor = new AssumptionVisitor(pInspectedVars, pToProcess, pResult);
        }

        @Override
        public SystemDependenceGraph.VisitResult visitNode(CSystemDependenceGraph.Node pNode) {
            return SystemDependenceGraph.VisitResult.CONTINUE;
        }

        @Override
        public SystemDependenceGraph.VisitResult visitEdge(SystemDependenceGraph.EdgeType pType, CSystemDependenceGraph.Node pPredecessor, CSystemDependenceGraph.Node pSuccessor) {
            if (pType == SystemDependenceGraph.EdgeType.CONTROL_DEPENDENCY) {
                CFAEdge edge = pSuccessor.getStatement().orElse(null);
                if (edge instanceof CAssumeEdge) {
                    ((CAssumeEdge)edge).getExpression().accept(this.assumeVisitor);
                }
                return SystemDependenceGraph.VisitResult.CONTINUE;
            }
            return SystemDependenceGraph.VisitResult.SKIP;
        }
    }

    public static enum PredicateConverterStrategy {
        CONVERT_ONLY,
        CONVERT_AND_ADD_FLOW_BACKWARD,
        CONVERT_AND_ADD_FLOW_BIDIRECTED;

    }
}

