/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.File;
import java.util.Map;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.value.TestCompTestcaseLoader;

public class TestCompTestcaseLoaderTest {
    static final String PREFIX = "test/programs/testcomp-tests/";

    @Test
    public void testLoadingSingleInput() throws Exception {
        ImmutableMap expected = ImmutableMap.of((Object)0, (Object)"2");
        Map<Integer, String> loadedInputs = TestCompTestcaseLoader.loadTestcase(new File("test/programs/testcomp-tests/testfile1.xml").toPath());
        this.assertMapEquals((Map<Integer, String>)expected, loadedInputs);
    }

    @Test
    public void testLoadingSeveralInputs() throws Exception {
        ImmutableMap expected = ImmutableMap.builder().put((Object)0, (Object)"1").put((Object)1, (Object)"2").put((Object)2, (Object)"42").buildOrThrow();
        Map<Integer, String> loadedInputs = TestCompTestcaseLoader.loadTestcase(new File("test/programs/testcomp-tests/testfile2.xml").toPath());
        this.assertMapEquals((Map<Integer, String>)expected, loadedInputs);
    }

    private void assertMapEquals(Map<Integer, String> pExpected, Map<Integer, String> pActual) {
        Truth.assertThat(pActual).containsExactlyEntriesIn(pExpected);
    }
}

