/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithConcreteCex;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.value.PredicateToValuePrecisionConverter;
import org.sosy_lab.cpachecker.cpa.value.UnknownValueAssigner;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPAStatistics;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisReducer;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisConcreteErrorPathAllocator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.ConstraintsStrengthenOperator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.SymbolicValueAnalysisPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.value.symbolic.SymbolicValueAssigner;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.StateToFormulaWriter;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.states.MemoryLocationValueHandler;

@Options(prefix="cpa.value")
public class ValueAnalysisCPA
extends AbstractCPA
implements ConfigurableProgramAnalysisWithBAM,
StatisticsProvider,
ProofChecker.ProofCheckerCPA,
ConfigurableProgramAnalysisWithConcreteCex {
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which merge operator to use for ValueAnalysisCPA")
    private String mergeType = "SEP";
    @Option(secure=true, name="stop", toUppercase=true, values={"SEP", "JOIN", "NEVER", "EQUALS"}, description="which stop operator to use for ValueAnalysisCPA")
    private String stopType = "SEP";
    @Option(secure=true, description="get an initial precision from file")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path initialPrecisionFile = null;
    @Option(secure=true, description="get an initial precision from a predicate precision file")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path initialPredicatePrecisionFile = null;
    @Option(secure=true, name="unknownValueHandling", description="Tells the value analysis how to handle unknown values.")
    private UnknownValueStrategy unknownValueStrategy = UnknownValueStrategy.DISCARD;
    private VariableTrackingPrecision precision;
    private final ValueAnalysisCPAStatistics statistics;
    private final StateToFormulaWriter writer;
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfa;
    private boolean refineablePrecisionSet = false;
    private ValueAnalysisConcreteErrorPathAllocator errorPathAllocator;
    private MemoryLocationValueHandler unknownValueHandler;
    private final ConstraintsStrengthenOperator constraintsStrengthenOperator;
    private final ValueAnalysisTransferRelation.ValueTransferOptions transferOptions;
    private final ValueAnalysisPrecisionAdjustment.PrecAdjustmentOptions precisionAdjustmentOptions;
    private final ValueAnalysisPrecisionAdjustment.PrecAdjustmentStatistics precisionAdjustmentStatistics;
    private final PredicateToValuePrecisionConverter predToValPrec;
    private SymbolicValueAnalysisPrecisionAdjustment.SymbolicStatistics symbolicStats;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ValueAnalysisCPA.class);
    }

    private ValueAnalysisCPA(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, CFA cfa) throws InvalidConfigurationException {
        super(DelegateAbstractDomain.getInstance(), null);
        this.config = config;
        this.logger = logger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = cfa;
        config.inject((Object)this, ValueAnalysisCPA.class);
        this.predToValPrec = new PredicateToValuePrecisionConverter(config, logger, pShutdownNotifier, cfa);
        this.precision = this.initializePrecision(config, cfa);
        this.statistics = new ValueAnalysisCPAStatistics(this, config);
        this.writer = new StateToFormulaWriter(config, logger, this.shutdownNotifier, cfa);
        this.errorPathAllocator = new ValueAnalysisConcreteErrorPathAllocator(config, logger, cfa.getMachineModel());
        this.unknownValueHandler = this.createUnknownValueHandler();
        this.constraintsStrengthenOperator = new ConstraintsStrengthenOperator(config, logger);
        this.transferOptions = new ValueAnalysisTransferRelation.ValueTransferOptions(config);
        this.precisionAdjustmentOptions = new ValueAnalysisPrecisionAdjustment.PrecAdjustmentOptions(config, cfa);
        this.precisionAdjustmentStatistics = new ValueAnalysisPrecisionAdjustment.PrecAdjustmentStatistics();
    }

    private MemoryLocationValueHandler createUnknownValueHandler() throws InvalidConfigurationException {
        switch (this.unknownValueStrategy) {
            case DISCARD: {
                return new UnknownValueAssigner();
            }
            case INTRODUCE_SYMBOLIC: {
                return new SymbolicValueAssigner(this.config);
            }
        }
        throw new AssertionError((Object)("Unhandled strategy: " + this.unknownValueStrategy));
    }

    private VariableTrackingPrecision initializePrecision(Configuration pConfig, CFA pCfa) throws InvalidConfigurationException {
        if (this.initialPrecisionFile == null && this.initialPredicatePrecisionFile == null) {
            return VariableTrackingPrecision.createStaticPrecision(pConfig, pCfa.getVarClassification(), this.getClass());
        }
        VariableTrackingPrecision initialPrecision = VariableTrackingPrecision.createRefineablePrecision(pConfig, VariableTrackingPrecision.createStaticPrecision(pConfig, pCfa.getVarClassification(), this.getClass()));
        if (this.initialPredicatePrecisionFile != null) {
            initialPrecision = initialPrecision.withIncrement(this.predToValPrec.convertPredPrecToVariableTrackingPrec(this.initialPredicatePrecisionFile));
        }
        if (this.initialPrecisionFile != null) {
            initialPrecision = initialPrecision.withIncrement(this.restoreMappingFromFile(pCfa));
        }
        return initialPrecision;
    }

    private Multimap<CFANode, MemoryLocation> restoreMappingFromFile(CFA pCfa) {
        HashMultimap mapping = HashMultimap.create();
        List<String> contents = null;
        try {
            contents = Files.readAllLines(this.initialPrecisionFile, Charset.defaultCharset());
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not read precision from file named " + this.initialPrecisionFile);
            return mapping;
        }
        Map<Integer, CFANode> idToCfaNode = CFAUtils.getMappingFromNodeIDsToCFANodes(pCfa);
        CFANode location = this.getDefaultLocation(idToCfaNode);
        for (String currentLine : contents) {
            if (currentLine.trim().isEmpty()) continue;
            if (currentLine.endsWith(":")) {
                String scopeSelectors = currentLine.substring(0, currentLine.indexOf(":"));
                Matcher matcher = CFAUtils.CFA_NODE_NAME_PATTERN.matcher(scopeSelectors);
                if (!matcher.matches()) continue;
                location = idToCfaNode.get(Integer.parseInt(matcher.group(1)));
                continue;
            }
            mapping.put((Object)location, (Object)MemoryLocation.parseExtendedQualifiedName(currentLine));
        }
        return mapping;
    }

    private CFANode getDefaultLocation(Map<Integer, CFANode> idToCfaNode) {
        return idToCfaNode.values().iterator().next();
    }

    public void injectRefinablePrecision() throws InvalidConfigurationException {
        if (this.initialPrecisionFile == null && this.initialPredicatePrecisionFile == null && !this.refineablePrecisionSet) {
            this.precision = VariableTrackingPrecision.createRefineablePrecision(this.config, this.precision);
            this.refineablePrecisionSet = true;
        }
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.buildMergeOperator(this.mergeType);
    }

    @Override
    public StopOperator getStopOperator() {
        return this.buildStopOperator(this.stopType);
    }

    @Override
    public ValueAnalysisTransferRelation getTransferRelation() {
        return new ValueAnalysisTransferRelation(this.logger, this.cfa, this.transferOptions, this.unknownValueHandler, this.constraintsStrengthenOperator, this.statistics);
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new ValueAnalysisState(this.cfa.getMachineModel());
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.precision;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        if (this.unknownValueStrategy.equals((Object)UnknownValueStrategy.INTRODUCE_SYMBOLIC)) {
            this.symbolicStats = new SymbolicValueAnalysisPrecisionAdjustment.SymbolicStatistics();
            return new SymbolicValueAnalysisPrecisionAdjustment(this.statistics, this.cfa, this.precisionAdjustmentOptions, this.precisionAdjustmentStatistics, (SymbolicValueAnalysisPrecisionAdjustment.SymbolicStatistics)Preconditions.checkNotNull((Object)this.symbolicStats));
        }
        return new ValueAnalysisPrecisionAdjustment(this.statistics, this.cfa, this.precisionAdjustmentOptions, this.precisionAdjustmentStatistics);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public LogManager getLogger() {
        return this.logger;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }

    public CFA getCFA() {
        return this.cfa;
    }

    @Override
    public Reducer getReducer() {
        return new ValueAnalysisReducer();
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
        pStatsCollection.add(this.precisionAdjustmentStatistics);
        if (this.symbolicStats != null) {
            pStatsCollection.add(this.symbolicStats);
        }
        pStatsCollection.add(this.constraintsStrengthenOperator);
        if (this.predToValPrec.collectedStats()) {
            pStatsCollection.add(this.predToValPrec);
        }
        this.writer.collectStatistics(pStatsCollection);
    }

    @Override
    public ConcreteStatePath createConcreteStatePath(ARGPath pPath) {
        return this.errorPathAllocator.allocateAssignmentsToPath(pPath);
    }

    private static enum UnknownValueStrategy {
        DISCARD,
        INTRODUCE_SYMBOLIC;

    }
}

