/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.value")
public class ValueAnalysisCPAStatistics
implements Statistics {
    @Option(secure=true, description="target file to hold the exported precision")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path precisionFile = null;
    private LongAdder iterations = new LongAdder();
    private StatCounter assumptions = new StatCounter("Number of assumptions");
    private StatCounter deterministicAssumptions = new StatCounter("Number of deterministic assumptions");
    private final ValueAnalysisCPA cpa;

    public ValueAnalysisCPAStatistics(ValueAnalysisCPA cpa, Configuration config) throws InvalidConfigurationException {
        this.cpa = cpa;
        config.inject((Object)this, ValueAnalysisCPAStatistics.class);
    }

    @Override
    public String getName() {
        return "ValueAnalysisCPA";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        StatInt numberOfVariables = new StatInt(StatKind.AVG, "Number of variables per state");
        StatInt numberOfGlobalVariables = new StatInt(StatKind.AVG, "Number of global variables per state");
        for (AbstractState currentAbstractState : reached) {
            ValueAnalysisState currentState = AbstractStates.extractStateByType(currentAbstractState, ValueAnalysisState.class);
            numberOfVariables.setNextValue(currentState.getSize());
            numberOfGlobalVariables.setNextValue(currentState.getNumberOfGlobalVariables());
        }
        StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(out);
        writer.put(numberOfVariables);
        writer.put(numberOfGlobalVariables);
        if (this.precisionFile != null) {
            this.exportPrecision(reached);
        }
        writer.put(this.assumptions).put(this.deterministicAssumptions).put("Level of Determinism", this.getCurrentLevelOfDeterminism() + "%");
    }

    private void exportPrecision(UnmodifiableReachedSet reached) {
        VariableTrackingPrecision consolidatedPrecision = VariableTrackingPrecision.joinVariableTrackingPrecisionsInReachedSet(reached);
        try (Writer writer = IO.openOutputFile((Path)this.precisionFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            consolidatedPrecision.serialize(writer);
        }
        catch (IOException e) {
            this.cpa.getLogger().logUserException(Level.WARNING, (Throwable)e, "Could not write value-analysis precision to file");
        }
    }

    void incrementIterations() {
        this.iterations.increment();
    }

    void incrementAssumptions() {
        this.assumptions.inc();
    }

    void incrementDeterministicAssumptions() {
        this.assumptions.inc();
    }

    int getCurrentNumberOfIterations() {
        return this.iterations.intValue();
    }

    int getCurrentLevelOfDeterminism() {
        if (this.assumptions.getValue() == 0L) {
            return 100;
        }
        return (int)Math.round((double)(this.deterministicAssumptions.getValue() * 100L) / (double)this.assumptions.getValue());
    }
}

