/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.util.Map;
import java.util.Optional;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.path.AssignmentsInPathCondition;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPAStatistics;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

public class ValueAnalysisPrecisionAdjustment
implements PrecisionAdjustment {
    private final ValueAnalysisCPAStatistics stats;
    private final PrecAdjustmentOptions options;
    private final Optional<LiveVariables> liveVariables;
    private final StatCounter abstractions;
    private final ThreadSafeTimerContainer.TimerWrapper totalLiveness;
    private final ThreadSafeTimerContainer.TimerWrapper totalAbstraction;
    private final ThreadSafeTimerContainer.TimerWrapper totalEnforcePath;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="false alarm")
    private boolean performPrecisionBasedAbstraction = false;

    public ValueAnalysisPrecisionAdjustment(ValueAnalysisCPAStatistics pStats, CFA pCfa, PrecAdjustmentOptions pOptions, PrecAdjustmentStatistics pStatistics) {
        this.options = pOptions;
        this.stats = pStats;
        this.liveVariables = pCfa.getLiveVariables();
        this.abstractions = pStatistics.abstractions;
        this.totalLiveness = pStatistics.totalLivenessTimer.getNewTimer();
        this.totalAbstraction = pStatistics.totalAbstractionTimer.getNewTimer();
        this.totalEnforcePath = pStatistics.totalEnforcePathTimer.getNewTimer();
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException, InterruptedException {
        return this.prec((ValueAnalysisState)pState, (VariableTrackingPrecision)pPrecision, AbstractStates.extractStateByType(fullState, LocationState.class), AbstractStates.extractStateByType(fullState, AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState.class));
    }

    private Optional<PrecisionAdjustmentResult> prec(ValueAnalysisState pState, VariableTrackingPrecision pPrecision, LocationState location, AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments) {
        ValueAnalysisState resultState = ValueAnalysisState.copyOf(pState);
        if (this.options.doLivenessAbstraction && this.liveVariables.isPresent()) {
            this.totalLiveness.start();
            this.enforceLiveness(pState, location, resultState);
            this.totalLiveness.stop();
        }
        this.totalAbstraction.start();
        if (this.performPrecisionBasedAbstraction()) {
            this.enforcePrecision(resultState, location, pPrecision);
        }
        this.totalAbstraction.stop();
        if (assignments != null) {
            this.totalEnforcePath.start();
            this.enforcePathThreshold(resultState, assignments);
            this.totalEnforcePath.stop();
        }
        resultState = resultState.equals(pState) ? pState : resultState;
        return Optional.of(PrecisionAdjustmentResult.create(resultState, pPrecision, PrecisionAdjustmentResult.Action.CONTINUE));
    }

    private boolean performPrecisionBasedAbstraction() {
        if (this.options.iterationThreshold == -1) {
            return true;
        }
        if (this.stats.getCurrentNumberOfIterations() < this.options.iterationThreshold) {
            return false;
        }
        if (this.performPrecisionBasedAbstraction) {
            return true;
        }
        this.performPrecisionBasedAbstraction = this.stats.getCurrentLevelOfDeterminism() < this.options.determinismThreshold;
        return this.performPrecisionBasedAbstraction;
    }

    private void enforceLiveness(ValueAnalysisState pState, LocationState location, ValueAnalysisState resultState) {
        boolean hasMoreThanOneEnteringLeavingEdge;
        CFANode actNode = location.getLocationNode();
        boolean bl = hasMoreThanOneEnteringLeavingEdge = actNode.getNumEnteringEdges() > 1 || actNode.getNumLeavingEdges() > 1;
        if (!this.options.onlyAtNonLinearCFA || hasMoreThanOneEnteringLeavingEdge) {
            boolean onlyBlankEdgesEntering = true;
            for (int i = 0; i < actNode.getNumEnteringEdges() && onlyBlankEdgesEntering; ++i) {
                onlyBlankEdgesEntering = location.getLocationNode().getEnteringEdge(i) instanceof BlankEdge;
            }
            if (!onlyBlankEdgesEntering) {
                for (MemoryLocation variable : pState.getTrackedMemoryLocations()) {
                    if (this.liveVariables.orElseThrow().isVariableLive(variable.getExtendedQualifiedName(), location.getLocationNode())) continue;
                    resultState.forget(variable);
                }
            }
        }
    }

    private void enforcePrecision(ValueAnalysisState state, LocationState location, VariableTrackingPrecision precision) {
        if (this.options.abstractAtEachLocation() || this.options.abstractAtBranch(location) || this.options.abstractAtJoin(location) || this.options.abstractAtFunction(location) || this.options.abstractAtLoop(location)) {
            for (Map.Entry<MemoryLocation, ValueAnalysisState.ValueAndType> e : state.getConstants()) {
                MemoryLocation memoryLocation = e.getKey();
                if (location == null || precision.isTracking(memoryLocation, e.getValue().getType(), location.getLocationNode())) continue;
                state.forget(memoryLocation);
            }
            this.abstractions.inc();
        }
    }

    private void enforcePathThreshold(ValueAnalysisState state, AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments) {
        for (Map.Entry<MemoryLocation, ValueAnalysisState.ValueAndType> e : state.getConstants()) {
            MemoryLocation memoryLocation = e.getKey();
            assignments.updateAssignmentInformation(memoryLocation, e.getValue().getValue());
            if (!assignments.exceedsThreshold(memoryLocation)) continue;
            state.forget(memoryLocation);
        }
    }

    public static class PrecAdjustmentStatistics
    implements Statistics {
        final StatCounter abstractions = new StatCounter("Number of abstraction computations");
        private final ThreadSafeTimerContainer totalLivenessTimer = new ThreadSafeTimerContainer("Total time for liveness abstraction");
        private final ThreadSafeTimerContainer totalAbstractionTimer = new ThreadSafeTimerContainer("Total time for abstraction computation");
        private final ThreadSafeTimerContainer totalEnforcePathTimer = new ThreadSafeTimerContainer("Total time for path thresholds");

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut);
            writer.put(this.abstractions);
            writer.put(this.totalLivenessTimer);
            writer.put(this.totalAbstractionTimer);
            writer.put(this.totalEnforcePathTimer);
        }

        @Override
        public String getName() {
            return "ValueAnalysisPrecisionAdjustment";
        }
    }

    @Options(prefix="cpa.value.abstraction")
    public static class PrecAdjustmentOptions {
        @Option(secure=true, description="restrict abstraction computations to branching points")
        private boolean alwaysAtBranch = false;
        @Option(secure=true, description="restrict abstraction computations to join points")
        private boolean alwaysAtJoin = false;
        @Option(secure=true, description="restrict abstraction computations to function calls/returns")
        private boolean alwaysAtFunction = false;
        @Option(secure=true, description="restrict abstraction computations to loop heads")
        private boolean alwaysAtLoop = false;
        @Option(secure=true, description="toggle liveness abstraction")
        private boolean doLivenessAbstraction = false;
        @Option(secure=true, description="restrict liveness abstractions to nodes with more than one entering and/or leaving edge")
        private boolean onlyAtNonLinearCFA = false;
        @Option(secure=true, description="skip abstraction computations until the given number of iterations are reached, after that decision is based on then current level of determinism, setting the option to -1 always performs abstraction computations")
        @IntegerOption(min=-1L)
        private int iterationThreshold = -1;
        @Option(secure=true, description="threshold for level of determinism, in percent, up-to which abstraction computations are performed (and iteration threshold was reached)")
        @IntegerOption(min=0L, max=100L)
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="false alarm")
        private int determinismThreshold = 85;
        private final ImmutableSet<CFANode> loopHeads;

        public PrecAdjustmentOptions(Configuration config, CFA pCfa) throws InvalidConfigurationException {
            config.inject((Object)this);
            this.loopHeads = this.alwaysAtLoop && pCfa.getAllLoopHeads().isPresent() ? pCfa.getAllLoopHeads().orElseThrow() : null;
        }

        private boolean abstractAtEachLocation() {
            return !this.alwaysAtBranch && !this.alwaysAtJoin && !this.alwaysAtFunction && !this.alwaysAtLoop;
        }

        private boolean abstractAtBranch(LocationState location) {
            return this.alwaysAtBranch && location.getLocationNode().getNumLeavingEdges() > 1;
        }

        private boolean abstractAtJoin(LocationState location) {
            return this.alwaysAtJoin && location.getLocationNode().getNumEnteringEdges() > 1;
        }

        private boolean abstractAtFunction(LocationState location) {
            return this.alwaysAtFunction && (location.getLocationNode() instanceof FunctionEntryNode || location.getLocationNode().getEnteringSummaryEdge() != null);
        }

        private boolean abstractAtLoop(LocationState location) {
            Preconditions.checkState((!this.alwaysAtLoop || this.loopHeads != null ? 1 : 0) != 0);
            return this.alwaysAtLoop && this.loopHeads.contains((Object)location.getLocationNode());
        }
    }
}

