/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Splitter;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.defaults.GenericReducer;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

class ValueAnalysisReducer
extends GenericReducer<ValueAnalysisState, VariableTrackingPrecision> {
    ValueAnalysisReducer() {
    }

    @Override
    protected ValueAnalysisState getVariableReducedState0(ValueAnalysisState pExpandedState, Block pContext, CFANode pCallNode) {
        ValueAnalysisState clonedElement = ValueAnalysisState.copyOf(pExpandedState);
        for (MemoryLocation trackedVar : pExpandedState.getTrackedMemoryLocations()) {
            String simpleName = (String)Splitter.on((String)"/").splitToList((CharSequence)trackedVar.getExtendedQualifiedName()).get(0);
            if (pContext.getVariables().contains(simpleName)) continue;
            clonedElement.forget(trackedVar);
        }
        return clonedElement;
    }

    @Override
    protected ValueAnalysisState getVariableExpandedState0(ValueAnalysisState pRootState, Block pReducedContext, ValueAnalysisState pReducedState) {
        ValueAnalysisState diffElement = ValueAnalysisState.copyOf(pReducedState);
        for (Map.Entry<MemoryLocation, ValueAnalysisState.ValueAndType> e : pRootState.getConstants()) {
            MemoryLocation memloc = e.getKey();
            ValueAnalysisState.ValueAndType valueAndType = e.getValue();
            String simpleName = memloc.getExtendedQualifiedName();
            if (pReducedContext.getVariables().contains(simpleName)) continue;
            diffElement.assignConstant(memloc, valueAndType.getValue(), valueAndType.getType());
        }
        return diffElement;
    }

    protected VariableTrackingPrecision getVariableReducedPrecision0(VariableTrackingPrecision pPrecision, Block pContext) {
        VariableTrackingPrecision precision = pPrecision;
        return precision;
    }

    @Override
    protected VariableTrackingPrecision getVariableExpandedPrecision0(VariableTrackingPrecision pRootPrecision, Block pRootContext, VariableTrackingPrecision pReducedPrecision) {
        return pReducedPrecision.join(pRootPrecision);
    }

    @Override
    protected Object getHashCodeForState0(ValueAnalysisState pElementKey, VariableTrackingPrecision pPrecisionKey) {
        return Pair.of(pElementKey, pPrecisionKey);
    }

    @Override
    protected ValueAnalysisState rebuildStateAfterFunctionCall0(ValueAnalysisState pRootState, ValueAnalysisState entryState, ValueAnalysisState pExpandedState, FunctionExitNode exitLocation) {
        return pExpandedState.rebuildStateAfterFunctionCall(pRootState, exitLocation);
    }
}

