/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.ExpressionTreeReportingState;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.PseudoPartitionable;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisInformation;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ConstantSymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.type.EnumConstantValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeFactory;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.predicates.smt.BitvectorFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FloatingPointFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.refinement.ForgetfulState;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FormulaType;

public final class ValueAnalysisState
implements AbstractQueryableState,
FormulaReportingState,
ExpressionTreeReportingState,
ForgetfulState<ValueAnalysisInformation>,
Serializable,
Graphable,
LatticeAbstractState<ValueAnalysisState>,
PseudoPartitionable {
    private static final long serialVersionUID = -3152134511524554358L;
    private static final Set<MemoryLocation> blacklist = new HashSet<MemoryLocation>();
    private PersistentMap<MemoryLocation, ValueAndType> constantsMap;
    private int hashCode = 0;
    private final @Nullable MachineModel machineModel;

    static void addToBlacklist(MemoryLocation var) {
        blacklist.add((MemoryLocation)Preconditions.checkNotNull((Object)var));
    }

    public ValueAnalysisState(MachineModel pMachineModel) {
        this((MachineModel)((Object)Preconditions.checkNotNull((Object)((Object)pMachineModel))), (PersistentMap<MemoryLocation, ValueAndType>)PathCopyingPersistentTreeMap.of());
    }

    public ValueAnalysisState(Optional<MachineModel> pMachineModel, PersistentMap<MemoryLocation, ValueAndType> pConstantsMap) {
        this((MachineModel)pMachineModel.orElse(null), pConstantsMap);
    }

    private ValueAnalysisState(@Nullable MachineModel pMachineModel, PersistentMap<MemoryLocation, ValueAndType> pConstantsMap) {
        this.machineModel = pMachineModel;
        this.constantsMap = (PersistentMap)Preconditions.checkNotNull(pConstantsMap);
        this.hashCode = this.constantsMap.hashCode();
    }

    private ValueAnalysisState(ValueAnalysisState state) {
        this.machineModel = state.machineModel;
        this.constantsMap = (PersistentMap)Preconditions.checkNotNull(state.constantsMap);
        this.hashCode = state.hashCode;
        assert (this.hashCode == this.constantsMap.hashCode());
    }

    public static ValueAnalysisState copyOf(ValueAnalysisState state) {
        return new ValueAnalysisState(state);
    }

    void assignConstant(String variableName, Value value) {
        this.addToConstantsMap(MemoryLocation.parseExtendedQualifiedName(variableName), value, null);
    }

    private void addToConstantsMap(MemoryLocation pMemLoc, Value pValue, @Nullable Type pType) {
        if (blacklist.contains(pMemLoc) || pMemLoc.isReference() && blacklist.contains(pMemLoc.getReferenceStart())) {
            return;
        }
        Value valueToAdd = pValue;
        if (valueToAdd instanceof SymbolicValue) {
            valueToAdd = ((SymbolicValue)valueToAdd).copyForLocation(pMemLoc);
        }
        ValueAndType valueAndType = new ValueAndType((Value)Preconditions.checkNotNull((Object)valueToAdd), pType);
        ValueAndType oldValueAndType = (ValueAndType)this.constantsMap.get((Object)pMemLoc);
        if (oldValueAndType != null) {
            this.hashCode -= pMemLoc.hashCode() ^ oldValueAndType.hashCode();
        }
        this.constantsMap = this.constantsMap.putAndCopy((Object)pMemLoc, (Object)valueAndType);
        this.hashCode += pMemLoc.hashCode() ^ valueAndType.hashCode();
    }

    public void assignConstant(MemoryLocation pMemoryLocation, Value value, Type pType) {
        this.addToConstantsMap(pMemoryLocation, value, pType);
    }

    public void assignConstant(SymbolicIdentifier pSymbolicIdentifier, Value pValue, AbstractExpressionValueVisitor pValueVisitor) {
        for (Map.Entry entry : this.constantsMap.entrySet()) {
            CType memLocType = (CType)((ValueAndType)entry.getValue()).getType();
            Value typedValue = pValue;
            if (pValue.isNumericValue()) {
                CIntegerLiteralExpression valueAsExpression = new CIntegerLiteralExpression(FileLocation.DUMMY, memLocType, BigInteger.valueOf(pValue.asNumericValue().longValue()));
                try {
                    typedValue = pValueVisitor.evaluate(valueAsExpression, memLocType);
                }
                catch (UnrecognizedCodeException pE) {
                    throw new AssertionError((Object)pE);
                }
            }
            MemoryLocation currMemloc = (MemoryLocation)entry.getKey();
            Value currVal = ((ValueAndType)entry.getValue()).getValue();
            if (currVal instanceof ConstantSymbolicExpression) {
                currVal = ((ConstantSymbolicExpression)currVal).getValue();
            }
            if (!(currVal instanceof SymbolicIdentifier) || ((SymbolicIdentifier)currVal).getId() != pSymbolicIdentifier.getId()) continue;
            this.assignConstant(currMemloc, typedValue, memLocType);
        }
    }

    @Override
    public ValueAnalysisInformation forget(MemoryLocation pMemoryLocation) {
        if (!this.constantsMap.containsKey((Object)pMemoryLocation)) {
            return ValueAnalysisInformation.EMPTY;
        }
        ValueAndType value = (ValueAndType)this.constantsMap.get((Object)pMemoryLocation);
        this.constantsMap = this.constantsMap.removeAndCopy((Object)pMemoryLocation);
        this.hashCode -= pMemoryLocation.hashCode() ^ value.hashCode();
        PersistentSortedMap valueAssignment = PathCopyingPersistentTreeMap.of();
        valueAssignment = valueAssignment.putAndCopy((Object)pMemoryLocation, (Object)value);
        return new ValueAnalysisInformation((PersistentMap<MemoryLocation, ValueAndType>)valueAssignment);
    }

    @Override
    public void remember(MemoryLocation pLocation, ValueAnalysisInformation pValueAndType) {
        ValueAndType value = (ValueAndType)pValueAndType.getAssignments().get((Object)pLocation);
        this.assignConstant(pLocation, value.getValue(), value.getType());
    }

    @Deprecated
    public void retainAll(Set<MemoryLocation> toRetain) {
        HashSet<MemoryLocation> toRemove = new HashSet<MemoryLocation>();
        for (MemoryLocation memoryLocation : this.constantsMap.keySet()) {
            if (toRetain.contains(memoryLocation)) continue;
            toRemove.add(memoryLocation);
        }
        for (MemoryLocation memoryLocation : toRemove) {
            this.forget(memoryLocation);
        }
    }

    void dropFrame(String functionName) {
        for (MemoryLocation variableName : this.constantsMap.keySet()) {
            if (!variableName.isOnFunctionStack(functionName)) continue;
            this.forget(variableName);
        }
    }

    public Value getValueFor(MemoryLocation memLoc) {
        return (Value)Preconditions.checkNotNull((Object)this.getValueAndTypeFor(memLoc).getValue());
    }

    public @Nullable Type getTypeForMemoryLocation(MemoryLocation memLoc) {
        return this.getValueAndTypeFor(memLoc).getType();
    }

    public ValueAndType getValueAndTypeFor(MemoryLocation memLoc) {
        return (ValueAndType)Preconditions.checkNotNull((Object)((ValueAndType)this.constantsMap.get((Object)memLoc)));
    }

    public boolean contains(MemoryLocation pMemoryLocation) {
        return this.constantsMap.containsKey((Object)pMemoryLocation);
    }

    @Override
    public int getSize() {
        return this.constantsMap.size();
    }

    int getNumberOfGlobalVariables() {
        int numberOfGlobalVariables = 0;
        for (MemoryLocation variableName : this.constantsMap.keySet()) {
            if (variableName.isOnFunctionStack()) continue;
            ++numberOfGlobalVariables;
        }
        return numberOfGlobalVariables;
    }

    @Override
    public ValueAnalysisState join(ValueAnalysisState reachedState) {
        PersistentSortedMap newConstantsMap = PathCopyingPersistentTreeMap.of();
        for (Map.Entry otherEntry : reachedState.constantsMap.entrySet()) {
            MemoryLocation key = (MemoryLocation)otherEntry.getKey();
            ValueAndType value = (ValueAndType)otherEntry.getValue();
            if (!Objects.equals(value, this.constantsMap.get((Object)key))) continue;
            newConstantsMap = newConstantsMap.putAndCopy((Object)key, (Object)value);
        }
        if (newConstantsMap.size() == reachedState.constantsMap.size()) {
            return reachedState;
        }
        return new ValueAnalysisState(this.machineModel, (PersistentMap<MemoryLocation, ValueAndType>)newConstantsMap);
    }

    @Override
    public boolean isLessOrEqual(ValueAnalysisState other) {
        if (this.constantsMap.size() < other.constantsMap.size()) {
            return false;
        }
        for (Map.Entry otherEntry : other.constantsMap.entrySet()) {
            MemoryLocation key = (MemoryLocation)otherEntry.getKey();
            Value otherValue = ((ValueAndType)otherEntry.getValue()).getValue();
            ValueAndType thisValueAndType = (ValueAndType)this.constantsMap.get((Object)key);
            if (thisValueAndType != null && otherValue.equals(thisValueAndType.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ValueAnalysisState otherElement = (ValueAnalysisState)other;
        return otherElement.hashCode == this.hashCode && otherElement.constantsMap.equals(this.constantsMap);
    }

    @Override
    public int hashCode() {
        assert (this.hashCode == this.constantsMap.hashCode());
        return this.hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry entry : this.constantsMap.entrySet()) {
            MemoryLocation key = (MemoryLocation)entry.getKey();
            sb.append(" <");
            sb.append(key.getExtendedQualifiedName());
            sb.append(" = ");
            sb.append(((ValueAndType)entry.getValue()).getValue());
            sb.append(">\n");
        }
        return sb.append("] size->  ").append(this.constantsMap.size()).toString();
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Joiner.on((String)", ").withKeyValueSeparator("=").appendTo(sb, this.constantsMap);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        if ((pProperty = pProperty.trim()).startsWith("contains(")) {
            String varName = pProperty.substring("contains(".length(), pProperty.length() - 1);
            return this.constantsMap.containsKey((Object)MemoryLocation.parseExtendedQualifiedName(varName));
        }
        List parts = Splitter.on((String)"==").trimResults().splitToList((CharSequence)pProperty);
        if (parts.size() != 2) {
            ValueAndType value = (ValueAndType)this.constantsMap.get((Object)MemoryLocation.parseExtendedQualifiedName(pProperty));
            if (value != null && value.getValue().isExplicitlyKnown()) {
                return value.getValue();
            }
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not find the variable \"" + pProperty + "\"");
        }
        return this.checkProperty(pProperty);
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        List parts = Splitter.on((String)"==").trimResults().splitToList((CharSequence)pProperty);
        if (parts.size() != 2) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not split the property string correctly.");
        }
        ValueAndType val = (ValueAndType)this.constantsMap.get((Object)MemoryLocation.parseExtendedQualifiedName((String)parts.get(0)));
        if (val == null) {
            return false;
        }
        Long value = val.getValue().asLong(CNumericTypes.INT);
        if (value == null) {
            return false;
        }
        try {
            return value == Long.parseLong((String)parts.get(1));
        }
        catch (NumberFormatException e) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not parse the long \"" + (String)parts.get(1) + "\"");
        }
    }

    private static boolean startsWithIgnoreCase(String s, String prefix) {
        s = s.substring(0, prefix.length());
        return s.equalsIgnoreCase(prefix);
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        Preconditions.checkNotNull((Object)pModification);
        for (String statement : Splitter.on((char)';').trimResults().split((CharSequence)pModification)) {
            if (ValueAnalysisState.startsWithIgnoreCase(statement, "deletevalues(")) {
                if (!statement.endsWith(")")) {
                    throw new InvalidQueryException(statement + " should end with \")\"");
                }
                MemoryLocation varName = MemoryLocation.parseExtendedQualifiedName(statement.substring("deletevalues(".length(), statement.length() - 1));
                if (!this.contains(varName)) continue;
                this.forget(varName);
                continue;
            }
            if (!ValueAnalysisState.startsWithIgnoreCase(statement, "setvalue(")) continue;
            if (!statement.endsWith(")")) {
                throw new InvalidQueryException(statement + " should end with \")\"");
            }
            String assignment = statement.substring("setvalue(".length(), statement.length() - 1);
            List assignmentParts = Splitter.on((String)":=").trimResults().splitToList((CharSequence)assignment);
            if (assignmentParts.size() != 2) {
                throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not split the property string correctly.");
            }
            String varName = (String)assignmentParts.get(0);
            try {
                NumericValue newValue = new NumericValue(Long.parseLong((String)assignmentParts.get(1)));
                this.assignConstant(varName, newValue);
            }
            catch (NumberFormatException e) {
                throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not parse the long \"" + (String)assignmentParts.get(1) + "\"");
            }
        }
    }

    @Override
    public String getCPAName() {
        return "ValueAnalysis";
    }

    @Override
    public BooleanFormula getFormulaApproximation(FormulaManagerView manager) {
        BooleanFormulaManagerView bfmgr = manager.getBooleanFormulaManager();
        if (this.machineModel == null) {
            return bfmgr.makeTrue();
        }
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        BitvectorFormulaManagerView bitvectorFMGR = manager.getBitvectorFormulaManager();
        FloatingPointFormulaManagerView floatFMGR = manager.getFloatingPointFormulaManager();
        for (Map.Entry entry : this.constantsMap.entrySet()) {
            FormulaType.FloatingPointType fpType;
            BitvectorFormula var;
            NumericValue num = ((ValueAndType)entry.getValue()).getValue().asNumericValue();
            if (num == null) continue;
            MemoryLocation memoryLocation = (MemoryLocation)entry.getKey();
            Type type = ((ValueAndType)entry.getValue()).getType();
            if (memoryLocation.isReference() || !(type instanceof CSimpleType)) continue;
            CSimpleType simpleType = (CSimpleType)type;
            if (simpleType.getType().isIntegerType()) {
                int bitSize = this.machineModel.getSizeof(simpleType) * this.machineModel.getSizeofCharInBits();
                var = bitvectorFMGR.makeVariable(bitSize, ((MemoryLocation)entry.getKey()).getExtendedQualifiedName());
                Number value = num.getNumber();
                BitvectorFormula val = value instanceof BigInteger ? bitvectorFMGR.makeBitvector(bitSize, (BigInteger)value) : bitvectorFMGR.makeBitvector(bitSize, num.longValue());
                result.add(bitvectorFMGR.equal(var, val));
                continue;
            }
            if (!simpleType.getType().isFloatingPointType()) continue;
            switch (simpleType.getType()) {
                case FLOAT: {
                    fpType = FormulaType.getSinglePrecisionFloatingPointType();
                    break;
                }
                case DOUBLE: {
                    fpType = FormulaType.getDoublePrecisionFloatingPointType();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported floating point type: " + simpleType));
                }
            }
            var = floatFMGR.makeVariable(((MemoryLocation)entry.getKey()).getExtendedQualifiedName(), fpType);
            FloatingPointFormula val = floatFMGR.makeNumber(num.doubleValue(), fpType);
            result.add(floatFMGR.equalWithFPSemantics((FloatingPointFormula)var, val));
        }
        return bfmgr.and(result);
    }

    @Deprecated
    public Set<MemoryLocation> getDifference(ValueAnalysisState other) {
        HashSet<MemoryLocation> difference = new HashSet<MemoryLocation>();
        for (MemoryLocation variableName : other.constantsMap.keySet()) {
            if (!this.contains(variableName)) {
                difference.add(variableName);
                continue;
            }
            if (this.getValueFor(variableName).equals(other.getValueFor(variableName))) continue;
            difference.add(variableName);
        }
        return difference;
    }

    @Override
    public Set<MemoryLocation> getTrackedMemoryLocations() {
        return this.constantsMap.keySet();
    }

    public Set<Map.Entry<MemoryLocation, ValueAndType>> getConstants() {
        return Collections.unmodifiableSet(this.constantsMap.entrySet());
    }

    public ValueAnalysisInterpolant createInterpolant() {
        return new ValueAnalysisInterpolant(this.constantsMap);
    }

    public ValueAnalysisInformation getInformation() {
        return new ValueAnalysisInformation(this.constantsMap);
    }

    public ValueAnalysisState rebuildStateAfterFunctionCall(ValueAnalysisState callState, FunctionExitNode functionExit) {
        ValueAnalysisState rebuildState = ValueAnalysisState.copyOf(callState);
        for (MemoryLocation memoryLocation : callState.getTrackedMemoryLocations()) {
            if (memoryLocation.isOnFunctionStack()) continue;
            rebuildState.forget(memoryLocation);
        }
        for (Map.Entry entry : this.getConstants()) {
            MemoryLocation trackedVar = (MemoryLocation)entry.getKey();
            if (!trackedVar.isOnFunctionStack()) {
                rebuildState.assignConstant(trackedVar, ((ValueAndType)entry.getValue()).getValue(), ((ValueAndType)entry.getValue()).getType());
                continue;
            }
            if (!functionExit.getEntryNode().getReturnVariable().isPresent() || !functionExit.getEntryNode().getReturnVariable().get().getQualifiedName().equals(trackedVar.getExtendedQualifiedName()) || !this.contains(trackedVar)) continue;
            rebuildState.assignConstant(trackedVar, ((ValueAndType)entry.getValue()).getValue(), ((ValueAndType)entry.getValue()).getType());
        }
        return rebuildState;
    }

    @Override
    public Comparable<?> getPseudoPartitionKey() {
        return this.getSize();
    }

    @Override
    public Object getPseudoHashCode() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExpressionTree<Object> getFormulaApproximation(FunctionEntryNode pFunctionScope, CFANode pLocation) {
        if (this.machineModel == null) {
            return ExpressionTrees.getTrue();
        }
        CBinaryExpressionBuilder builder = new CBinaryExpressionBuilder(this.machineModel, LogManager.createNullLogManager());
        ExpressionTreeFactory factory = ExpressionTrees.newFactory();
        ArrayList result = new ArrayList();
        for (Map.Entry entry : this.constantsMap.entrySet()) {
            NumericValue num;
            Value valueOfEntry = ((ValueAndType)entry.getValue()).getValue();
            if (valueOfEntry instanceof EnumConstantValue || (num = valueOfEntry.asNumericValue()) == null) continue;
            MemoryLocation memoryLocation = (MemoryLocation)entry.getKey();
            Type type = ((ValueAndType)entry.getValue()).getType();
            if (memoryLocation.isReference() || !memoryLocation.isOnFunctionStack(pFunctionScope.getFunctionName()) || !(type instanceof CType) || !CTypes.isArithmeticType((CType)type)) continue;
            CType cType = (CType)type;
            if (cType instanceof CBitFieldType) {
                cType = ((CBitFieldType)cType).getType();
            }
            if (cType instanceof CElaboratedType) {
                cType = ((CElaboratedType)cType).getRealType();
            }
            assert (cType != null && CTypes.isArithmeticType(cType));
            String id = memoryLocation.getIdentifier();
            if (pFunctionScope.getReturnVariable().isPresent() && id.equals(pFunctionScope.getReturnVariable().get().getName())) continue;
            FileLocation loc = pLocation.getNumEnteringEdges() > 0 ? pLocation.getEnteringEdge(0).getFileLocation() : pFunctionScope.getFileLocation();
            CVariableDeclaration decl = new CVariableDeclaration(loc, false, CStorageClass.AUTO, cType, id, id, memoryLocation.getExtendedQualifiedName(), null);
            CIdExpression var = new CIdExpression(loc, decl);
            AbstractExpression val = null;
            if (cType instanceof CSimpleType) {
                CSimpleType simpleType = (CSimpleType)type;
                if (simpleType.getType().isIntegerType()) {
                    long value = num.getNumber().longValue();
                    val = new CIntegerLiteralExpression(loc, simpleType, BigInteger.valueOf(value));
                } else {
                    if (!simpleType.getType().isFloatingPointType()) throw new AssertionError((Object)("Unexpected type: " + simpleType));
                    double value = num.getNumber().doubleValue();
                    if (Double.valueOf(value).isNaN() || Double.valueOf(value).isInfinite()) continue;
                    val = new CFloatLiteralExpression(loc, simpleType, BigDecimal.valueOf(value));
                }
            } else {
                if (!(cType instanceof CEnumType)) continue;
                CEnumType enumType = (CEnumType)cType;
                Long value = num.getNumber().longValue();
                for (CEnumType.CEnumerator enumerator : enumType.getEnumerators()) {
                    if (enumerator.getValue() != value.longValue()) continue;
                    val = new CIdExpression(loc, enumerator);
                    break;
                }
                if (val == null) {
                    val = new CIntegerLiteralExpression(loc, enumType, BigInteger.valueOf(value));
                }
            }
            CBinaryExpression exp = builder.buildBinaryExpressionUnchecked(var, (CExpression)((Object)val), CBinaryExpression.BinaryOperator.EQUALS);
            result.add(LeafExpression.of(exp));
        }
        return factory.and(result);
    }

    public static class ValueAndType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Value value;
        private final Type type;

        public ValueAndType(Value pValue, Type pType) {
            this.value = (Value)Preconditions.checkNotNull((Object)pValue);
            this.type = pType;
        }

        public Value getValue() {
            return this.value;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValueAndType)) {
                return false;
            }
            ValueAndType other = (ValueAndType)o;
            return Objects.equals(this.value, other.value) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.type);
        }

        public String toString() {
            return String.format("%s (%s)", this.value, this.type);
        }
    }
}

