/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.APointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.ARightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerTransferRelation;
import org.sosy_lab.cpachecker.cpa.pointer2.util.ExplicitLocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSet;
import org.sosy_lab.cpachecker.cpa.rtt.NameProvider;
import org.sosy_lab.cpachecker.cpa.rtt.RTTState;
import org.sosy_lab.cpachecker.cpa.threading.ThreadingState;
import org.sosy_lab.cpachecker.cpa.value.AssigningValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitorWithPredefinedValues;
import org.sosy_lab.cpachecker.cpa.value.FunctionPointerExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.MissingInformation;
import org.sosy_lab.cpachecker.cpa.value.TestCompTestcaseLoader;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPAStatistics;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.ConstraintsStrengthenOperator;
import org.sosy_lab.cpachecker.cpa.value.type.ArrayValue;
import org.sosy_lab.cpachecker.cpa.value.type.BooleanValue;
import org.sosy_lab.cpachecker.cpa.value.type.NullValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.BuiltinFloatFunctions;
import org.sosy_lab.cpachecker.util.BuiltinOverflowFunctions;
import org.sosy_lab.cpachecker.util.CFAEdgeUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.states.MemoryLocationValueHandler;
import org.xml.sax.SAXException;

public class ValueAnalysisTransferRelation
extends ForwardingTransferRelation<ValueAnalysisState, ValueAnalysisState, VariableTrackingPrecision> {
    private static final ImmutableMap<String, String> UNSUPPORTED_FUNCTIONS = ImmutableMap.of();
    private static final AtomicInteger indexForNextRandomValue = new AtomicInteger();
    private final ValueTransferOptions options;
    private final @Nullable ValueAnalysisCPAStatistics stats;
    private final ConstraintsStrengthenOperator constraintsStrengthenOperator;
    private final Set<String> javaNonStaticVariables = new HashSet<String>();
    private JRightHandSide missingInformationRightJExpression = null;
    private String missingInformationLeftJVariable = null;
    private boolean missingFieldVariableObject;
    private Pair<String, Value> fieldNameAndInitialValue;
    private boolean missingScopedFieldName;
    private JIdExpression notScopedField;
    private Value notScopedFieldValue;
    private boolean missingAssumeInformation;
    private MemoryLocationValueHandler unknownValueHandler;
    private List<MissingInformation> missingInformationList;
    private ValueAnalysisState oldState;
    private final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;
    private final Collection<String> addressedVariables;
    private final Collection<String> booleanVariables;
    private Map<Integer, String> valuesFromFile;

    public ValueAnalysisTransferRelation(LogManager pLogger, CFA pCfa, ValueTransferOptions pOptions, MemoryLocationValueHandler pUnknownValueHandler, ConstraintsStrengthenOperator pConstraintsStrengthenOperator, @Nullable ValueAnalysisCPAStatistics pStats) {
        this.options = pOptions;
        this.machineModel = pCfa.getMachineModel();
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.stats = pStats;
        if (pCfa.getVarClassification().isPresent()) {
            this.addressedVariables = pCfa.getVarClassification().orElseThrow().getAddressedVariables();
            this.booleanVariables = pCfa.getVarClassification().orElseThrow().getIntBoolVars();
        } else {
            this.addressedVariables = ImmutableSet.of();
            this.booleanVariables = ImmutableSet.of();
        }
        this.unknownValueHandler = pUnknownValueHandler;
        this.constraintsStrengthenOperator = pConstraintsStrengthenOperator;
        if (this.options.isIgnoreFunctionValueExceptRandom() && this.options.isIgnoreFunctionValue() && this.options.getFunctionValuesForRandom() != null) {
            this.setupFunctionValuesForRandom();
        }
    }

    @Override
    protected Collection<ValueAnalysisState> postProcessing(ValueAnalysisState successor, CFAEdge edge) {
        if (successor != null) {
            successor = ValueAnalysisState.copyOf(successor);
        }
        return super.postProcessing(successor, edge);
    }

    @Override
    protected void setInfo(AbstractState pAbstractState, Precision pAbstractPrecision, CFAEdge pCfaEdge) {
        super.setInfo(pAbstractState, pAbstractPrecision, pCfaEdge);
        this.missingInformationList = new ArrayList<MissingInformation>(5);
        this.oldState = (ValueAnalysisState)pAbstractState;
        if (this.stats != null) {
            this.stats.incrementIterations();
        }
    }

    @Override
    protected ValueAnalysisState handleFunctionCallEdge(FunctionCallEdge callEdge, List<? extends AExpression> arguments, List<? extends AParameterDeclaration> parameters, String calledFunctionName) throws UnrecognizedCodeException {
        ValueAnalysisState newElement = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        assert (parameters.size() == arguments.size() || callEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs());
        ExpressionValueVisitor visitor = this.getVisitor();
        for (int i = 0; i < parameters.size(); ++i) {
            Value value;
            AExpression exp = arguments.get(i);
            if (exp instanceof JExpression) {
                value = ((JExpression)exp).accept(visitor);
            } else if (exp instanceof CExpression) {
                value = visitor.evaluate((CExpression)exp, (CType)parameters.get(i).getType());
            } else {
                throw new AssertionError((Object)("Unknown expression: " + exp));
            }
            AParameterDeclaration param = parameters.get(i);
            String paramName = param.getName();
            Type paramType = param.getType();
            MemoryLocation formalParamName = MemoryLocation.forLocalVariable(calledFunctionName, paramName);
            if (value.isUnknown()) {
                if (this.isMissingCExpressionInformation(visitor, exp)) {
                    this.addMissingInformation(formalParamName, exp);
                }
                this.unknownValueHandler.handle(formalParamName, paramType, newElement, visitor);
            } else {
                newElement.assignConstant(formalParamName, value, paramType);
            }
            visitor.reset();
        }
        return newElement;
    }

    @Override
    protected ValueAnalysisState handleBlankEdge(BlankEdge cfaEdge) {
        if (cfaEdge.getSuccessor() instanceof FunctionExitNode) {
            this.state = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
            ((ValueAnalysisState)this.state).dropFrame(this.functionName);
        }
        return (ValueAnalysisState)this.state;
    }

    @Override
    protected ValueAnalysisState handleReturnStatementEdge(AReturnStatementEdge returnEdge) throws UnrecognizedCodeException {
        ExpressionValueVisitor evv = this.getVisitor();
        this.state = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        ((ValueAnalysisState)this.state).dropFrame(this.functionName);
        AExpression expression = returnEdge.getExpression().orElse(null);
        if (expression == null && returnEdge instanceof CReturnStatementEdge) {
            expression = CIntegerLiteralExpression.ZERO;
        }
        FunctionEntryNode functionEntryNode = returnEdge.getSuccessor().getEntryNode();
        Optional<? extends AVariableDeclaration> optionalReturnVarDeclaration = functionEntryNode.getReturnVariable();
        MemoryLocation functionReturnVar = null;
        if (optionalReturnVarDeclaration.isPresent()) {
            functionReturnVar = MemoryLocation.forDeclaration(optionalReturnVarDeclaration.get());
        }
        if (expression != null && functionReturnVar != null) {
            Type functionReturnType = functionEntryNode.getFunctionDefinition().getType().getReturnType();
            return this.handleAssignmentToVariable(functionReturnVar, functionReturnType, expression, evv);
        }
        return (ValueAnalysisState)this.state;
    }

    @Override
    protected ValueAnalysisState handleFunctionReturnEdge(FunctionReturnEdge functionReturnEdge, FunctionSummaryEdge summaryEdge, AFunctionCall exprOnSummary, String callerFunctionName) throws UnrecognizedCodeException {
        ValueAnalysisState newElement = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        Optional<? extends AVariableDeclaration> returnVarName = functionReturnEdge.getFunctionEntry().getReturnVariable();
        MemoryLocation functionReturnVar = null;
        if (returnVarName.isPresent()) {
            functionReturnVar = MemoryLocation.forDeclaration(returnVarName.get());
        }
        if (exprOnSummary instanceof AFunctionCallAssignmentStatement) {
            boolean valueExists;
            AFunctionCallAssignmentStatement assignExp = (AFunctionCallAssignmentStatement)exprOnSummary;
            ALeftHandSide op1 = assignExp.getLeftHandSide();
            ExpressionValueVisitor v = this.getVisitor(newElement, callerFunctionName);
            Value newValue = null;
            boolean bl = valueExists = returnVarName.isPresent() && ((ValueAnalysisState)this.state).contains(functionReturnVar);
            if (valueExists) {
                newValue = ((ValueAnalysisState)this.state).getValueFor(functionReturnVar);
            }
            if (op1 instanceof JArraySubscriptExpression) {
                JArraySubscriptExpression arraySubscriptExpression = (JArraySubscriptExpression)op1;
                ArrayValue assignedArray = this.getInnerMostArray(arraySubscriptExpression);
                OptionalInt maybeIndex = this.getIndex(arraySubscriptExpression);
                if (maybeIndex.isPresent() && assignedArray != null && valueExists) {
                    assignedArray.setValue(newValue, maybeIndex.orElseThrow());
                } else {
                    this.assignUnknownValueToEnclosingInstanceOfArray(arraySubscriptExpression);
                }
            } else {
                Optional<Object> memLoc = Optional.empty();
                if (op1 instanceof CLeftHandSide) {
                    memLoc = valueExists ? this.getMemoryLocation((CLeftHandSide)op1, newValue, v) : this.getMemoryLocation((CLeftHandSide)op1, Value.UnknownValue.getInstance(), v);
                } else if (op1 instanceof AIdExpression) {
                    if (op1 instanceof JIdExpression && this.isDynamicField((JIdExpression)op1) && valueExists) {
                        this.missingScopedFieldName = true;
                        this.notScopedField = (JIdExpression)op1;
                        this.notScopedFieldValue = newValue;
                    } else {
                        memLoc = Optional.of(MemoryLocation.forDeclaration(((AIdExpression)op1).getDeclaration()));
                    }
                } else if (!(op1 instanceof APointerExpression)) {
                    throw new UnrecognizedCodeException("on function return", summaryEdge, op1);
                }
                if (memLoc.isPresent()) {
                    if (!valueExists) {
                        this.unknownValueHandler.handle((MemoryLocation)memLoc.orElseThrow(), op1.getExpressionType(), newElement, v);
                    } else {
                        newElement.assignConstant((MemoryLocation)memLoc.orElseThrow(), newValue, ((ValueAnalysisState)this.state).getTypeForMemoryLocation(functionReturnVar));
                    }
                }
            }
        }
        if (returnVarName.isPresent()) {
            newElement.forget(functionReturnVar);
        }
        return newElement;
    }

    private Optional<MemoryLocation> getMemoryLocation(CLeftHandSide pExpression, Value pRightHandSideValue, ExpressionValueVisitor pValueVisitor) throws UnrecognizedCodeException {
        MemoryLocation assignedVarName = pValueVisitor.evaluateMemoryLocation(pExpression);
        if (assignedVarName == null) {
            if (pValueVisitor.hasMissingPointer()) {
                this.addMissingInformation(pExpression, pRightHandSideValue);
            }
            return Optional.empty();
        }
        return Optional.of(assignedVarName);
    }

    private boolean isDynamicField(JIdExpression pIdentifier) {
        JSimpleDeclaration declaration = pIdentifier.getDeclaration();
        return declaration instanceof JFieldDeclaration && !((JFieldDeclaration)declaration).isStatic();
    }

    private OptionalInt getIndex(JArraySubscriptExpression pExpression) {
        ExpressionValueVisitor evv = this.getVisitor();
        Value indexValue = pExpression.getSubscriptExpression().accept(evv);
        if (indexValue.isUnknown()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of((int)((NumericValue)indexValue).longValue());
    }

    @Override
    protected ValueAnalysisState handleFunctionSummaryEdge(CFunctionSummaryEdge cfaEdge) throws CPATransferException {
        MemoryLocation assignedMemoryLocation;
        AFunctionCallAssignmentStatement assignment;
        ALeftHandSide leftHandSide;
        ValueAnalysisState newState = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        CFunctionCall functionCall = cfaEdge.getExpression();
        if (functionCall instanceof AFunctionCallAssignmentStatement && (leftHandSide = (assignment = (AFunctionCallAssignmentStatement)((Object)functionCall)).getLeftHandSide()) instanceof CLeftHandSide && newState.contains(assignedMemoryLocation = this.getVisitor().evaluateMemoryLocation((CLeftHandSide)leftHandSide))) {
            newState.forget(assignedMemoryLocation);
        }
        return newState;
    }

    @Override
    protected ValueAnalysisState handleAssumption(AssumeEdge cfaEdge, AExpression expression, boolean truthValue) throws UnrecognizedCodeException {
        return this.handleAssumption(expression, truthValue);
    }

    private ValueAnalysisState handleAssumption(AExpression expression, boolean truthValue) throws UnrecognizedCodeException {
        if (this.stats != null) {
            this.stats.incrementAssumptions();
        }
        Pair<AExpression, Boolean> simplifiedExpression = ValueAnalysisTransferRelation.simplifyAssumption(expression, truthValue);
        expression = simplifiedExpression.getFirst();
        truthValue = simplifiedExpression.getSecond();
        ExpressionValueVisitor evv = this.getVisitor();
        Type booleanType = this.getBooleanType(expression);
        Value value = this.getExpressionValue(expression, booleanType, evv);
        if (value.isExplicitlyKnown() && this.stats != null) {
            this.stats.incrementDeterministicAssumptions();
        }
        if (!value.isExplicitlyKnown()) {
            ValueAnalysisState element = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
            AssigningValueVisitor avv = new AssigningValueVisitor(element, truthValue, this.booleanVariables, this.functionName, (ValueAnalysisState)this.state, this.machineModel, this.logger, this.options);
            if (expression instanceof JExpression && !(expression instanceof CExpression)) {
                ((JExpression)expression).accept(avv);
                if (avv.hasMissingFieldAccessInformation()) {
                    assert (this.missingInformationRightJExpression != null);
                    this.missingAssumeInformation = true;
                }
            } else {
                ((CExpression)expression).accept(avv);
            }
            if (this.isMissingCExpressionInformation(evv, expression)) {
                this.missingInformationList.add(new MissingInformation(truthValue, (ARightHandSide)expression));
            }
            return element;
        }
        if (this.representsBoolean(value, truthValue)) {
            return ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        }
        return null;
    }

    private Type getBooleanType(AExpression pExpression) {
        if (pExpression instanceof JExpression) {
            return JSimpleType.getBoolean();
        }
        if (pExpression instanceof CExpression) {
            return CNumericTypes.INT;
        }
        throw new AssertionError((Object)("Unhandled expression type " + pExpression.getClass()));
    }

    private boolean representsBoolean(Value value, boolean bool) {
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isTrue() == bool;
        }
        if (value.isNumericValue()) {
            return value.equals(new NumericValue(bool ? 1L : 0L));
        }
        return false;
    }

    @Override
    protected ValueAnalysisState handleDeclarationEdge(ADeclarationEdge declarationEdge, ADeclaration declaration) throws UnrecognizedCodeException {
        if (!(declaration instanceof AVariableDeclaration) || !this.isTrackedType(declaration.getType())) {
            return (ValueAnalysisState)this.state;
        }
        ValueAnalysisState newElement = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        AVariableDeclaration decl = (AVariableDeclaration)declaration;
        Type declarationType = decl.getType();
        String varName = decl.getName();
        Value initialValue = this.getDefaultInitialValue(decl);
        AInitializer init = decl.getInitializer();
        if (decl.isGlobal() && decl instanceof JFieldDeclaration && !((JFieldDeclaration)decl).isStatic()) {
            this.missingFieldVariableObject = true;
            this.javaNonStaticVariables.add(varName);
        }
        MemoryLocation memoryLocation = decl.isGlobal() ? MemoryLocation.forIdentifier(varName) : MemoryLocation.forLocalVariable(this.functionName, varName);
        if (this.addressedVariables.contains(decl.getQualifiedName()) && declarationType instanceof CType) {
            ValueAnalysisState.addToBlacklist(memoryLocation);
        }
        if (init instanceof AInitializerExpression) {
            ExpressionValueVisitor evv = this.getVisitor();
            AExpression exp = ((AInitializerExpression)init).getExpression();
            initialValue = this.getExpressionValue(exp, declarationType, evv);
            if (this.isMissingCExpressionInformation(evv, exp)) {
                this.addMissingInformation(memoryLocation, exp);
            }
        }
        if (this.isTrackedType(declarationType)) {
            if (this.missingFieldVariableObject) {
                this.fieldNameAndInitialValue = Pair.of(varName, initialValue);
            } else if (this.missingInformationRightJExpression != null) {
                this.missingInformationLeftJVariable = memoryLocation.getExtendedQualifiedName();
            }
        } else {
            this.missingFieldVariableObject = false;
        }
        if (initialValue.isUnknown()) {
            this.unknownValueHandler.handle(memoryLocation, declarationType, newElement, this.getVisitor());
        } else {
            newElement.assignConstant(memoryLocation, initialValue, declarationType);
        }
        return newElement;
    }

    private Value getDefaultInitialValue(AVariableDeclaration pDeclaration) {
        boolean defaultBooleanValue = false;
        long defaultNumericValue = 0L;
        if (pDeclaration.isGlobal()) {
            Type declarationType = pDeclaration.getType();
            if (this.isComplexJavaType(declarationType)) {
                return NullValue.getInstance();
            }
            if (declarationType instanceof JSimpleType) {
                JBasicType basicType = ((JSimpleType)declarationType).getType();
                switch (basicType) {
                    case BOOLEAN: {
                        return BooleanValue.valueOf(false);
                    }
                    case BYTE: 
                    case CHAR: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return new NumericValue(0L);
                    }
                    case UNSPECIFIED: {
                        return Value.UnknownValue.getInstance();
                    }
                }
                throw new AssertionError((Object)("Impossible type for declaration: " + basicType));
            }
        }
        return Value.UnknownValue.getInstance();
    }

    private boolean isComplexJavaType(Type pType) {
        return pType instanceof JClassOrInterfaceType || pType instanceof JArrayType;
    }

    private boolean isMissingCExpressionInformation(ExpressionValueVisitor pEvv, ARightHandSide pExp) {
        return pExp instanceof CExpression && pEvv.hasMissingPointer();
    }

    @Override
    protected ValueAnalysisState handleStatementEdge(AStatementEdge cfaEdge, AStatement expression) throws UnrecognizedCodeException {
        CFunctionCall functionCall;
        CFunctionCallExpression functionCallExp;
        CExpression fn;
        if (expression instanceof CFunctionCall && (fn = (functionCallExp = (functionCall = (CFunctionCall)expression).getFunctionCallExpression()).getFunctionNameExpression()) instanceof CIdExpression) {
            String func = ((CIdExpression)fn).getName();
            if (UNSUPPORTED_FUNCTIONS.containsKey((Object)func)) {
                if (!this.options.isAllowedUnsupportedOption(func)) {
                    throw new UnsupportedCodeException((String)UNSUPPORTED_FUNCTIONS.get((Object)func), cfaEdge, fn);
                }
            } else {
                if (func.equals("free")) {
                    return this.handleCallToFree(functionCall);
                }
                if (BuiltinOverflowFunctions.isBuiltinOverflowFunction(func)) {
                    if (!BuiltinOverflowFunctions.isFunctionWithoutSideEffect(func) && !this.options.isAllowedUnsupportedOption(func)) {
                        throw new UnsupportedCodeException(func + " is unsupported for this analysis", null);
                    }
                } else if (expression instanceof CFunctionCallAssignmentStatement) {
                    return this.handleFunctionAssignment((CFunctionCallAssignmentStatement)expression);
                }
            }
        }
        if (expression instanceof AAssignment) {
            return this.handleAssignment((AAssignment)((Object)expression), cfaEdge);
        }
        if (!(expression instanceof AFunctionCallStatement) && !(expression instanceof AExpressionStatement)) {
            throw new UnrecognizedCodeException("Unknown statement", cfaEdge, expression);
        }
        return (ValueAnalysisState)this.state;
    }

    private ValueAnalysisState handleFunctionAssignment(CFunctionCallAssignmentStatement pFunctionCallAssignment) throws UnrecognizedCodeException {
        CFunctionCallExpression functionCallExp = pFunctionCallAssignment.getFunctionCallExpression();
        CLeftHandSide leftSide = pFunctionCallAssignment.getLeftHandSide();
        CType leftSideType = leftSide.getExpressionType();
        ExpressionValueVisitor evv = this.getVisitor();
        ValueAnalysisState newElement = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        Value newValue = evv.evaluate(functionCallExp, leftSideType);
        Optional<MemoryLocation> memLoc = this.getMemoryLocation(leftSide, newValue, evv);
        if (memLoc.isPresent()) {
            if (!newValue.isUnknown()) {
                newElement.assignConstant(memLoc.orElseThrow(), newValue, leftSideType);
            } else {
                this.unknownValueHandler.handle(memLoc.orElseThrow(), leftSideType, newElement, evv);
            }
        }
        return newElement;
    }

    private ValueAnalysisState handleCallToFree(CFunctionCall pExpression) {
        this.missingInformationList.add(new MissingInformation(pExpression.getFunctionCallExpression()));
        return (ValueAnalysisState)this.state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ValueAnalysisState handleAssignment(AAssignment assignExpression, CFAEdge cfaEdge) throws UnrecognizedCodeException {
        ALeftHandSide op1 = assignExpression.getLeftHandSide();
        ARightHandSide op2 = assignExpression.getRightHandSide();
        if (!this.isTrackedType(op1.getExpressionType())) {
            return (ValueAnalysisState)this.state;
        }
        if (op1 instanceof AIdExpression) {
            if (op1 instanceof JIdExpression && this.isDynamicField((JIdExpression)op1)) {
                this.missingScopedFieldName = true;
                this.notScopedField = (JIdExpression)op1;
            }
            MemoryLocation memloc = this.getMemoryLocation((AIdExpression)op1);
            return this.handleAssignmentToVariable(memloc, op1.getExpressionType(), op2, this.getVisitor());
        }
        if (op1 instanceof APointerExpression) {
            if (!this.isRelevant(op1, op2)) return (ValueAnalysisState)this.state;
            this.missingInformationList.add(new MissingInformation(op1, op2));
            return (ValueAnalysisState)this.state;
        } else {
            if (op1 instanceof CFieldReference) {
                ExpressionValueVisitor v = this.getVisitor();
                MemoryLocation memLoc = v.evaluateMemoryLocation((CFieldReference)op1);
                if (v.hasMissingPointer() && this.isRelevant(op1, op2)) {
                    this.missingInformationList.add(new MissingInformation(op1, op2));
                }
                if (memLoc == null) return (ValueAnalysisState)this.state;
                return this.handleAssignmentToVariable(memLoc, op1.getExpressionType(), op2, v);
            }
            if (!(op1 instanceof AArraySubscriptExpression)) throw new UnrecognizedCodeException("left operand of assignment has to be a variable", cfaEdge, op1);
            if (op1 instanceof CArraySubscriptExpression) {
                ExpressionValueVisitor v = this.getVisitor();
                MemoryLocation memLoc = v.evaluateMemoryLocation((CLeftHandSide)op1);
                if (v.hasMissingPointer() && this.isRelevant(op1, op2)) {
                    this.missingInformationList.add(new MissingInformation(op1, op2));
                }
                if (memLoc == null) return (ValueAnalysisState)this.state;
                return this.handleAssignmentToVariable(memLoc, op1.getExpressionType(), op2, v);
            }
            if (!(op1 instanceof JArraySubscriptExpression)) return (ValueAnalysisState)this.state;
            JArraySubscriptExpression arrayExpression = (JArraySubscriptExpression)op1;
            ExpressionValueVisitor evv = this.getVisitor();
            ArrayValue arrayToChange = this.getInnerMostArray(arrayExpression);
            Value maybeIndex = arrayExpression.getSubscriptExpression().accept(evv);
            if (arrayToChange == null || maybeIndex.isUnknown()) {
                this.assignUnknownValueToEnclosingInstanceOfArray(arrayExpression);
                return (ValueAnalysisState)this.state;
            } else {
                long concreteIndex = ((NumericValue)maybeIndex).longValue();
                int arraySize = arrayToChange.getArraySize();
                if (concreteIndex < 0L || concreteIndex >= (long)arraySize) {
                    JArrayType arrayType = arrayToChange.getArrayType();
                    throw new UnrecognizedCodeException("Invalid index " + concreteIndex + " for array type " + arrayType + "with array size " + arraySize, cfaEdge);
                }
                this.handleAssignmentToArray(arrayToChange, (int)concreteIndex, op2);
                return ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
            }
        }
    }

    private boolean isTrackedType(Type pType) {
        return !(pType instanceof JType) || this.options.trackJavaArrayValues || !(pType instanceof JArrayType);
    }

    private MemoryLocation getMemoryLocation(AIdExpression pIdExpression) {
        String varName = pIdExpression.getName();
        if (ValueAnalysisTransferRelation.isGlobal(pIdExpression)) {
            return MemoryLocation.parseExtendedQualifiedName(varName);
        }
        return MemoryLocation.forLocalVariable(this.functionName, varName);
    }

    private boolean isRelevant(AExpression pOp1, ARightHandSide pOp2) {
        return pOp1 instanceof CExpression && pOp2 instanceof CExpression;
    }

    private ValueAnalysisState handleAssignmentToVariable(MemoryLocation assignedVar, Type lType, ARightHandSide exp, ExpressionValueVisitor visitor) throws UnrecognizedCodeException {
        ValueAnalysisState newElement = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        this.handleAssignmentToVariable(newElement, assignedVar, lType, exp, visitor);
        return newElement;
    }

    private void handleAssignmentToVariable(ValueAnalysisState newElement, MemoryLocation assignedVar, Type lType, ARightHandSide exp, ExpressionValueVisitor visitor) throws UnrecognizedCodeException {
        Value value;
        CType canonicaltype;
        if (lType instanceof CType && (canonicaltype = ((CType)lType).getCanonicalType()) instanceof CCompositeType && ((CCompositeType)canonicaltype).getKind() == CComplexType.ComplexTypeKind.STRUCT && exp instanceof CLeftHandSide) {
            this.handleAssignmentToStruct(newElement, assignedVar, (CCompositeType)canonicaltype, (CExpression)exp, visitor);
            return;
        }
        if (exp instanceof JRightHandSide) {
            value = visitor.evaluate((JRightHandSide)exp, (JType)lType);
        } else if (exp instanceof CRightHandSide) {
            value = visitor.evaluate((CRightHandSide)exp, (CType)lType);
        } else {
            throw new AssertionError((Object)("unknown righthandside-expression: " + exp));
        }
        if (visitor.hasMissingPointer()) assert (!value.isExplicitlyKnown());
        if (this.isMissingCExpressionInformation(visitor, exp)) {
            this.addMissingInformation(assignedVar, exp);
        }
        if (visitor.hasMissingFieldAccessInformation()) {
            if (!value.isUnknown()) {
                newElement.forget(assignedVar);
                return;
            }
            this.missingInformationRightJExpression = (JRightHandSide)exp;
            if (!this.missingScopedFieldName) {
                this.missingInformationLeftJVariable = assignedVar.getExtendedQualifiedName();
            }
        }
        if (this.missingScopedFieldName) {
            this.notScopedFieldValue = value;
        } else if (value.isUnknown()) {
            this.unknownValueHandler.handle(assignedVar, lType, newElement, visitor);
        } else {
            newElement.assignConstant(assignedVar, value, lType);
        }
    }

    private void handleAssignmentToStruct(ValueAnalysisState pNewElement, MemoryLocation pAssignedVar, CCompositeType pLType, CExpression pExp, ExpressionValueVisitor pVisitor) throws UnrecognizedCodeException {
        long offset = 0L;
        for (CCompositeType.CCompositeTypeMemberDeclaration memberType : pLType.getMembers()) {
            MemoryLocation assignedField = this.createFieldMemoryLocation(pAssignedVar, offset);
            CExpression owner = pExp;
            CFieldReference fieldReference = new CFieldReference(pExp.getFileLocation(), memberType.getType(), memberType.getName(), owner, false);
            this.handleAssignmentToVariable(pNewElement, assignedField, memberType.getType(), fieldReference, pVisitor);
            offset += this.machineModel.getSizeof(memberType.getType()).longValueExact();
        }
    }

    private MemoryLocation createFieldMemoryLocation(MemoryLocation pStruct, long pOffset) {
        return pStruct.withAddedOffset(pOffset);
    }

    private void addMissingInformation(MemoryLocation pMemLoc, ARightHandSide pExp) {
        if (pExp instanceof CExpression) {
            this.missingInformationList.add(new MissingInformation(pMemLoc, (CExpression)pExp));
        }
    }

    private void addMissingInformation(CLeftHandSide pOp1, Value pValue) {
        this.missingInformationList.add(new MissingInformation((CExpression)pOp1, pValue));
    }

    private @Nullable ArrayValue getInnerMostArray(JArraySubscriptExpression pArraySubscriptExpression) {
        JExpression arrayExpression = pArraySubscriptExpression.getArrayExpression();
        if (arrayExpression instanceof JIdExpression) {
            Value idValue;
            MemoryLocation idName;
            JSimpleDeclaration arrayDeclaration = ((JIdExpression)arrayExpression).getDeclaration();
            if (arrayDeclaration != null && ((ValueAnalysisState)this.state).contains(idName = MemoryLocation.forDeclaration(arrayDeclaration)) && (idValue = ((ValueAnalysisState)this.state).getValueFor(idName)).isExplicitlyKnown()) {
                return (ArrayValue)idValue;
            }
            return null;
        }
        JArraySubscriptExpression arraySubscriptExpression = (JArraySubscriptExpression)arrayExpression;
        ArrayValue enclosingArray = this.getInnerMostArray(arraySubscriptExpression);
        OptionalInt maybeIndex = this.getIndex(arraySubscriptExpression);
        if (!maybeIndex.isPresent() || enclosingArray == null) {
            return null;
        }
        int index = maybeIndex.orElseThrow();
        if (index >= enclosingArray.getArraySize() || index < 0) {
            return null;
        }
        return (ArrayValue)enclosingArray.getValueAt(index);
    }

    private void handleAssignmentToArray(ArrayValue pArray, int index, ARightHandSide exp) {
        assert (exp instanceof JExpression);
        pArray.setValue(((JExpression)exp).accept(this.getVisitor()), index);
    }

    private void assignUnknownValueToEnclosingInstanceOfArray(JArraySubscriptExpression pArraySubscriptExpression) {
        JExpression enclosingExpression = pArraySubscriptExpression.getArrayExpression();
        if (enclosingExpression instanceof JIdExpression) {
            JIdExpression idExpression = (JIdExpression)enclosingExpression;
            MemoryLocation memLoc = this.getMemoryLocation(idExpression);
            Value.UnknownValue unknownValue = Value.UnknownValue.getInstance();
            ((ValueAnalysisState)this.state).assignConstant(memLoc, (Value)unknownValue, JSimpleType.getUnspecified());
        } else {
            JArraySubscriptExpression enclosingSubscriptExpression = (JArraySubscriptExpression)enclosingExpression;
            ArrayValue enclosingArray = this.getInnerMostArray(enclosingSubscriptExpression);
            OptionalInt maybeIndex = this.getIndex(enclosingSubscriptExpression);
            if (maybeIndex.isPresent() && enclosingArray != null) {
                enclosingArray.setValue(Value.UnknownValue.getInstance(), maybeIndex.orElseThrow());
            } else {
                this.assignUnknownValueToEnclosingInstanceOfArray(enclosingSubscriptExpression);
            }
        }
    }

    private Value getExpressionValue(AExpression expression, Type type, ExpressionValueVisitor evv) throws UnrecognizedCodeException {
        if (!this.isTrackedType(type)) {
            return Value.UnknownValue.getInstance();
        }
        if (expression instanceof JRightHandSide) {
            Value value = evv.evaluate((JRightHandSide)((Object)expression), (JType)type);
            if (evv.hasMissingFieldAccessInformation()) {
                this.missingInformationRightJExpression = (JRightHandSide)((Object)expression);
                return Value.UnknownValue.getInstance();
            }
            return value;
        }
        if (expression instanceof CRightHandSide) {
            return evv.evaluate((CRightHandSide)((Object)expression), (CType)type);
        }
        throw new AssertionError((Object)("unhandled righthandside-expression: " + expression));
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, Iterable<AbstractState> pElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException {
        assert (pElement instanceof ValueAnalysisState);
        ArrayList<ValueAnalysisState> toStrengthen = new ArrayList<ValueAnalysisState>();
        ArrayList<ValueAnalysisState> result = new ArrayList<ValueAnalysisState>();
        toStrengthen.add((ValueAnalysisState)pElement);
        result.add((ValueAnalysisState)pElement);
        for (AbstractState ae : pElements) {
            Collection<ValueAnalysisState> ret;
            if (ae instanceof RTTState) {
                result.clear();
                for (ValueAnalysisState stateToStrengthen : toStrengthen) {
                    super.setInfo(pElement, pPrecision, pCfaEdge);
                    ret = this.strengthen((RTTState)ae, pCfaEdge);
                    if (ret == null) {
                        result.add(stateToStrengthen);
                        continue;
                    }
                    result.addAll(ret);
                }
                toStrengthen.clear();
                toStrengthen.addAll(result);
                continue;
            }
            if (ae instanceof AbstractStateWithAssumptions) {
                result.clear();
                for (ValueAnalysisState stateToStrengthen : toStrengthen) {
                    super.setInfo(pElement, pPrecision, pCfaEdge);
                    AbstractStateWithAssumptions stateWithAssumptions = (AbstractStateWithAssumptions)ae;
                    result.addAll(this.strengthenWithAssumptions(stateWithAssumptions, stateToStrengthen, pCfaEdge));
                }
                toStrengthen.clear();
                toStrengthen.addAll(result);
                continue;
            }
            if (ae instanceof ThreadingState) {
                result.clear();
                for (ValueAnalysisState stateToStrengthen : toStrengthen) {
                    super.setInfo(pElement, pPrecision, pCfaEdge);
                    result.add(this.strengthenWithThreads((ThreadingState)ae, stateToStrengthen));
                }
                toStrengthen.clear();
                toStrengthen.addAll(result);
                continue;
            }
            if (ae instanceof ConstraintsState) {
                result.clear();
                for (ValueAnalysisState stateToStrengthen : toStrengthen) {
                    super.setInfo(pElement, pPrecision, pCfaEdge);
                    ret = this.constraintsStrengthenOperator.strengthen((ValueAnalysisState)pElement, (ConstraintsState)ae, pCfaEdge);
                    if (ret == null) {
                        result.add(stateToStrengthen);
                        continue;
                    }
                    result.addAll(ret);
                }
                toStrengthen.clear();
                toStrengthen.addAll(result);
                continue;
            }
            if (!(ae instanceof PointerState)) continue;
            CFAEdge edge = pCfaEdge;
            CRightHandSide rightHandSide = CFAEdgeUtils.getRightHandSide(edge);
            ALeftHandSide leftHandSide = CFAEdgeUtils.getLeftHandSide(edge);
            Type leftHandType = CFAEdgeUtils.getLeftHandType(edge);
            String leftHandVariable = CFAEdgeUtils.getLeftHandVariable(edge);
            PointerState pointerState = (PointerState)ae;
            result.clear();
            for (ValueAnalysisState stateToStrengthen : toStrengthen) {
                super.setInfo(pElement, pPrecision, pCfaEdge);
                ValueAnalysisState newState = this.strengthenWithPointerInformation(stateToStrengthen, pointerState, rightHandSide, leftHandType, leftHandSide, leftHandVariable, Value.UnknownValue.getInstance());
                newState = this.handleModf(rightHandSide, pointerState, newState);
                result.add(newState);
            }
            toStrengthen.clear();
            toStrengthen.addAll(result);
        }
        ArrayList<AbstractState> postProcessedResult = new ArrayList<AbstractState>(result.size());
        for (ValueAnalysisState rawResult : result) {
            if (rawResult == pElement) {
                postProcessedResult.add(pElement);
                continue;
            }
            postProcessedResult.addAll(this.postProcessing(rawResult, pCfaEdge));
        }
        super.resetInfo();
        this.oldState = null;
        return postProcessedResult;
    }

    private ValueAnalysisState handleModf(ARightHandSide pRightHandSide, PointerState pPointerState, ValueAnalysisState pState) throws UnrecognizedCodeException, AssertionError {
        List<? extends AExpression> parameters;
        String nameOfCalledFunc;
        AFunctionCallExpression functionCallExpression;
        AExpression nameExpressionOfCalledFunc;
        ValueAnalysisState newState = pState;
        if (pRightHandSide instanceof AFunctionCallExpression && (nameExpressionOfCalledFunc = (functionCallExpression = (AFunctionCallExpression)pRightHandSide).getFunctionNameExpression()) instanceof AIdExpression && BuiltinFloatFunctions.matchesModf(nameOfCalledFunc = ((AIdExpression)nameExpressionOfCalledFunc).getName()) && (parameters = functionCallExpression.getParameterExpressions()).size() == 2 && parameters.get(1) instanceof CExpression) {
            Value value;
            AExpression exp = parameters.get(0);
            CExpression targetPointer = (CExpression)parameters.get(1);
            CPointerExpression target = new CPointerExpression(targetPointer.getFileLocation(), targetPointer.getExpressionType(), targetPointer);
            ExpressionValueVisitor evv = this.getVisitor();
            if (exp instanceof JRightHandSide) {
                value = evv.evaluate((JRightHandSide)((Object)exp), (JType)exp.getExpressionType());
            } else if (exp instanceof CRightHandSide) {
                value = evv.evaluate((CRightHandSide)((Object)exp), (CType)exp.getExpressionType());
            } else {
                throw new AssertionError((Object)("unknown righthandside-expression: " + exp));
            }
            if (value.isExplicitlyKnown()) {
                NumericValue numericValue = value.asNumericValue();
                CSimpleType paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(nameOfCalledFunc);
                if (ImmutableList.of((Object)((Object)CBasicType.FLOAT), (Object)((Object)CBasicType.DOUBLE)).contains((Object)paramType.getType())) {
                    BigDecimal integralPartValue;
                    switch (paramType.getType()) {
                        case FLOAT: {
                            integralPartValue = BigDecimal.valueOf((double)((long)numericValue.floatValue()));
                            break;
                        }
                        case DOUBLE: {
                            integralPartValue = BigDecimal.valueOf((double)((long)numericValue.doubleValue()));
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unsupported float type: " + paramType));
                        }
                    }
                    CFloatLiteralExpression integralPart = new CFloatLiteralExpression(functionCallExpression.getFileLocation(), paramType, integralPartValue);
                    newState = this.strengthenWithPointerInformation(newState, pPointerState, integralPart, target.getExpressionType(), target, null, new NumericValue(integralPartValue));
                }
            }
        }
        return newState;
    }

    private ValueAnalysisState strengthenWithPointerInformation(ValueAnalysisState pValueState, PointerState pPointerInfo, ARightHandSide pRightHandSide, Type pTargetType, ALeftHandSide pLeftHandSide, String pLeftHandVariable, Value pValue) throws UnrecognizedCodeException {
        ValueAnalysisState newState = pValueState;
        Value value = pValue;
        MemoryLocation target = null;
        if (pLeftHandVariable != null) {
            target = MemoryLocation.parseExtendedQualifiedName(pLeftHandVariable);
        }
        Type type = pTargetType;
        boolean shouldAssign = false;
        if (target == null && pLeftHandSide instanceof CPointerExpression) {
            ExplicitLocationSet explicitSet;
            CExpression addressExpression;
            LocationSet indirectLocation;
            CPointerExpression pointerExpression = (CPointerExpression)pLeftHandSide;
            LocationSet directLocation = PointerTransferRelation.asLocations(pointerExpression, pPointerInfo);
            if (!(directLocation instanceof ExplicitLocationSet) && (indirectLocation = PointerTransferRelation.asLocations(addressExpression = pointerExpression.getOperand(), pPointerInfo)) instanceof ExplicitLocationSet && (explicitSet = (ExplicitLocationSet)indirectLocation).getSize() == 1) {
                MemoryLocation variable = explicitSet.iterator().next();
                directLocation = pPointerInfo.getPointsToSet(variable);
            }
            if (directLocation instanceof ExplicitLocationSet) {
                ExplicitLocationSet explicitDirectLocation = (ExplicitLocationSet)directLocation;
                Iterator<MemoryLocation> locationIterator = explicitDirectLocation.iterator();
                MemoryLocation otherVariable = locationIterator.next();
                if (!locationIterator.hasNext()) {
                    target = otherVariable;
                    if (type == null && pValueState.contains(target)) {
                        type = pValueState.getTypeForMemoryLocation(target);
                    }
                    shouldAssign = true;
                }
            }
        }
        if (!value.isExplicitlyKnown() && pRightHandSide instanceof CPointerExpression) {
            ExplicitLocationSet explicitSet;
            if (target == null) {
                return pValueState;
            }
            CPointerExpression rhs = (CPointerExpression)pRightHandSide;
            CExpression addressExpression = rhs.getOperand();
            LocationSet fullSet = PointerTransferRelation.asLocations(addressExpression, pPointerInfo);
            if (fullSet instanceof ExplicitLocationSet && (explicitSet = (ExplicitLocationSet)fullSet).getSize() == 1) {
                MemoryLocation variable = explicitSet.iterator().next();
                CType variableType = rhs.getExpressionType().getCanonicalType();
                LocationSet pointsToSet = pPointerInfo.getPointsToSet(variable);
                if (pointsToSet instanceof ExplicitLocationSet) {
                    Value otherVariableValue;
                    ValueAnalysisState.ValueAndType valueAndType;
                    Type otherVariableType;
                    ExplicitLocationSet explicitPointsToSet = (ExplicitLocationSet)pointsToSet;
                    Iterator<MemoryLocation> pointsToIterator = explicitPointsToSet.iterator();
                    MemoryLocation otherVariableLocation = pointsToIterator.next();
                    if (!pointsToIterator.hasNext() && pValueState.contains(otherVariableLocation) && (otherVariableType = (valueAndType = pValueState.getValueAndTypeFor(otherVariableLocation)).getType()) != null && (otherVariableValue = valueAndType.getValue()) != null && (variableType.equals(otherVariableType) || variableType.equals(CNumericTypes.FLOAT) && otherVariableType.equals(CNumericTypes.UNSIGNED_INT) && otherVariableValue.isExplicitlyKnown() && Long.valueOf(0L).equals(otherVariableValue.asLong(CNumericTypes.UNSIGNED_INT)))) {
                        value = otherVariableValue;
                        shouldAssign = true;
                    }
                }
            }
        }
        if (target != null && type != null && shouldAssign) {
            newState = ValueAnalysisState.copyOf(pValueState);
            newState.assignConstant(target, value, type);
        }
        return newState;
    }

    private @NonNull Collection<ValueAnalysisState> strengthenWithAssumptions(AbstractStateWithAssumptions pStateWithAssumptions, ValueAnalysisState pState, CFAEdge pCfaEdge) throws CPATransferException {
        AExpression assumption;
        ValueAnalysisState newState = pState;
        Iterator<? extends AExpression> iterator = pStateWithAssumptions.getAssumptions().iterator();
        while (iterator.hasNext() && (newState = this.handleAssumption(assumption = iterator.next(), true)) != null) {
            this.setInfo(newState, this.precision, pCfaEdge);
        }
        if (newState == null) {
            return ImmutableList.of();
        }
        return Collections.singleton(newState);
    }

    private @NonNull ValueAnalysisState strengthenWithThreads(ThreadingState pThreadingState, ValueAnalysisState pState) throws CPATransferException {
        FunctionCallEdge function = pThreadingState.getEntryFunction();
        if (function == null) {
            return pState;
        }
        FunctionEntryNode succ = function.getSuccessor();
        String calledFunctionName = succ.getFunctionName();
        return this.handleFunctionCallEdge(function, (List)function.getArguments(), (List)succ.getFunctionParameters(), calledFunctionName);
    }

    private Collection<ValueAnalysisState> strengthen(RTTState rttState, CFAEdge edge) {
        ValueAnalysisState newElement = ValueAnalysisState.copyOf(this.oldState);
        if (this.missingFieldVariableObject) {
            newElement.assignConstant(this.getRTTScopedVariableName(this.fieldNameAndInitialValue.getFirst(), rttState.getKeywordThisUniqueObject()), this.fieldNameAndInitialValue.getSecond());
            this.missingFieldVariableObject = false;
            this.fieldNameAndInitialValue = null;
            return Collections.singleton(newElement);
        }
        if (this.missingScopedFieldName) {
            newElement = this.handleNotScopedVariable(rttState, newElement);
            this.missingScopedFieldName = false;
            this.notScopedField = null;
            this.notScopedFieldValue = null;
            this.missingInformationRightJExpression = null;
            if (newElement != null) {
                return Collections.singleton(newElement);
            }
            return null;
        }
        if (this.missingAssumeInformation && this.missingInformationRightJExpression != null) {
            Value value = this.handleMissingInformationRightJExpression(rttState);
            this.missingAssumeInformation = false;
            this.missingInformationRightJExpression = null;
            boolean truthAssumption = ((AssumeEdge)edge).getTruthAssumption();
            if (value == null || !value.isExplicitlyKnown()) {
                return null;
            }
            if (this.representsBoolean(value, truthAssumption)) {
                return Collections.singleton(newElement);
            }
            return new HashSet<ValueAnalysisState>();
        }
        if (this.missingInformationRightJExpression != null) {
            Value value = this.handleMissingInformationRightJExpression(rttState);
            if (!value.isUnknown()) {
                newElement.assignConstant(this.missingInformationLeftJVariable, value);
                this.missingInformationRightJExpression = null;
                this.missingInformationLeftJVariable = null;
                return Collections.singleton(newElement);
            }
            if (this.missingInformationLeftJVariable != null) {
                newElement.forget(MemoryLocation.parseExtendedQualifiedName(this.missingInformationLeftJVariable));
            }
            this.missingInformationRightJExpression = null;
            this.missingInformationLeftJVariable = null;
            return Collections.singleton(newElement);
        }
        return null;
    }

    private String getRTTScopedVariableName(String fieldName, String uniqueObject) {
        return uniqueObject + "::" + fieldName;
    }

    private Value handleMissingInformationRightJExpression(RTTState pJortState) {
        return this.missingInformationRightJExpression.accept(new FieldAccessExpressionValueVisitor(pJortState, this.oldState));
    }

    private ValueAnalysisState handleNotScopedVariable(RTTState rttState, ValueAnalysisState newElement) {
        String objectScope = NameProvider.getInstance().getObjectScope(rttState, this.functionName, this.notScopedField);
        if (objectScope != null) {
            String scopedFieldName = this.getRTTScopedVariableName(this.notScopedField.getName(), objectScope);
            Value value = this.notScopedFieldValue;
            if (this.missingInformationRightJExpression != null) {
                value = this.handleMissingInformationRightJExpression(rttState);
            }
            if (!value.isUnknown()) {
                newElement.assignConstant(scopedFieldName, value);
                return newElement;
            }
            newElement.forget(MemoryLocation.parseExtendedQualifiedName(scopedFieldName));
            return newElement;
        }
        return null;
    }

    private void setupFunctionValuesForRandom() {
        try {
            this.valuesFromFile = TestCompTestcaseLoader.loadTestcase(this.options.getFunctionValuesForRandom());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.logger.log(Level.WARNING, new Object[]{String.format("Ignoring the additionally given file 'functionValuesForRandom' %s due to an error", this.options.getFunctionValuesForRandom())});
        }
    }

    private ExpressionValueVisitor getVisitor(ValueAnalysisState pState, String pFunctionName) {
        if (this.options.isIgnoreFunctionValueExceptRandom() && this.options.isIgnoreFunctionValue() && this.options.getFunctionValuesForRandom() != null) {
            return new ExpressionValueVisitorWithPredefinedValues(pState, pFunctionName, indexForNextRandomValue, this.machineModel, this.logger, this.valuesFromFile);
        }
        if (this.options.isIgnoreFunctionValue()) {
            return new ExpressionValueVisitor(pState, pFunctionName, this.machineModel, this.logger);
        }
        return new FunctionPointerExpressionValueVisitor(pState, pFunctionName, this.machineModel, this.logger);
    }

    private ExpressionValueVisitor getVisitor() {
        return this.getVisitor((ValueAnalysisState)this.state, this.functionName);
    }

    private class FieldAccessExpressionValueVisitor
    extends ExpressionValueVisitor {
        private final RTTState jortState;

        public FieldAccessExpressionValueVisitor(RTTState pJortState, ValueAnalysisState pState) {
            super(pState, ValueAnalysisTransferRelation.this.functionName, ValueAnalysisTransferRelation.this.machineModel, ValueAnalysisTransferRelation.this.logger);
            this.jortState = pJortState;
        }

        @Override
        public Value visit(JBinaryExpression binaryExpression) {
            return super.visit(binaryExpression);
        }

        private String handleIdExpression(JIdExpression expr) {
            JSimpleDeclaration decl = expr.getDeclaration();
            if (decl == null) {
                return null;
            }
            NameProvider nameProvider = NameProvider.getInstance();
            String objectScope = nameProvider.getObjectScope(this.jortState, ValueAnalysisTransferRelation.this.functionName, expr);
            return nameProvider.getScopedVariableName(decl, ValueAnalysisTransferRelation.this.functionName, objectScope);
        }

        @Override
        public Value visit(JIdExpression idExp) {
            MemoryLocation varName = MemoryLocation.fromQualifiedName(this.handleIdExpression(idExp));
            if (this.readableState.contains(varName)) {
                return this.readableState.getValueFor(varName);
            }
            return Value.UnknownValue.getInstance();
        }
    }

    @Options(prefix="cpa.value")
    public static class ValueTransferOptions {
        @Option(secure=true, description="if there is an assumption like (x!=0), this option sets unknown (uninitialized) variables to 1L, when the true-branch is handled.")
        private boolean initAssumptionVars = false;
        @Option(secure=true, description="Assume that variables used only in a boolean context are either zero or one.")
        private boolean optimizeBooleanVariables = true;
        @Option(secure=true, description="Track Java array values in explicit value analysis. This may be costly if the verified program uses big or lots of arrays. Arrays in C programs will always be tracked, even if this value is false.")
        private boolean trackJavaArrayValues = true;
        @Option(secure=true, description="Track or not function pointer values")
        private boolean ignoreFunctionValue = true;
        @Option(secure=true, description="If 'ignoreFunctionValue' is set to true, this option allows to provide a fixed set of values in the TestComp format. It is used for function-calls to calls of VERIFIER_nondet_*. The file is provided via the option functionValuesForRandom ")
        private boolean ignoreFunctionValueExceptRandom = false;
        @Option(secure=true, description="Fixed set of values for function calls to VERIFIER_nondet_*. Does only work, if ignoreFunctionValueExceptRandom is enabled ")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private Path functionValuesForRandom = null;
        @Option(secure=true, description="Use equality assumptions to assign values (e.g., (x == 0) => x = 0)")
        private boolean assignEqualityAssumptions = true;
        @Option(secure=true, description="Allow the given extern functions and interpret them as pure functions although the value analysis does not support their semantics and this can produce wrong results.")
        private Set<String> allowedUnsupportedFunctions = ImmutableSet.of();

        public ValueTransferOptions(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }

        boolean isInitAssumptionVars() {
            return this.initAssumptionVars;
        }

        boolean isAssignEqualityAssumptions() {
            return this.assignEqualityAssumptions;
        }

        boolean isOptimizeBooleanVariables() {
            return this.optimizeBooleanVariables;
        }

        boolean isIgnoreFunctionValue() {
            return this.ignoreFunctionValue;
        }

        public boolean isIgnoreFunctionValueExceptRandom() {
            return this.ignoreFunctionValueExceptRandom;
        }

        public Path getFunctionValuesForRandom() {
            return this.functionValuesForRandom;
        }

        boolean isAllowedUnsupportedOption(String func) {
            return this.allowedUnsupportedFunctions.contains(func);
        }
    }
}

