/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;

public abstract class ConcreteErrorPathAllocator<S extends AbstractState> {
    private final Class<S> cls;
    protected final AssumptionToEdgeAllocator assumptionToEdgeAllocator;

    protected ConcreteErrorPathAllocator(Class<S> pCls, AssumptionToEdgeAllocator pAssumptionToEdgeAllocator) {
        this.cls = pCls;
        this.assumptionToEdgeAllocator = pAssumptionToEdgeAllocator;
    }

    public CFAPathWithAssumptions allocateAssignmentsToPath(List<Pair<S, List<CFAEdge>>> pPath) {
        ConcreteStatePath concreteStatePath = this.createConcreteStatePath(pPath);
        return CFAPathWithAssumptions.of(concreteStatePath, this.assumptionToEdgeAllocator);
    }

    public ConcreteStatePath allocateAssignmentsToPath(ARGPath pPath) {
        ArrayList<Pair<S, List<CFAEdge>>> path = new ArrayList<Pair<S, List<CFAEdge>>>(pPath.size());
        PathIterator it = pPath.fullPathIterator();
        while (it.hasNext()) {
            ArrayList<CFAEdge> innerEdges = new ArrayList<CFAEdge>();
            do {
                it.advance();
                innerEdges.add(it.getIncomingEdge());
            } while (!it.isPositionWithState());
            S state = AbstractStates.extractStateByType(it.getAbstractState(), this.cls);
            if (state == null) {
                return null;
            }
            path.add(Pair.of(state, innerEdges));
        }
        return this.createConcreteStatePath(path);
    }

    protected abstract ConcreteStatePath createConcreteStatePath(List<Pair<S, List<CFAEdge>>> var1);

    protected boolean isDeclarationValueKnown(CDeclarationEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        CDeclaration dcl = pCfaEdge.getDeclaration();
        if (dcl instanceof CVariableDeclaration) {
            CIdExpression idExp = new CIdExpression(dcl.getFileLocation(), dcl);
            return this.isLeftHandSideValueKnown(idExp, pAlreadyAssigned);
        }
        return true;
    }

    protected boolean isLeftHandSideValueKnown(CLeftHandSide pLHS, Set<CLeftHandSide> pAlreadyAssigned) {
        ValueKnownVisitor v = new ValueKnownVisitor(pAlreadyAssigned);
        return pLHS.accept(v);
    }

    private static class ValueKnownVisitor
    extends DefaultCExpressionVisitor<Boolean, NoException> {
        private final Set<CLeftHandSide> alreadyAssigned;

        public ValueKnownVisitor(Set<CLeftHandSide> pAlreadyAssigned) {
            this.alreadyAssigned = pAlreadyAssigned;
        }

        @Override
        protected Boolean visitDefault(CExpression pExp) {
            return true;
        }

        @Override
        public Boolean visit(CArraySubscriptExpression pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CBinaryExpression pE) {
            return pE.getOperand1().accept(this) != false && pE.getOperand2().accept(this) != false;
        }

        @Override
        public Boolean visit(CCastExpression pE) {
            return pE.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CFieldReference pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CIdExpression pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CPointerExpression pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CUnaryExpression pE) {
            return pE.getOperand().accept(this);
        }
    }
}

