/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import java.util.List;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisRefiner;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisStrongestPostOperator;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.SortingPathExtractor;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisInterpolantManager;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisPrefixProvider;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.refinement.GenericPrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.InterpolationTree;
import org.sosy_lab.cpachecker.util.refinement.PrefixSelector;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;

@Options(prefix="cpa.value.refinement")
public class ValueAnalysisGlobalRefiner
extends ValueAnalysisRefiner {
    @Option(secure=true, description="whether to use the top-down interpolation strategy or the bottom-up interpolation strategy")
    private boolean useTopDownInterpolationStrategy = true;

    public static Refiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        return AbstractARGBasedRefiner.forARGBasedRefiner(ValueAnalysisGlobalRefiner.create0(pCpa), pCpa);
    }

    public static ARGBasedRefiner create0(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        ValueAnalysisCPA valueAnalysisCpa = CPAs.retrieveCPAOrFail(pCpa, ValueAnalysisCPA.class, ValueAnalysisGlobalRefiner.class);
        valueAnalysisCpa.injectRefinablePrecision();
        LogManager logger = valueAnalysisCpa.getLogger();
        Configuration config = valueAnalysisCpa.getConfiguration();
        CFA cfa = valueAnalysisCpa.getCFA();
        ValueAnalysisStrongestPostOperator strongestPostOp = new ValueAnalysisStrongestPostOperator(logger, Configuration.defaultConfiguration(), cfa);
        ValueAnalysisFeasibilityChecker checker = new ValueAnalysisFeasibilityChecker(strongestPostOp, logger, cfa, config);
        return new ValueAnalysisGlobalRefiner(checker, (StrongestPostOperator<ValueAnalysisState>)strongestPostOp, new ValueAnalysisPrefixProvider(logger, cfa, config, valueAnalysisCpa.getShutdownNotifier()), new PrefixSelector(cfa.getVarClassification(), cfa.getLoopStructure(), logger), config, logger, valueAnalysisCpa.getShutdownNotifier(), cfa);
    }

    ValueAnalysisGlobalRefiner(ValueAnalysisFeasibilityChecker pFeasibilityChecker, StrongestPostOperator<ValueAnalysisState> pStrongestPostOperator, GenericPrefixProvider<ValueAnalysisState> pPrefixProvider, PrefixSelector pPrefixSelector, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        super(pFeasibilityChecker, pStrongestPostOperator, new SortingPathExtractor(pPrefixProvider, pPrefixSelector, pLogger, pConfig), pPrefixProvider, pConfig, pLogger, pShutdownNotifier, pCfa);
        pConfig.inject((Object)this, ValueAnalysisGlobalRefiner.class);
    }

    @Override
    protected InterpolationTree<ValueAnalysisState, ValueAnalysisInterpolant> createInterpolationTree(List<ARGPath> targetsPaths) {
        return new InterpolationTree<ValueAnalysisState, ValueAnalysisInterpolant>(ValueAnalysisInterpolantManager.getInstance(), this.logger, targetsPaths, this.useTopDownInterpolationStrategy);
    }
}

