/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.UnsoundRefiner;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisPathInterpolator;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisStrongestPostOperator;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisInterpolantManager;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisPrefixProvider;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.refinement.GenericPrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.GenericRefiner;
import org.sosy_lab.cpachecker.util.refinement.InterpolationTree;
import org.sosy_lab.cpachecker.util.refinement.PathExtractor;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class ValueAnalysisImpactRefiner
extends AbstractARGBasedRefiner
implements UnsoundRefiner,
StatisticsProvider {
    private int restartCounter = 0;

    public static ValueAnalysisImpactRefiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        ARGCPA argCpa = CPAs.retrieveCPAOrFail(pCpa, ARGCPA.class, ValueAnalysisImpactRefiner.class);
        ValueAnalysisCPA valueAnalysisCpa = CPAs.retrieveCPAOrFail(pCpa, ValueAnalysisCPA.class, ValueAnalysisImpactRefiner.class);
        valueAnalysisCpa.injectRefinablePrecision();
        LogManager logger = valueAnalysisCpa.getLogger();
        Configuration config = valueAnalysisCpa.getConfiguration();
        CFA cfa = valueAnalysisCpa.getCFA();
        ValueAnalysisStrongestPostOperator strongestPostOperator = new ValueAnalysisStrongestPostOperator(logger, Configuration.defaultConfiguration(), cfa);
        PathExtractor pathExtractor = new PathExtractor(logger, config);
        ValueAnalysisFeasibilityChecker checker = new ValueAnalysisFeasibilityChecker(strongestPostOperator, logger, cfa, config);
        ValueAnalysisPrefixProvider prefixProvider = new ValueAnalysisPrefixProvider(logger, cfa, config, valueAnalysisCpa.getShutdownNotifier());
        ImpactDelegateRefiner delegate = new ImpactDelegateRefiner(checker, strongestPostOperator, pathExtractor, prefixProvider, config, logger, valueAnalysisCpa.getShutdownNotifier(), valueAnalysisCpa.getCFA());
        return new ValueAnalysisImpactRefiner(delegate, argCpa, logger);
    }

    ValueAnalysisImpactRefiner(ImpactDelegateRefiner pDelegate, ARGCPA pArgCpa, LogManager pLogger) {
        super(pDelegate, pArgCpa, pLogger);
    }

    @Override
    public void forceRestart(ReachedSet pReached) throws InterruptedException {
        ++this.restartCounter;
        ARGState firstChild = (ARGState)Iterables.getOnlyElement(((ARGState)pReached.getFirstState()).getChildren());
        ARGReachedSet reached = new ARGReachedSet(pReached);
        reached.removeSubtree(firstChild, this.mergeValuePrecisionsForSubgraph(firstChild, reached), VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
    }

    private VariableTrackingPrecision mergeValuePrecisionsForSubgraph(ARGState pRefinementRoot, ARGReachedSet pReached) {
        Set uniquePrecisions = Sets.newIdentityHashSet();
        for (ARGState descendant : ARGUtils.getNonCoveredStatesInSubgraph(pRefinementRoot)) {
            if (!pReached.asReachedSet().contains(descendant)) continue;
            uniquePrecisions.add(ValueAnalysisImpactRefiner.extractValuePrecision(pReached, descendant));
        }
        if (uniquePrecisions.isEmpty()) {
            return null;
        }
        VariableTrackingPrecision mergedPrecision = (VariableTrackingPrecision)Iterables.getLast((Iterable)uniquePrecisions);
        for (VariableTrackingPrecision precision : uniquePrecisions) {
            mergedPrecision = mergedPrecision.join(precision);
        }
        return mergedPrecision;
    }

    private static VariableTrackingPrecision extractValuePrecision(ARGReachedSet pReached, ARGState state) {
        return (VariableTrackingPrecision)Precisions.asIterable(pReached.asReachedSet().getPrecision(state)).filter(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class)).get(0);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Statistics(){

            @Override
            public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
                pOut.println("Total number of restarts:      " + String.format("%9d", ValueAnalysisImpactRefiner.this.restartCounter));
            }

            @Override
            public @Nullable String getName() {
                return ValueAnalysisImpactRefiner.class.getSimpleName();
            }
        });
        super.collectStatistics(pStatsCollection);
    }

    private static class ImpactDelegateRefiner
    extends GenericRefiner<ValueAnalysisState, ValueAnalysisInterpolant> {
        private StatTimer timeStrengthen = new StatTimer("strengthen");
        private StatTimer timeCoverage = new StatTimer("coverage");
        private StatTimer timePrecision = new StatTimer("precision");
        private StatTimer timeRemove = new StatTimer("remove");

        ImpactDelegateRefiner(ValueAnalysisFeasibilityChecker pFeasibilityChecker, StrongestPostOperator<ValueAnalysisState> pStrongestPostOperator, PathExtractor pPathExtractor, GenericPrefixProvider<ValueAnalysisState> pPrefixProvider, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
            super(pFeasibilityChecker, new ValueAnalysisPathInterpolator(pFeasibilityChecker, pStrongestPostOperator, pPrefixProvider, pConfig, pLogger, pShutdownNotifier, pCfa), ValueAnalysisInterpolantManager.getInstance(), pPathExtractor, pConfig, pLogger);
        }

        @Override
        protected void refineUsingInterpolants(ARGReachedSet pReached, InterpolationTree<ValueAnalysisState, ValueAnalysisInterpolant> pInterpolationTree) throws InterruptedException {
            this.timeStrengthen.start();
            Set<ARGState> strengthenedStates = this.strengthenStates(pInterpolationTree);
            this.timeStrengthen.stop();
            this.timeCoverage.start();
            for (ARGState interpolatedTarget : pInterpolationTree.getInterpolatedTargetsInSubtree(pInterpolationTree.getRoot())) {
                this.tryToCoverArg(strengthenedStates, pReached, interpolatedTarget);
            }
            this.timeCoverage.stop();
            CFANode dummyCfaNode = CFANode.newDummyCFANode();
            VariableTrackingPrecision previsousPrecision = null;
            HashMultimap previousIncrement = null;
            this.timePrecision.start();
            for (Map.Entry<ARGState, ValueAnalysisInterpolant> itp : pInterpolationTree.getInterpolantMapping()) {
                ARGState currentState = itp.getKey();
                if (pInterpolationTree.hasInterpolantForState(currentState) && pInterpolationTree.getInterpolantForState(currentState).isTrivial() || !strengthenedStates.contains(currentState)) continue;
                VariableTrackingPrecision currentPrecision = ValueAnalysisImpactRefiner.extractValuePrecision(pReached, currentState);
                HashMultimap increment = HashMultimap.create();
                for (MemoryLocation memoryLocation : pInterpolationTree.getInterpolantForState(currentState).getMemoryLocations()) {
                    increment.put((Object)dummyCfaNode, (Object)memoryLocation);
                }
                VariableTrackingPrecision newPrecision = currentPrecision;
                if (previsousPrecision != currentPrecision || !increment.equals(previousIncrement)) {
                    newPrecision = currentPrecision.withIncrement((Multimap<CFANode, MemoryLocation>)increment);
                }
                pReached.updatePrecisionForState(currentState, newPrecision, VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
                ARGState parent = (ARGState)Iterables.getFirst(currentState.getParents(), null);
                if (parent != null) {
                    // empty if block
                }
                previsousPrecision = currentPrecision;
                previousIncrement = increment;
            }
            this.timePrecision.stop();
            this.timeRemove.start();
            this.removeInfeasiblePartsOfArg(pInterpolationTree, pReached);
            this.timeRemove.stop();
        }

        private Set<ARGState> strengthenStates(InterpolationTree<ValueAnalysisState, ValueAnalysisInterpolant> interpolationTree) {
            HashSet<ARGState> strengthenedStates = new HashSet<ARGState>();
            for (Map.Entry<ARGState, ValueAnalysisInterpolant> entry : interpolationTree.getInterpolantMapping()) {
                ValueAnalysisState valueState;
                if (entry.getValue().isTrivial()) continue;
                ARGState state = entry.getKey();
                ValueAnalysisInterpolant itp = entry.getValue();
                if (!itp.strengthen(valueState = AbstractStates.extractStateByType(state, ValueAnalysisState.class), state)) continue;
                strengthenedStates.add(state);
            }
            return strengthenedStates;
        }

        private void tryToCoverArg(Set<ARGState> strengthenedStates, ARGReachedSet reached, ARGState pTargetState) throws InterruptedException {
            ARGState coverageRoot = null;
            ARGPath errorPath = ARGUtils.getOnePathTo(pTargetState);
            for (ARGState state : errorPath.asStatesList()) {
                if (!strengthenedStates.contains(state)) continue;
                try {
                    if (!state.isCovered() && !reached.tryToCover(state, true)) continue;
                    coverageRoot = state;
                    break;
                }
                catch (CPAException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (coverageRoot != null) {
                for (ARGState children : ARGUtils.getNonCoveredStatesInSubgraph(coverageRoot)) {
                    children.setCovered(coverageRoot);
                }
            }
        }

        private void removeInfeasiblePartsOfArg(InterpolationTree<ValueAnalysisState, ValueAnalysisInterpolant> interpolationTree, ARGReachedSet reached) {
            for (ARGState root : interpolationTree.obtainCutOffRoots()) {
                reached.cutOffSubtree(root);
            }
        }

        @Override
        protected void printAdditionalStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsWriter w = StatisticsWriter.writingStatisticsTo(pOut);
            w.beginLevel().put(this.timeStrengthen).put(this.timeCoverage).put(this.timePrecision).put(this.timeRemove);
        }
    }
}

