/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.util.refinement.Interpolant;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public final class ValueAnalysisInterpolant
implements Interpolant<ValueAnalysisState, ValueAnalysisInterpolant> {
    private final @Nullable PersistentMap<MemoryLocation, ValueAnalysisState.ValueAndType> assignment;
    public static final ValueAnalysisInterpolant TRUE = new ValueAnalysisInterpolant();
    public static final ValueAnalysisInterpolant FALSE = new ValueAnalysisInterpolant(null);

    private ValueAnalysisInterpolant() {
        this.assignment = PathCopyingPersistentTreeMap.of();
    }

    public ValueAnalysisInterpolant(PersistentMap<MemoryLocation, ValueAnalysisState.ValueAndType> pAssignment) {
        this.assignment = pAssignment;
    }

    public static ValueAnalysisInterpolant createInitial() {
        return new ValueAnalysisInterpolant();
    }

    @Override
    public Set<MemoryLocation> getMemoryLocations() {
        return this.isFalse() ? ImmutableSet.of() : Collections.unmodifiableSet(this.assignment.keySet());
    }

    @Override
    public ValueAnalysisInterpolant join(ValueAnalysisInterpolant other) {
        if (this.assignment == null || other.assignment == null) {
            return FALSE;
        }
        PersistentMap newAssignment = this.assignment;
        for (Map.Entry entry : other.assignment.entrySet()) {
            if (newAssignment.containsKey(entry.getKey())) assert (((ValueAnalysisState.ValueAndType)entry.getValue()).equals(other.assignment.get(entry.getKey()))) : "interpolants mismatch in " + entry.getKey();
            newAssignment = newAssignment.putAndCopy((Object)((MemoryLocation)entry.getKey()), (Object)((ValueAnalysisState.ValueAndType)entry.getValue()));
            assert (Objects.equals(((ValueAnalysisState.ValueAndType)entry.getValue()).getType(), ((ValueAnalysisState.ValueAndType)other.assignment.get(entry.getKey())).getType())) : "interpolants mismatch in " + entry.getKey();
        }
        return new ValueAnalysisInterpolant(newAssignment);
    }

    public int hashCode() {
        return Objects.hashCode(this.assignment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueAnalysisInterpolant other = (ValueAnalysisInterpolant)obj;
        return Objects.equals(this.assignment, other.assignment);
    }

    @Override
    public boolean isTrue() {
        return !this.isFalse() && this.assignment.isEmpty();
    }

    @Override
    public boolean isFalse() {
        return this.assignment == null;
    }

    @Override
    public ValueAnalysisState reconstructState() {
        if (this.assignment == null) {
            throw new IllegalStateException("Can't reconstruct state from FALSE-interpolant");
        }
        return new ValueAnalysisState(Optional.empty(), this.assignment);
    }

    public String toString() {
        if (this.isFalse()) {
            return "FALSE";
        }
        if (this.isTrue()) {
            return "TRUE";
        }
        return this.assignment.toString();
    }

    public boolean strengthen(ValueAnalysisState valueState, ARGState argState) {
        if (this.isTrivial()) {
            return false;
        }
        boolean strengthened = false;
        for (Map.Entry itp : this.assignment.entrySet()) {
            if (!valueState.contains((MemoryLocation)itp.getKey())) {
                valueState.assignConstant((MemoryLocation)itp.getKey(), ((ValueAnalysisState.ValueAndType)itp.getValue()).getValue(), ((ValueAnalysisState.ValueAndType)itp.getValue()).getType());
                strengthened = true;
                continue;
            }
            Verify.verify((valueState.getValueFor((MemoryLocation)itp.getKey()).asNumericValue().longValue() == ((ValueAnalysisState.ValueAndType)itp.getValue()).getValue().asNumericValue().longValue() ? 1 : 0) != 0, (String)"state and interpolant do not match in value for variable %s [state = %s != %s = itp] for state %s", itp.getKey(), (Object)valueState.getValueFor((MemoryLocation)itp.getKey()), itp.getValue(), (Object)argState.getStateId());
        }
        return strengthened;
    }

    public ValueAnalysisInterpolant weaken(Set<String> toRetain) {
        if (this.isTrivial()) {
            return this;
        }
        PersistentMap weakenedAssignments = this.assignment;
        for (MemoryLocation current : this.assignment.keySet()) {
            if (toRetain.contains(current.getExtendedQualifiedName())) continue;
            weakenedAssignments = weakenedAssignments.removeAndCopy((Object)current);
        }
        return new ValueAnalysisInterpolant(weakenedAssignments);
    }

    @Override
    public int getSize() {
        return this.isTrivial() ? 0 : this.assignment.size();
    }
}

