/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.conditions.path.AssignmentsInPathCondition;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.UseDefBasedInterpolator;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisEdgeInterpolator;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisInterpolantManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.GenericPathInterpolator;
import org.sosy_lab.cpachecker.util.refinement.GenericPrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;
import org.sosy_lab.cpachecker.util.refinement.UseDefRelation;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

@Options(prefix="cpa.value.refinement")
public class ValueAnalysisPathInterpolator
extends GenericPathInterpolator<ValueAnalysisState, ValueAnalysisInterpolant> {
    @Option(secure=true, description="whether to perform (more precise) edge-based interpolation or (more efficient) path-based interpolation")
    private boolean performEdgeBasedInterpolation = true;
    @Option(secure=true, description="whether or not to do lazy-abstraction")
    private boolean doLazyAbstraction = true;
    private AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments = null;
    private final CFA cfa;
    private final ValueAnalysisInterpolantManager interpolantManager;

    public ValueAnalysisPathInterpolator(FeasibilityChecker<ValueAnalysisState> pFeasibilityChecker, StrongestPostOperator<ValueAnalysisState> pStrongestPostOperator, GenericPrefixProvider<ValueAnalysisState> pPrefixProvider, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        super(new ValueAnalysisEdgeInterpolator(pFeasibilityChecker, pStrongestPostOperator, pConfig, pShutdownNotifier, pCfa), pFeasibilityChecker, pPrefixProvider, ValueAnalysisInterpolantManager.getInstance(), pConfig, pLogger, pShutdownNotifier, pCfa);
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        this.interpolantManager = ValueAnalysisInterpolantManager.getInstance();
    }

    @Override
    public Map<ARGState, ValueAnalysisInterpolant> performInterpolation(ARGPath errorPath, ValueAnalysisInterpolant interpolant) throws CPAException, InterruptedException {
        if (this.performEdgeBasedInterpolation) {
            return super.performInterpolation(errorPath, interpolant);
        }
        this.totalInterpolations.inc();
        ARGPath errorPathPrefix = this.performRefinementSelection(errorPath, interpolant);
        this.timerInterpolation.start();
        Map<ARGState, ValueAnalysisInterpolant> interpolants = this.performPathBasedInterpolation(errorPathPrefix);
        this.timerInterpolation.stop();
        this.propagateFalseInterpolant(errorPath, errorPathPrefix, interpolants);
        return interpolants;
    }

    private Map<ARGState, ValueAnalysisInterpolant> performPathBasedInterpolation(ARGPath errorPathPrefix) {
        ImmutableSet booleanVariables = this.cfa.getVarClassification().isPresent() ? this.cfa.getVarClassification().orElseThrow().getIntBoolVars() : ImmutableSet.of();
        UseDefRelation useDefRelation = new UseDefRelation(errorPathPrefix, (Set<String>)booleanVariables, !this.isRefinementSelectionEnabled());
        Map<ARGState, ValueAnalysisInterpolant> interpolants = new UseDefBasedInterpolator(errorPathPrefix, useDefRelation, this.cfa.getMachineModel()).obtainInterpolantsAsMap();
        this.totalInterpolationQueries.setNextValue(1);
        int size = 0;
        for (ValueAnalysisInterpolant itp : interpolants.values()) {
            size += itp.getSize();
        }
        this.sizeOfInterpolant.setNextValue(size);
        return interpolants;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Multimap<CFANode, MemoryLocation> determinePrecisionIncrement(ARGPath errorPath) throws CPAException, InterruptedException {
        this.assignments = AbstractStates.extractStateByType(errorPath.getLastState(), AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState.class);
        HashMultimap increment = HashMultimap.create();
        Map<ARGState, ValueAnalysisInterpolant> itps = this.performInterpolation(errorPath, this.interpolantManager.createInitialInterpolant());
        for (Map.Entry<ARGState, ValueAnalysisInterpolant> itp : itps.entrySet()) {
            this.addToPrecisionIncrement((Multimap<CFANode, MemoryLocation>)increment, AbstractStates.extractLocation(itp.getKey()), itp.getValue());
        }
        return increment;
    }

    private void addToPrecisionIncrement(Multimap<CFANode, MemoryLocation> increment, CFANode currentNode, ValueAnalysisInterpolant itp) {
        for (MemoryLocation memoryLocation : itp.getMemoryLocations()) {
            if (this.assignments != null && this.assignments.exceedsThreshold(memoryLocation)) continue;
            increment.put((Object)currentNode, (Object)memoryLocation);
        }
    }

    public Pair<ARGState, CFAEdge> determineRefinementRoot(ARGPath errorPath, Multimap<CFANode, MemoryLocation> increment) throws RefinementFailedException {
        if (this.interpolationOffset == -1) {
            throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, errorPath);
        }
        if (this.doLazyAbstraction) {
            PathIterator it = errorPath.pathIterator();
            for (int i = 0; i < this.interpolationOffset; ++i) {
                it.advance();
            }
            return Pair.of(it.getAbstractState(), it.getIncomingEdge());
        }
        PathIterator firstElem = errorPath.pathIterator();
        firstElem.advance();
        return Pair.of(firstElem.getAbstractState(), firstElem.getOutgoingEdge());
    }
}

