/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionRefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisConcreteErrorPathAllocator;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisPathInterpolator;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisStrongestPostOperator;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisInterpolantManager;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisPrefixProvider;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.refinement.GenericPrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.GenericRefiner;
import org.sosy_lab.cpachecker.util.refinement.InterpolationTree;
import org.sosy_lab.cpachecker.util.refinement.PathExtractor;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.value.refinement")
public class ValueAnalysisRefiner
extends GenericRefiner<ValueAnalysisState, ValueAnalysisInterpolant> {
    @Option(secure=true, description="whether or not to do lazy-abstraction", name="restart", toUppercase=true)
    private GenericRefiner.RestartStrategy restartStrategy = GenericRefiner.RestartStrategy.PIVOT;
    @Option(secure=true, description="whether or not to use heuristic to avoid similar, repeated refinements")
    private boolean avoidSimilarRepeatedRefinement = false;
    @Option(secure=true, description="Which base precision should be used for a new precision? ALL: During refinement, collect precisions from the complete ARG. SUBGRAPH: During refinement, keep precision from all removed parts (subgraph) of the ARG. CUTPOINT: Only the cut-point's precision is kept. TARGET: Only the target state's precision is kept.")
    private BasisStrategy basisStrategy = BasisStrategy.SUBGRAPH;
    private final Set<Integer> previousRefinementIds = new HashSet<Integer>();
    private final ValueAnalysisFeasibilityChecker checker;
    private ValueAnalysisConcreteErrorPathAllocator concreteErrorPathAllocator;
    private final ShutdownNotifier shutdownNotifier;
    private final StatCounter rootRelocations = new StatCounter("Number of root relocations");
    private final StatCounter repeatedRefinements = new StatCounter("Number of similar, repeated refinements");

    public static Refiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        return AbstractARGBasedRefiner.forARGBasedRefiner(ValueAnalysisRefiner.create0(pCpa), pCpa);
    }

    public static ARGBasedRefiner create0(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        ValueAnalysisCPA valueAnalysisCpa = CPAs.retrieveCPAOrFail(pCpa, ValueAnalysisCPA.class, ValueAnalysisRefiner.class);
        valueAnalysisCpa.injectRefinablePrecision();
        LogManager logger = valueAnalysisCpa.getLogger();
        Configuration config = valueAnalysisCpa.getConfiguration();
        CFA cfa = valueAnalysisCpa.getCFA();
        ValueAnalysisStrongestPostOperator strongestPostOp = new ValueAnalysisStrongestPostOperator(logger, config, cfa);
        ValueAnalysisFeasibilityChecker checker = new ValueAnalysisFeasibilityChecker(strongestPostOp, logger, cfa, config);
        ValueAnalysisPrefixProvider prefixProvider = new ValueAnalysisPrefixProvider(logger, cfa, config, valueAnalysisCpa.getShutdownNotifier());
        return new ValueAnalysisRefiner(checker, strongestPostOp, new PathExtractor(logger, config), prefixProvider, config, logger, valueAnalysisCpa.getShutdownNotifier(), cfa);
    }

    ValueAnalysisRefiner(ValueAnalysisFeasibilityChecker pFeasibilityChecker, StrongestPostOperator<ValueAnalysisState> pStrongestPostOperator, PathExtractor pPathExtractor, GenericPrefixProvider<ValueAnalysisState> pPrefixProvider, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        super(pFeasibilityChecker, new ValueAnalysisPathInterpolator(pFeasibilityChecker, pStrongestPostOperator, pPrefixProvider, pConfig, pLogger, pShutdownNotifier, pCfa), ValueAnalysisInterpolantManager.getInstance(), pPathExtractor, pConfig, pLogger);
        pConfig.inject((Object)this, ValueAnalysisRefiner.class);
        this.checker = pFeasibilityChecker;
        this.concreteErrorPathAllocator = new ValueAnalysisConcreteErrorPathAllocator(pConfig, this.logger, pCfa.getMachineModel());
        this.shutdownNotifier = pShutdownNotifier;
    }

    @Override
    protected void refineUsingInterpolants(ARGReachedSet pReached, InterpolationTree<ValueAnalysisState, ValueAnalysisInterpolant> pInterpolationTree) throws InterruptedException {
        UnmodifiableReachedSet reached = pReached.asReachedSet();
        boolean predicatePrecisionIsAvailable = this.isPredicatePrecisionAvailable(reached);
        LinkedHashMap refinementInformation = new LinkedHashMap();
        ImmutableSet<ARGState> refinementRoots = pInterpolationTree.obtainRefinementRoots(this.restartStrategy);
        for (ARGState root : refinementRoots) {
            VariableTrackingPrecision basePrecision;
            this.shutdownNotifier.shutdownIfNecessary();
            root = this.relocateRefinementRoot(root, predicatePrecisionIsAvailable);
            if (refinementRoots.size() == 1 && this.isSimilarRepeatedRefinement(pInterpolationTree.extractPrecisionIncrement(root).values())) {
                root = this.relocateRepeatedRefinementRoot(root);
            }
            ArrayList<Precision> precisions = new ArrayList<Precision>(2);
            switch (this.basisStrategy) {
                case ALL: {
                    basePrecision = this.mergeValuePrecisionsForSubgraph((ARGState)reached.getFirstState(), reached);
                    break;
                }
                case SUBGRAPH: {
                    basePrecision = this.mergeValuePrecisionsForSubgraph(root, reached);
                    break;
                }
                case TARGET: {
                    basePrecision = this.extractValuePrecision(reached.getPrecision(reached.getLastState()));
                    break;
                }
                case CUTPOINT: {
                    basePrecision = this.extractValuePrecision(reached.getPrecision(root));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unknown strategy for predicate basis.");
                }
            }
            precisions.add(basePrecision.withIncrement(pInterpolationTree.extractPrecisionIncrement(root)));
            if (predicatePrecisionIsAvailable) {
                precisions.add(PredicateAbstractionRefinementStrategy.findAllPredicatesFromSubgraph(root, reached));
            }
            refinementInformation.put(root, precisions);
        }
        for (Map.Entry info : refinementInformation.entrySet()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ArrayList<Predicate<? super Precision>> precisionTypes = new ArrayList<Predicate<? super Precision>>(2);
            precisionTypes.add(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
            if (predicatePrecisionIsAvailable) {
                precisionTypes.add(Predicates.instanceOf(PredicatePrecision.class));
            }
            pReached.removeSubtree((ARGState)info.getKey(), (List)info.getValue(), precisionTypes);
        }
    }

    private boolean isPredicatePrecisionAvailable(UnmodifiableReachedSet pReached) {
        return Precisions.extractPrecisionByType(pReached.getPrecision(pReached.getFirstState()), PredicatePrecision.class) != null;
    }

    private VariableTrackingPrecision mergeValuePrecisionsForSubgraph(ARGState pRefinementRoot, UnmodifiableReachedSet pReached) {
        Set uniquePrecisions = Sets.newIdentityHashSet();
        for (ARGState descendant : ARGUtils.getNonCoveredStatesInSubgraph(pRefinementRoot)) {
            uniquePrecisions.add(this.extractValuePrecision(pReached.getPrecision(descendant)));
        }
        VariableTrackingPrecision mergedPrecision = (VariableTrackingPrecision)Iterables.getLast((Iterable)uniquePrecisions);
        for (VariableTrackingPrecision precision : uniquePrecisions) {
            mergedPrecision = mergedPrecision.join(precision);
        }
        return mergedPrecision;
    }

    private VariableTrackingPrecision extractValuePrecision(Precision precision) {
        return (VariableTrackingPrecision)Precisions.asIterable(precision).firstMatch(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class)).get();
    }

    private boolean isSimilarRepeatedRefinement(Collection<MemoryLocation> currentIncrement) {
        boolean isSimilar = false;
        int currentRefinementId = new TreeSet<MemoryLocation>(currentIncrement).hashCode();
        if (this.avoidSimilarRepeatedRefinement) {
            isSimilar = this.previousRefinementIds.contains(currentRefinementId);
        }
        this.previousRefinementIds.add(currentRefinementId);
        return isSimilar;
    }

    private ARGState relocateRepeatedRefinementRoot(ARGState currentRoot) {
        this.repeatedRefinements.inc();
        int currentRootNumber = AbstractStates.extractLocation(currentRoot).getNodeNumber();
        ARGPath path = ARGUtils.getOnePathTo(currentRoot);
        for (ARGState currentState : path.asStatesList().reverse()) {
            if (Objects.equals(currentState, currentRoot) || currentRootNumber != AbstractStates.extractLocation(currentState).getNodeNumber()) continue;
            return currentState;
        }
        return (ARGState)Iterables.getOnlyElement(path.getFirstState().getChildren());
    }

    private ARGState relocateRefinementRoot(ARGState pRefinementRoot, boolean predicatePrecisionIsAvailable) throws InterruptedException {
        if (!predicatePrecisionIsAvailable) {
            return pRefinementRoot;
        }
        if (this.restartStrategy == GenericRefiner.RestartStrategy.ROOT) {
            return pRefinementRoot;
        }
        ImmutableList descendants = pRefinementRoot.getSubgraph().toList();
        ImmutableSet coveredStates = FluentIterable.from((Iterable)descendants).transformAndConcat(ARGState::getCoveredByThis).append((Object[])new ARGState[]{pRefinementRoot}).toSet();
        this.shutdownNotifier.shutdownIfNecessary();
        if (descendants.containsAll((Collection)coveredStates)) {
            return pRefinementRoot;
        }
        LinkedHashMultimap successorRelation = LinkedHashMultimap.create();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>((Collection<ARGState>)coveredStates);
        ARGState coverageTreeRoot = null;
        while (!todo.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ARGState currentState = (ARGState)todo.removeFirst();
            if (currentState.getParents().iterator().hasNext()) {
                ARGState parentState = currentState.getParents().iterator().next();
                todo.add(parentState);
                successorRelation.put((Object)parentState, (Object)currentState);
                continue;
            }
            if (coverageTreeRoot != null) continue;
            coverageTreeRoot = currentState;
        }
        this.shutdownNotifier.shutdownIfNecessary();
        ARGState newRefinementRoot = coverageTreeRoot;
        while (successorRelation.get(newRefinementRoot).size() == 1 && !pRefinementRoot.equals(newRefinementRoot)) {
            newRefinementRoot = (ARGState)Iterables.getOnlyElement((Iterable)successorRelation.get((Object)newRefinementRoot));
        }
        this.rootRelocations.inc();
        return newRefinementRoot;
    }

    @Override
    protected CFAPathWithAssumptions createModel(ARGPath errorPath) throws InterruptedException, CPAException {
        List concretePath = this.checker.evaluate(errorPath);
        if (concretePath.size() < errorPath.getInnerEdges().size()) {
            this.logger.log(Level.WARNING, new Object[]{"Counterexample is imprecise and may be wrong."});
            return super.createModel(errorPath);
        }
        return this.concreteErrorPathAllocator.allocateAssignmentsToPath(concretePath);
    }

    @Override
    protected void printAdditionalStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut);
        writer.put(this.rootRelocations).put(this.repeatedRefinements).put("Number of unique precision increments", this.previousRefinementIds.size());
    }

    private static enum BasisStrategy {
        ALL,
        SUBGRAPH,
        TARGET,
        CUTPOINT;

    }
}

