/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.conditions.path.AssignmentsInPathCondition;
import org.sosy_lab.cpachecker.cpa.value.UnknownValueAssigner;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.symbolic.ConstraintsStrengthenOperator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ValueAnalysisStrongestPostOperator
implements StrongestPostOperator<ValueAnalysisState> {
    private final ValueAnalysisTransferRelation transfer;

    public ValueAnalysisStrongestPostOperator(LogManager pLogger, Configuration pConfig, CFA pCfa) throws InvalidConfigurationException {
        this.transfer = new ValueAnalysisTransferRelation(pLogger, pCfa, new ValueAnalysisTransferRelation.ValueTransferOptions(pConfig), new UnknownValueAssigner(), new ConstraintsStrengthenOperator(pConfig, pLogger), null);
    }

    @Override
    public Optional<ValueAnalysisState> getStrongestPost(ValueAnalysisState pOrigin, Precision pPrecision, CFAEdge pOperation) throws CPAException, InterruptedException {
        Collection successors = this.transfer.getAbstractSuccessorsForEdge(pOrigin, pPrecision, pOperation);
        if (successors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((ValueAnalysisState)Iterables.getOnlyElement(successors));
    }

    @Override
    public ValueAnalysisState handleFunctionCall(ValueAnalysisState state, CFAEdge edge, Deque<ValueAnalysisState> callstack) {
        callstack.push(state);
        return state;
    }

    @Override
    public ValueAnalysisState handleFunctionReturn(ValueAnalysisState next, CFAEdge edge, Deque<ValueAnalysisState> callstack) {
        ValueAnalysisState callState = callstack.pop();
        return next.rebuildStateAfterFunctionCall(callState, (FunctionExitNode)edge.getPredecessor());
    }

    @Override
    public ValueAnalysisState performAbstraction(ValueAnalysisState pNext, CFANode pCurrNode, ARGPath pErrorPath, Precision pPrecision) {
        assert (pPrecision instanceof VariableTrackingPrecision);
        VariableTrackingPrecision precision = (VariableTrackingPrecision)pPrecision;
        boolean performAbstraction = precision.allowsAbstraction();
        Set<MemoryLocation> exceedingMemoryLocations = this.obtainExceedingMemoryLocations(pErrorPath);
        if (performAbstraction) {
            for (Map.Entry entry : pNext.getConstants()) {
                MemoryLocation memoryLocation = (MemoryLocation)entry.getKey();
                if (precision.isTracking(memoryLocation, ((ValueAnalysisState.ValueAndType)entry.getValue()).getType(), pCurrNode)) continue;
                pNext.forget(memoryLocation);
            }
        }
        for (MemoryLocation memoryLocation : exceedingMemoryLocations) {
            pNext.forget(memoryLocation);
        }
        return pNext;
    }

    protected Set<MemoryLocation> obtainExceedingMemoryLocations(ARGPath pPath) {
        AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments = AbstractStates.extractStateByType(pPath.getLastState(), AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState.class);
        if (assignments == null) {
            return ImmutableSet.of();
        }
        return assignments.getMemoryLocationsExceedingThreshold();
    }
}

