/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.refinement.InfeasiblePrefix;
import org.sosy_lab.cpachecker.util.refinement.PathExtractor;
import org.sosy_lab.cpachecker.util.refinement.PrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.PrefixSelector;

@Options(prefix="cpa.value.refinement")
public class SortingPathExtractor
extends PathExtractor {
    @Option(secure=true, description="heuristic to sort targets based on the quality of interpolants derivable from them")
    private boolean itpSortedTargets = false;
    private final PrefixSelector prefixSelector;
    private final PrefixProvider prefixProvider;

    public SortingPathExtractor(PrefixProvider pPrefixProvider, PrefixSelector pPrefixSelector, LogManager pLogger, Configuration pConfig) throws InvalidConfigurationException {
        super(pLogger, pConfig);
        pConfig.inject((Object)this, SortingPathExtractor.class);
        this.prefixProvider = pPrefixProvider;
        this.prefixSelector = pPrefixSelector;
    }

    @Override
    public Collection<ARGState> getTargetStates(ARGReachedSet pReached) throws RefinementFailedException, InterruptedException {
        Collection<ARGState> targetStates = super.getTargetStates(pReached);
        HashMap<ARGState, Integer> targetsWithScores = new HashMap<ARGState, Integer>();
        for (ARGState targetState : targetStates) {
            targetsWithScores.put(targetState, this.getScore(targetState));
        }
        return ImmutableList.sortedCopyOf(Comparator.comparing(targetsWithScores::get), targetStates);
    }

    private int getScore(ARGState target) throws InterruptedException {
        ARGPath path = ARGUtils.getOnePathTo(target);
        if (this.itpSortedTargets) {
            List<InfeasiblePrefix> prefixes;
            try {
                prefixes = this.prefixProvider.extractInfeasiblePrefixes(path);
            }
            catch (CPAException e) {
                throw new AssertionError((Object)e);
            }
            return this.prefixSelector.obtainScoreForPrefixes(prefixes, PrefixSelector.PrefixPreference.DOMAIN_MIN);
        }
        return path.size();
    }
}

