/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.refinement.GenericFeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;

public class ValueAnalysisFeasibilityChecker
extends GenericFeasibilityChecker<ValueAnalysisState> {
    private final StrongestPostOperator<ValueAnalysisState> strongestPostOp;
    private final VariableTrackingPrecision precision;
    private final MachineModel machineModel;

    public ValueAnalysisFeasibilityChecker(StrongestPostOperator<ValueAnalysisState> pStrongestPostOp, LogManager pLogger, CFA pCfa, Configuration config) throws InvalidConfigurationException {
        super(pStrongestPostOp, new ValueAnalysisState(pCfa.getMachineModel()), ValueAnalysisCPA.class, pLogger, config, pCfa);
        this.strongestPostOp = pStrongestPostOp;
        this.precision = VariableTrackingPrecision.createStaticPrecision(config, pCfa.getVarClassification(), ValueAnalysisCPA.class);
        this.machineModel = pCfa.getMachineModel();
    }

    public List<Pair<ValueAnalysisState, List<CFAEdge>>> evaluate(ARGPath path) throws CPAException, InterruptedException {
        try {
            ArrayList<Pair<ValueAnalysisState, List<CFAEdge>>> reevaluatedPath = new ArrayList<Pair<ValueAnalysisState, List<CFAEdge>>>();
            ValueAnalysisState next = new ValueAnalysisState(this.machineModel);
            PathIterator iterator = path.fullPathIterator();
            while (iterator.hasNext()) {
                ArrayList<CFAEdge> allOutgoingEdges = new ArrayList<CFAEdge>();
                do {
                    CFAEdge outgoingEdge = iterator.getOutgoingEdge();
                    allOutgoingEdges.add(outgoingEdge);
                    Optional<ValueAnalysisState> successor = this.strongestPostOp.getStrongestPost(next, this.precision, outgoingEdge);
                    iterator.advance();
                    if (!successor.isPresent()) {
                        return reevaluatedPath;
                    }
                    next = successor.orElseThrow();
                } while (!iterator.isPositionWithState());
                reevaluatedPath.add(Pair.of(next, allOutgoingEdges));
            }
            return reevaluatedPath;
        }
        catch (CPATransferException e) {
            throw new CPAException("Computation of successor failed for checking path: " + e.getMessage(), e);
        }
    }
}

