/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic;

import java.util.Optional;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.ExpressionTransformer;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class CExpressionTransformer
extends ExpressionTransformer
implements CRightHandSideVisitor<SymbolicExpression, UnrecognizedCodeException> {
    private final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;
    private final SymbolicValueFactory factory = SymbolicValueFactory.getInstance();

    public CExpressionTransformer(String pFunctionName, ValueAnalysisState pValueState, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger) {
        super(pFunctionName, pValueState);
        this.machineModel = pMachineModel;
        this.logger = pLogger;
    }

    public SymbolicExpression transform(CExpression pExpression) throws UnrecognizedCodeException {
        return pExpression.accept(this);
    }

    @Override
    public SymbolicExpression visit(CBinaryExpression pIastBinaryExpression) throws UnrecognizedCodeException {
        SymbolicExpression operand1Expression = pIastBinaryExpression.getOperand1().accept(this);
        if (operand1Expression == null) {
            return null;
        }
        SymbolicExpression operand2Expression = pIastBinaryExpression.getOperand2().accept(this);
        if (operand2Expression == null) {
            return null;
        }
        CType expressionType = pIastBinaryExpression.getExpressionType();
        CType calculationType = pIastBinaryExpression.getCalculationType();
        switch (pIastBinaryExpression.getOperator()) {
            case PLUS: {
                return this.factory.add(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case MINUS: {
                return this.factory.minus(operand1Expression, operand2Expression, expressionType, calculationType);
            }
            case MULTIPLY: {
                return this.factory.multiply(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case DIVIDE: {
                return this.factory.divide(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case MODULO: {
                return this.factory.modulo(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case SHIFT_LEFT: {
                return this.factory.shiftLeft(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case SHIFT_RIGHT: {
                return this.factory.shiftRightSigned(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case BINARY_AND: {
                return this.factory.binaryAnd(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case BINARY_OR: {
                return this.factory.binaryOr(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case BINARY_XOR: {
                return this.factory.binaryXor(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case EQUALS: {
                return this.factory.equal(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case NOT_EQUALS: {
                return this.factory.notEqual(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case LESS_THAN: {
                return this.factory.lessThan(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case LESS_EQUAL: {
                return this.factory.lessThanOrEqual(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case GREATER_THAN: {
                return this.factory.greaterThan(operand1Expression, operand2Expression, calculationType, calculationType);
            }
            case GREATER_EQUAL: {
                return this.factory.greaterThanOrEqual(operand1Expression, operand2Expression, calculationType, calculationType);
            }
        }
        throw new AssertionError((Object)("Unhandled binary operation " + pIastBinaryExpression.getOperator()));
    }

    @Override
    public SymbolicExpression visit(CUnaryExpression pIastUnaryExpression) throws UnrecognizedCodeException {
        CUnaryExpression.UnaryOperator operator = pIastUnaryExpression.getOperator();
        CType expressionType = pIastUnaryExpression.getExpressionType();
        switch (operator) {
            case MINUS: 
            case TILDE: {
                SymbolicExpression operand = pIastUnaryExpression.getOperand().accept(this);
                if (operand == null) {
                    return null;
                }
                return this.transformUnaryArithmetic(operator, operand, expressionType);
            }
        }
        return null;
    }

    private SymbolicExpression transformUnaryArithmetic(CUnaryExpression.UnaryOperator pOperator, SymbolicExpression pOperand, Type pExpressionType) {
        switch (pOperator) {
            case MINUS: {
                return this.factory.negate(pOperand, pExpressionType);
            }
            case TILDE: {
                return this.factory.binaryNot(pOperand, pExpressionType);
            }
            case AMPER: {
                return this.factory.addressOf(pOperand, pExpressionType);
            }
        }
        throw new AssertionError((Object)("No arithmetic operator: " + pOperator));
    }

    @Override
    public SymbolicExpression visit(CIdExpression pIastIdExpression) throws UnrecognizedCodeException {
        return super.visit(pIastIdExpression);
    }

    @Override
    public SymbolicExpression visit(CCharLiteralExpression pIastCharLiteralExpression) throws UnrecognizedCodeException {
        return super.visit(pIastCharLiteralExpression);
    }

    @Override
    public SymbolicExpression visit(CFloatLiteralExpression pIastFloatLiteralExpression) throws UnrecognizedCodeException {
        return super.visit(pIastFloatLiteralExpression);
    }

    @Override
    public SymbolicExpression visit(CIntegerLiteralExpression pIastIntegerLiteralExpression) throws UnrecognizedCodeException {
        return super.visit(pIastIntegerLiteralExpression);
    }

    @Override
    public SymbolicExpression visit(CStringLiteralExpression pIastStringLiteralExpression) throws UnrecognizedCodeException {
        return null;
    }

    @Override
    public SymbolicExpression visit(CTypeIdExpression pIastTypeIdExpression) throws UnrecognizedCodeException {
        throw new AssertionError((Object)"Type id expression invalid for constraint");
    }

    @Override
    public SymbolicExpression visit(CImaginaryLiteralExpression pIastLiteralExpression) throws UnrecognizedCodeException {
        throw new AssertionError((Object)"Imaginary literal invalid for constraint");
    }

    @Override
    public SymbolicExpression visit(CAddressOfLabelExpression pAddressOfLabelExpression) throws UnrecognizedCodeException {
        throw new AssertionError((Object)"Address of label expression used in symbolic expression");
    }

    @Override
    public SymbolicExpression visit(CArraySubscriptExpression pIastArraySubscriptExpression) throws UnrecognizedCodeException {
        return this.evaluateToValue(pIastArraySubscriptExpression);
    }

    @Override
    public SymbolicExpression visit(CFieldReference pIastFieldReference) throws UnrecognizedCodeException {
        return this.evaluateToValue(pIastFieldReference);
    }

    private SymbolicExpression evaluateToValue(CExpression pExpression) throws UnrecognizedCodeException {
        ExpressionValueVisitor valueVisitor = this.getValueVisitor(this.valueState);
        MemoryLocation memLoc = valueVisitor.evaluateMemoryLocation(pExpression);
        if (memLoc == null) {
            return null;
        }
        if (this.valueState.contains(memLoc)) {
            Value value = this.valueState.getValueFor(memLoc);
            return this.factory.asConstant(value, pExpression.getExpressionType());
        }
        return null;
    }

    @Override
    public SymbolicExpression visit(CPointerExpression pPointerExpression) throws UnrecognizedCodeException {
        SymbolicExpression operand = pPointerExpression.getOperand().accept(this);
        if (operand == null) {
            return null;
        }
        return this.factory.pointer(operand, pPointerExpression.getExpressionType());
    }

    private ExpressionValueVisitor getValueVisitor(ValueAnalysisState pState) {
        return new ExpressionValueVisitor(pState, this.functionName, this.machineModel, this.logger);
    }

    @Override
    public SymbolicExpression visit(CFunctionCallExpression pIastFunctionCallExpression) throws UnrecognizedCodeException {
        throw new UnsupportedOperationException("Function calls can't be transformed to ConstraintExpressions");
    }

    @Override
    public SymbolicExpression visit(CCastExpression pIastCastExpression) throws UnrecognizedCodeException {
        SymbolicExpression operand = pIastCastExpression.getOperand().accept(this);
        if (operand == null) {
            return null;
        }
        return this.factory.cast(operand, pIastCastExpression.getCastType(), Optional.of(this.machineModel));
    }

    @Override
    public SymbolicExpression visit(CComplexCastExpression complexCastExpression) throws UnrecognizedCodeException {
        throw new AssertionError((Object)"Complex cast not valid for constraint");
    }
}

