/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic;

import com.google.common.collect.FluentIterable;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ConstantSymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.symbolic.util.SymbolicValues;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

@Options(prefix="cpa.value.symbolic")
public class ConstraintsStrengthenOperator
implements Statistics {
    @Option(description="Whether to simplify symbolic expressions, if possible.")
    private boolean simplifySymbolics = true;
    private final Timer totalTime = new Timer();
    private int replacedSymbolicExpressions = 0;
    private final LogManager logger;

    public ConstraintsStrengthenOperator(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ValueAnalysisState> strengthen(ValueAnalysisState pStateToStrengthen, ConstraintsState pStrengtheningState, CFAEdge pEdge) {
        this.totalTime.start();
        try {
            ValueAnalysisState newState = pStateToStrengthen;
            if (this.simplifySymbolics) {
                newState = this.simplifySymbolicValues(newState, pStrengtheningState, pEdge);
            }
            if (!newState.equals(pStateToStrengthen)) {
                Set<ValueAnalysisState> set = Collections.singleton(newState);
                return set;
            }
            Collection<ValueAnalysisState> collection = null;
            return collection;
        }
        finally {
            this.totalTime.stop();
        }
    }

    private ValueAnalysisState simplifySymbolicValues(ValueAnalysisState pValueState, ConstraintsState pConstraints, CFAEdge pEdge) {
        if (pEdge.getEdgeType() != CFAEdgeType.AssumeEdge) {
            return pValueState;
        }
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        for (Map.Entry<MemoryLocation, ValueAnalysisState.ValueAndType> e : pValueState.getConstants()) {
            MemoryLocation currLoc;
            SymbolicValue castVal;
            Value currV = e.getValue().getValue();
            Type valueType = e.getValue().getType();
            if (!(currV instanceof SymbolicValue) || this.isSimpleSymbolicValue((SymbolicValue)currV) || !this.isIndependentInValueState(castVal = (SymbolicValue)currV, currLoc = e.getKey(), pValueState) || !this.doesNotAppearInConstraints(castVal, pConstraints)) continue;
            SymbolicExpression newIdentifier = factory.asConstant(factory.newIdentifier(e.getKey()), valueType);
            pValueState.assignConstant(currLoc, (Value)newIdentifier, valueType);
            this.logger.log(Level.FINE, new Object[]{"Replaced %s with %s", currV, newIdentifier});
            ++this.replacedSymbolicExpressions;
        }
        return pValueState;
    }

    private boolean doesNotAppearInConstraints(SymbolicValue pValue, ConstraintsState pConstraints) {
        Collection<SymbolicIdentifier> identifiersInValue = SymbolicValues.getContainedSymbolicIdentifiers(pValue);
        Collection<SymbolicIdentifier> identifiersInConstraints = SymbolicValues.getContainedSymbolicIdentifiers(pConstraints);
        return this.containsAnyOf(identifiersInConstraints, identifiersInValue);
    }

    private boolean isSimpleSymbolicValue(SymbolicValue pValue) {
        return pValue instanceof SymbolicIdentifier || pValue instanceof ConstantSymbolicExpression || pValue instanceof Constraint;
    }

    private boolean isIndependentInValueState(SymbolicValue pValue, MemoryLocation pMemLoc, ValueAnalysisState pState) {
        ValueAnalysisState stateWithoutValue = ValueAnalysisState.copyOf(pState);
        stateWithoutValue.forget(pMemLoc);
        Collection<SymbolicIdentifier> identifiersInValue = SymbolicValues.getContainedSymbolicIdentifiers(pValue);
        Collection<SymbolicIdentifier> identifiersInState = this.getIdentifiersInState(pState);
        return !this.containsAnyOf(identifiersInState, identifiersInValue);
    }

    private boolean containsAnyOf(Collection<SymbolicIdentifier> pContainer, Collection<SymbolicIdentifier> pSelection) {
        Collection<SymbolicIdentifier> biggerCollection;
        Collection<SymbolicIdentifier> smallerCollection;
        if (pContainer.size() <= pSelection.size()) {
            smallerCollection = pContainer;
            biggerCollection = pSelection;
        } else {
            smallerCollection = pSelection;
            biggerCollection = pContainer;
        }
        for (SymbolicIdentifier i : smallerCollection) {
            if (!biggerCollection.contains(i)) continue;
            return true;
        }
        return false;
    }

    private Collection<SymbolicIdentifier> getIdentifiersInState(ValueAnalysisState pState) {
        return FluentIterable.from(pState.getConstants()).transform(e -> ((ValueAnalysisState.ValueAndType)e.getValue()).getValue()).filter(SymbolicValue.class).transformAndConcat(SymbolicValues::getContainedSymbolicIdentifiers).copyInto(new HashSet());
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        out.println("Total time for strengthening by ConstraintsCPA: " + this.totalTime);
        out.println("Replaced symbolic expressions: " + this.replacedSymbolicExpressions);
    }

    @Override
    public @Nullable String getName() {
        return this.getClass().getSimpleName();
    }
}

