/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.ast.ACharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ExpressionTransformer {
    protected final String functionName;
    protected ValueAnalysisState valueState;

    public ExpressionTransformer(String pFunctionName, ValueAnalysisState pValueState) {
        this.functionName = pFunctionName;
        this.valueState = pValueState;
    }

    protected Value createNumericValue(long pValue) {
        return new NumericValue(pValue);
    }

    protected Value createNumericValue(BigDecimal pValue) {
        return new NumericValue(pValue);
    }

    protected Value createNumericValue(BigInteger pValue) {
        return new NumericValue(pValue);
    }

    public SymbolicExpression visit(AIdExpression pIastIdExpression) {
        MemoryLocation memLoc = this.getMemoryLocation(pIastIdExpression.getDeclaration());
        Type idType = pIastIdExpression.getExpressionType();
        if (this.valueState.contains(memLoc)) {
            Value idValue = this.valueState.getValueFor(memLoc);
            return SymbolicValueFactory.getInstance().asConstant(idValue, idType).copyForLocation(memLoc);
        }
        return null;
    }

    private MemoryLocation getMemoryLocation(ASimpleDeclaration pDeclaration) {
        if (pDeclaration instanceof ADeclaration && ((ADeclaration)pDeclaration).isGlobal()) {
            return MemoryLocation.parseExtendedQualifiedName(pDeclaration.getName());
        }
        return MemoryLocation.forLocalVariable(this.functionName, pDeclaration.getName());
    }

    public SymbolicExpression visit(AIntegerLiteralExpression pIastIntegerLiteralExpression) {
        BigInteger value = pIastIntegerLiteralExpression.getValue();
        Type intType = pIastIntegerLiteralExpression.getExpressionType();
        return SymbolicValueFactory.getInstance().asConstant(this.createNumericValue(value), intType);
    }

    public SymbolicExpression visit(ACharLiteralExpression pIastCharLiteralExpression) {
        long castValue = pIastCharLiteralExpression.getCharacter();
        Type charType = pIastCharLiteralExpression.getExpressionType();
        return SymbolicValueFactory.getInstance().asConstant(this.createNumericValue(castValue), charType);
    }

    public SymbolicExpression visit(AFloatLiteralExpression pIastFloatLiteralExpression) {
        BigDecimal value = pIastFloatLiteralExpression.getValue();
        Type floatType = pIastFloatLiteralExpression.getExpressionType();
        return SymbolicValueFactory.getInstance().asConstant(this.createNumericValue(value), floatType);
    }
}

