/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPAStatistics;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class SymbolicValueAnalysisPrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment delegate;
    private final SymbolicStatistics symbolicStats;

    public SymbolicValueAnalysisPrecisionAdjustment(ValueAnalysisCPAStatistics pStats, CFA pCfa, ValueAnalysisPrecisionAdjustment.PrecAdjustmentOptions pOptions, ValueAnalysisPrecisionAdjustment.PrecAdjustmentStatistics pStatistics, SymbolicStatistics pSymbolicStats) {
        this.delegate = new ValueAnalysisPrecisionAdjustment(pStats, pCfa, pOptions, pStatistics);
        this.symbolicStats = pSymbolicStats;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, Function<AbstractState, AbstractState> pStateProjection, AbstractState pFullState) throws CPAException, InterruptedException {
        Preconditions.checkState((boolean)(pState instanceof ValueAnalysisState), (String)"State not instance of ValueAnalysisState, but %s", (Object)pState.getClass().getSimpleName());
        ValueAnalysisState valState = (ValueAnalysisState)pState;
        this.symbolicStats.symbolicValuesBefore.setNextValue(this.getSymbolicValueCount(valState));
        Optional<PrecisionAdjustmentResult> maybeAdjusted = this.delegate.prec(pState, pPrecision, pStates, pStateProjection, pFullState);
        if (maybeAdjusted.isPresent()) {
            ValueAnalysisState newValState = (ValueAnalysisState)maybeAdjusted.orElseThrow().abstractState();
            this.symbolicStats.symbolicValuesAfter.setNextValue(this.getSymbolicValueCount(newValState));
        }
        return maybeAdjusted;
    }

    private int getSymbolicValueCount(ValueAnalysisState pState) {
        return (int)pState.getConstants().stream().filter(e -> ((ValueAnalysisState.ValueAndType)e.getValue()).getValue() instanceof SymbolicValue).count();
    }

    public static class SymbolicStatistics
    implements Statistics {
        private final StatInt symbolicValuesBefore = new StatInt(StatKind.SUM, "Symbolic values before refinement");
        private final StatInt symbolicValuesAfter = new StatInt(StatKind.SUM, "Symbolic values after refinement");

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsWriter.writingStatisticsTo(pOut).put(this.symbolicValuesBefore).put(this.symbolicValuesAfter);
        }

        @Override
        public String getName() {
            return SymbolicValueAnalysisPrecisionAdjustment.class.getSimpleName();
        }
    }
}

