/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.states.MemoryLocationValueHandler;

@Options(prefix="cpa.value.symbolic")
public class SymbolicValueAssigner
implements MemoryLocationValueHandler {
    @Option(description="If this option is set to true, an own symbolic identifier is assigned to each struct member when handling non-deterministic structs.")
    private boolean handleStructs = true;
    @Option(description="If this option is set to true, an own symbolic identifier is assigned to each array slot when handling non-deterministic arrays of fixed length. If the length of the array can't be determined, it won't be handled in either cases.")
    private boolean handleArrays = false;
    @Option(description="Default size of arrays whose length can't be determined.")
    private int defaultArraySize = 20;
    @Option(description="Whether to handle non-deterministic pointers in symbolic value analysis.")
    private boolean handlePointers = true;

    public SymbolicValueAssigner(Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
    }

    @Override
    public void handle(MemoryLocation pVarLocation, Type pVarType, ValueAnalysisState pState, ExpressionValueVisitor pValueVisitor) throws UnrecognizedCodeException {
        if (this.isEligibleForSymbolicValue(pVarType)) {
            this.assignNewSymbolicIdentifier(pState, pVarLocation, pVarType, pValueVisitor);
        } else {
            pState.forget(pVarLocation);
        }
    }

    private void assignNewSymbolicIdentifier(ValueAnalysisState pState, MemoryLocation pVarLocation, Type pVarType, ExpressionValueVisitor pValueVisitor) throws UnrecognizedCodeException {
        if (pVarType instanceof JType) {
            this.addSymbolicTracking(pState, pVarLocation, (JType)pVarType);
        } else {
            assert (pVarType instanceof CType) : "Unhandled type " + pVarType;
            this.addSymbolicTracking(pState, pVarLocation, (CType)pVarType, pValueVisitor);
        }
    }

    private void addSymbolicTracking(ValueAnalysisState pState, MemoryLocation pVarLocation, JType pVarType) {
        if (pVarType instanceof JSimpleType) {
            this.assignSymbolicIdentifier(pState, pVarLocation, pVarType);
        } else {
            pState.forget(pVarLocation);
        }
    }

    private void addSymbolicTracking(ValueAnalysisState pState, MemoryLocation pVarLocation, CType pVarType, ExpressionValueVisitor pValueVisitor) throws UnrecognizedCodeException {
        CType canonicalType = pVarType.getCanonicalType();
        if (canonicalType instanceof CCompositeType) {
            this.fillStructWithSymbolicIdentifiers(pState, pVarLocation, (CCompositeType)canonicalType, pValueVisitor);
        } else if (canonicalType instanceof CArrayType) {
            this.fillArrayWithSymbolicIdentifiers(pState, pVarLocation, (CArrayType)canonicalType, pValueVisitor);
        } else if (canonicalType instanceof CElaboratedType) {
            pState.forget(pVarLocation);
        } else {
            this.assignSymbolicIdentifier(pState, pVarLocation, pVarType);
        }
    }

    private void assignSymbolicIdentifier(ValueAnalysisState pState, MemoryLocation pVarLocation, Type pVarType) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        SymbolicIdentifier newIdentifier = factory.newIdentifier(pVarLocation);
        SymbolicExpression newIdentifierWithType = factory.asConstant(newIdentifier, pVarType);
        pState.assignConstant(pVarLocation, (Value)newIdentifierWithType, pVarType);
    }

    private void fillStructWithSymbolicIdentifiers(ValueAnalysisState pState, MemoryLocation pStructLocation, CCompositeType pStructType, ExpressionValueVisitor pValueVisitor) throws UnrecognizedCodeException {
        assert (this.handleStructs);
        List<CCompositeType.CCompositeTypeMemberDeclaration> memberDeclarations = pStructType.getMembers();
        for (CCompositeType.CCompositeTypeMemberDeclaration d : memberDeclarations) {
            String memberName = d.getName();
            @Nullable MemoryLocation memberLocation = pValueVisitor.evaluateRelativeMemLocForStructMember(pStructLocation, memberName, pStructType);
            if (memberLocation == null) continue;
            CType memberType = d.getType().getCanonicalType();
            if (memberType instanceof CCompositeType) {
                this.fillStructWithSymbolicIdentifiers(pState, memberLocation, (CCompositeType)memberType, pValueVisitor);
                continue;
            }
            this.assignSymbolicIdentifier(pState, memberLocation, memberType);
        }
    }

    private void fillArrayWithSymbolicIdentifiers(ValueAnalysisState pState, MemoryLocation pArrayLocation, CArrayType pArrayType, ExpressionValueVisitor pValueVisitor) throws UnrecognizedCodeException {
        long arraySize;
        if (!this.handleArrays) {
            pState.forget(pArrayLocation);
            return;
        }
        CExpression arraySizeExpression = pArrayType.getLength();
        if (arraySizeExpression == null) {
            arraySize = this.defaultArraySize;
        } else {
            Value arraySizeValue = arraySizeExpression.accept(pValueVisitor);
            if (!arraySizeValue.isExplicitlyKnown()) {
                arraySize = this.defaultArraySize;
            } else {
                assert (arraySizeValue instanceof NumericValue);
                arraySize = ((NumericValue)arraySizeValue).longValue();
            }
        }
        int i = 0;
        while ((long)i < arraySize) {
            MemoryLocation arraySlotMemLoc = pValueVisitor.evaluateMemLocForArraySlot(pArrayLocation, i, pArrayType);
            this.handle(arraySlotMemLoc, pArrayType.getType(), pState, pValueVisitor);
            ++i;
        }
    }

    private boolean isEligibleForSymbolicValue(Type pDeclarationType) {
        if (pDeclarationType instanceof CType) {
            CType canonicalType = ((CType)pDeclarationType).getCanonicalType();
            if (canonicalType instanceof CComplexType) {
                return this.handleStructs;
            }
            return (!(canonicalType instanceof CPointerType) || this.handlePointers) && !(canonicalType instanceof CVoidType) && !(canonicalType instanceof CTypedefType);
        }
        return true;
    }
}

