/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.refiner;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.ConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ARGTreePrecisionUpdater {
    private ARGTreePrecisionUpdater() {
    }

    public static VariableTrackingPrecision createValuePrec(ARGState pRefinementRoot, ARGReachedSet pReached, Multimap<CFANode, MemoryLocation> pValuePrecIncrement) {
        return ARGTreePrecisionUpdater.mergeValuePrecisionsForSubgraph(pRefinementRoot, pReached).withIncrement(pValuePrecIncrement);
    }

    private static VariableTrackingPrecision mergeValuePrecisionsForSubgraph(ARGState pRefinementRoot, ARGReachedSet pReached) {
        Set uniquePrecisions = Sets.newIdentityHashSet();
        for (ARGState descendant : ARGUtils.getNonCoveredStatesInSubgraph(pRefinementRoot)) {
            uniquePrecisions.add(ARGTreePrecisionUpdater.extractValuePrecision(pReached, descendant));
        }
        VariableTrackingPrecision mergedPrecision = (VariableTrackingPrecision)Iterables.getLast((Iterable)uniquePrecisions);
        for (VariableTrackingPrecision precision : uniquePrecisions) {
            mergedPrecision = mergedPrecision.join(precision);
        }
        return mergedPrecision;
    }

    private static VariableTrackingPrecision extractValuePrecision(ARGReachedSet pReached, ARGState pState) {
        return (VariableTrackingPrecision)Precisions.asIterable(pReached.asReachedSet().getPrecision(pState)).filter(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class)).get(0);
    }

    public static ConstraintsPrecision createConstraintsPrec(ARGState pRefinementRoot, ARGReachedSet pReached, ConstraintsPrecision.Increment pConstraintsPrecIncrement) {
        return ARGTreePrecisionUpdater.mergeConstraintsPrecisionsForSubgraph(pRefinementRoot, pReached).withIncrement(pConstraintsPrecIncrement);
    }

    private static ConstraintsPrecision mergeConstraintsPrecisionsForSubgraph(ARGState pRefinementRoot, ARGReachedSet pReached) {
        Set uniquePrecisions = Sets.newIdentityHashSet();
        for (ARGState descendant : ARGUtils.getNonCoveredStatesInSubgraph(pRefinementRoot)) {
            uniquePrecisions.add(ARGTreePrecisionUpdater.extractConstraintsPrecision(pReached, descendant));
        }
        ConstraintsPrecision mergedPrecision = (ConstraintsPrecision)Iterables.getLast((Iterable)uniquePrecisions);
        for (ConstraintsPrecision precision : uniquePrecisions) {
            mergedPrecision = mergedPrecision.join(precision);
        }
        return mergedPrecision;
    }

    private static ConstraintsPrecision extractConstraintsPrecision(ARGReachedSet pReached, ARGState pState) {
        return (ConstraintsPrecision)Precisions.asIterable(pReached.asReachedSet().getPrecision(pState)).filter(ConstraintsPrecision.class).get(0);
    }

    public static void updateARGTree(ARGReachedSet pReached, ARGState pRefinementRoot, Multimap<CFANode, MemoryLocation> pValuePrecIncrement, ConstraintsPrecision.Increment pConstraintsPrecIncrement) throws InterruptedException {
        ArrayList<Precision> precisions = new ArrayList<Precision>(2);
        precisions.add(ARGTreePrecisionUpdater.createValuePrec(pRefinementRoot, pReached, pValuePrecIncrement));
        precisions.add(ARGTreePrecisionUpdater.createConstraintsPrec(pRefinementRoot, pReached, pConstraintsPrecIncrement));
        ArrayList<Predicate<? super Precision>> precisionTypes = new ArrayList<Predicate<? super Precision>>(2);
        precisionTypes.add(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
        precisionTypes.add(Predicates.instanceOf(ConstraintsPrecision.class));
        pReached.removeSubtree(pRefinementRoot, precisions, precisionTypes);
    }
}

