/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.refiner;

import com.google.common.collect.ImmutableList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Optional;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.PathPosition;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisInformation;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ForgettingCompositeState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.SymbolicEdgeInterpolator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.interpolant.SymbolicInterpolant;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.InterpolantManager;
import org.sosy_lab.cpachecker.util.refinement.StrongestPostOperator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

@Options(prefix="cpa.value.symbolic.refinement")
public class ElementTestingSymbolicEdgeInterpolator
implements SymbolicEdgeInterpolator {
    @Option(description="Whether to try to not use any constraints in refinement")
    private boolean avoidConstraints = true;
    @Option(description="The refinement strategy to use")
    private RefinementStrategy strategy = RefinementStrategy.CONSTRAINTS_FIRST;
    private final FeasibilityChecker<ForgettingCompositeState> checker;
    private final StrongestPostOperator<ForgettingCompositeState> strongestPost;
    private final InterpolantManager<ForgettingCompositeState, SymbolicInterpolant> interpolantManager;
    private final MachineModel machineModel;
    private ImmutableList<SymbolicStateReducer> stateReducers;
    private int currentReducerIndex = 0;
    private final ShutdownNotifier shutdownNotifier;
    private Precision valuePrecision;
    private int interpolationQueries = 0;

    public ElementTestingSymbolicEdgeInterpolator(FeasibilityChecker<ForgettingCompositeState> pChecker, StrongestPostOperator<ForgettingCompositeState> pStrongestPost, InterpolantManager<ForgettingCompositeState, SymbolicInterpolant> pInterpolantManager, Configuration pConfig, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.checker = pChecker;
        this.strongestPost = pStrongestPost;
        this.interpolantManager = pInterpolantManager;
        this.shutdownNotifier = pShutdownNotifier;
        this.valuePrecision = VariableTrackingPrecision.createStaticPrecision(pConfig, pCfa.getVarClassification(), ValueAnalysisCPA.class);
        this.machineModel = pCfa.getMachineModel();
        switch (this.strategy) {
            case ALTERNATING: {
                this.stateReducers = ImmutableList.of((Object)new ConstraintsFirstReducer(), (Object)new ValuesFirstReducer());
                break;
            }
            case CONSTRAINTS_FIRST: {
                this.stateReducers = ImmutableList.of((Object)new ConstraintsFirstReducer());
                break;
            }
            case VALUES_FIRST: {
                this.stateReducers = ImmutableList.of((Object)new ValuesFirstReducer());
                break;
            }
            case VALUES_ONLY: {
                this.stateReducers = ImmutableList.of((Object)new ValuesOnlyReducer());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled strategy: " + this.strategy));
            }
        }
        if (this.avoidConstraints) {
            this.stateReducers = Collections3.transformedImmutableListCopy(this.stateReducers, x$0 -> new AvoidConstraintsReducer((SymbolicStateReducer)x$0));
        }
    }

    @Override
    public SymbolicInterpolant deriveInterpolant(ARGPath pErrorPath, CFAEdge pCurrentEdge, Deque<ForgettingCompositeState> pCallstack, PathPosition pLocationInPath, SymbolicInterpolant pInputInterpolant) throws CPAException, InterruptedException {
        Optional<ForgettingCompositeState> maybeSuccessor;
        this.interpolationQueries = 0;
        ForgettingCompositeState originState = pInputInterpolant.reconstructState();
        if (pCurrentEdge == null) {
            PathIterator it = pLocationInPath.fullPathIterator();
            Optional<ForgettingCompositeState> intermediate = Optional.of(originState);
            while (intermediate.isPresent()) {
                intermediate = this.strongestPost.getStrongestPost(intermediate.orElseThrow(), this.valuePrecision, it.getOutgoingEdge());
                it.advance();
                if (!it.isPositionWithState()) continue;
            }
            maybeSuccessor = intermediate;
        } else {
            maybeSuccessor = this.strongestPost.getStrongestPost(originState, this.valuePrecision, pCurrentEdge);
        }
        if (!maybeSuccessor.isPresent()) {
            return this.interpolantManager.getFalseInterpolant();
        }
        ForgettingCompositeState successorState = maybeSuccessor.orElseThrow();
        if (originState.equals(successorState)) {
            return pInputInterpolant;
        }
        ARGPath suffix = pLocationInPath.iterator().getSuffixExclusive();
        if (!this.isPathFeasible(suffix, ForgettingCompositeState.getInitialState(this.machineModel))) {
            return this.interpolantManager.getTrueInterpolant();
        }
        ForgettingCompositeState necessaryInfo = this.getReducer().reduce(successorState, suffix);
        return this.interpolantManager.createInterpolant(necessaryInfo);
    }

    private SymbolicStateReducer getReducer() {
        SymbolicStateReducer reducer = (SymbolicStateReducer)this.stateReducers.get(this.currentReducerIndex);
        this.currentReducerIndex %= this.stateReducers.size();
        return reducer;
    }

    private boolean isPathFeasible(ARGPath pRemainingErrorPath, ForgettingCompositeState pState) throws CPAException, InterruptedException {
        ++this.interpolationQueries;
        return this.checker.isFeasible(pRemainingErrorPath, pState);
    }

    @Override
    public int getNumberOfInterpolationQueries() {
        return this.interpolationQueries;
    }

    private class AvoidConstraintsReducer
    implements SymbolicStateReducer {
        private SymbolicStateReducer delegate;

        AvoidConstraintsReducer(SymbolicStateReducer pDelegate) {
            this.delegate = pDelegate;
        }

        @Override
        public ForgettingCompositeState reduce(ForgettingCompositeState pSuccessorState, ARGPath pSuffix) throws InterruptedException, CPAException {
            ForgettingCompositeState reducedState = pSuccessorState;
            if (reducedState.getConstraintsSize() > 0 && ElementTestingSymbolicEdgeInterpolator.this.isPathFeasible(pSuffix, reducedState = this.removeAllConstraints(reducedState))) {
                reducedState = pSuccessorState;
            }
            return this.delegate.reduce(reducedState, pSuffix);
        }

        private ForgettingCompositeState removeAllConstraints(ForgettingCompositeState pState) {
            return new ForgettingCompositeState(pState.getValueState(), new ConstraintsState(new HashSet<Constraint>()));
        }
    }

    private class ConstraintsFirstReducer
    implements SymbolicStateReducer {
        private SymbolicStateReducer valueReducer;
        private SymbolicStateReducer constraintsReducer;

        private ConstraintsFirstReducer() {
            this.valueReducer = new ValuesOnlyReducer();
            this.constraintsReducer = new ConstraintsOnlyReducer();
        }

        @Override
        public ForgettingCompositeState reduce(ForgettingCompositeState pSuccessorState, ARGPath pSuffix) throws InterruptedException, CPAException {
            return this.valueReducer.reduce(this.constraintsReducer.reduce(pSuccessorState, pSuffix), pSuffix);
        }
    }

    private class ValuesFirstReducer
    implements SymbolicStateReducer {
        private SymbolicStateReducer valueReducer;
        private SymbolicStateReducer constraintsReducer;

        private ValuesFirstReducer() {
            this.valueReducer = new ValuesOnlyReducer();
            this.constraintsReducer = new ConstraintsOnlyReducer();
        }

        @Override
        public ForgettingCompositeState reduce(ForgettingCompositeState pSuccessorState, ARGPath pSuffix) throws InterruptedException, CPAException {
            return this.constraintsReducer.reduce(this.valueReducer.reduce(pSuccessorState, pSuffix), pSuffix);
        }
    }

    private class ConstraintsOnlyReducer
    implements SymbolicStateReducer {
        private ConstraintsOnlyReducer() {
        }

        @Override
        public ForgettingCompositeState reduce(ForgettingCompositeState pSuccessorState, ARGPath pSuffix) throws InterruptedException, CPAException {
            for (Constraint c : pSuccessorState.getTrackedConstraints()) {
                ElementTestingSymbolicEdgeInterpolator.this.shutdownNotifier.shutdownIfNecessary();
                pSuccessorState.forget(c);
                if (!ElementTestingSymbolicEdgeInterpolator.this.isPathFeasible(pSuffix, pSuccessorState)) continue;
                pSuccessorState.remember(c);
            }
            return pSuccessorState;
        }
    }

    private class ValuesOnlyReducer
    implements SymbolicStateReducer {
        private ValuesOnlyReducer() {
        }

        @Override
        public ForgettingCompositeState reduce(ForgettingCompositeState pSuccessorState, ARGPath pSuffix) throws InterruptedException, CPAException {
            for (MemoryLocation l : pSuccessorState.getTrackedMemoryLocations()) {
                ElementTestingSymbolicEdgeInterpolator.this.shutdownNotifier.shutdownIfNecessary();
                ValueAnalysisInformation forgottenInfo = pSuccessorState.forget(l);
                if (!ElementTestingSymbolicEdgeInterpolator.this.isPathFeasible(pSuffix, pSuccessorState)) continue;
                pSuccessorState.remember(l, forgottenInfo);
            }
            return pSuccessorState;
        }
    }

    private static interface SymbolicStateReducer {
        public ForgettingCompositeState reduce(ForgettingCompositeState var1, ARGPath var2) throws InterruptedException, CPAException;
    }

    private static enum RefinementStrategy {
        CONSTRAINTS_FIRST,
        VALUES_FIRST,
        ALTERNATING,
        VALUES_ONLY;

    }
}

